/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary;

import info.jdictionary.JDictionary;
import info.jdictionary.events.NewsEvent;
import info.jdictionary.listeners.NewsListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class NewsChecker
extends Thread {
    private URL url;
    private JDictionary jDictionary;
    private int latestVersion;
    private Vector newsListeners = new Vector();

    public NewsChecker(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        try {
            this.url = new URL(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getString("InfoServerURL")))).append("/").append(JDictionary.getString("LatestNewsFile")))));
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
    }

    public void run() {
        this.latestVersion = this.getLatestVersion();
        if (this.latestVersion > this.jDictionary.getPrefs().lastCheckedNewsVersion) {
            this.notifyNewsListeners(this.latestVersion);
        }
    }

    private int getLatestVersion() {
        if (this.url == null) {
            return 0;
        }
        byte[] b = new byte[32];
        try {
            DataInputStream dis = new DataInputStream(this.url.openStream());
            dis.read(b);
        }
        catch (IOException e) {
            int n = 0;
            return n;
        }
        Float f = new Float(new String(b));
        return f.intValue();
    }

    public int getLatest() {
        return this.latestVersion;
    }

    void notifyNewsListeners(int latestVersion) {
        Vector tmpList;
        String newsURL = JDictionary.getString("NewsPage");
        NewsEvent event = new NewsEvent(this, latestVersion, newsURL);
        NewsChecker newsChecker = this;
        synchronized (newsChecker) {
            tmpList = (Vector)this.newsListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((NewsListener)tmpList.elementAt(i)).newsUpdated(event);
        }
    }

    public synchronized void addNewsListener(NewsListener listener) {
        this.newsListeners.addElement(listener);
    }

    public synchronized void removeNewsListener(NewsListener listener) {
        this.newsListeners.removeElement(listener);
    }
}

