/*
 * 01/09/2002 - 20:43:57
 *
 * PluginDownloader.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.pluginstuff;

import javax.swing.*;
import javax.swing.text.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import javax.swing.border.*;
import java.util.*;
import info.jdictionary.*;
import info.jdictionary.gui.*;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.events.PluginFilesChangeEvent;
import info.jdictionary.listeners.PluginFilesChangeListener;

public class PluginDownloader extends JPanel implements Runnable {
    JDictionary jDictionary;
    PluginManager pluginManager;
    ArrayList pluginInfoPanels = new ArrayList();
    JPanel jPanel1 = new JPanel();
    JPanel pluginInfoOutputPanel = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel informationPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel messageLabel;
    ImageIcon spacerLine = ImageBank.Spacer;
    ImageIcon headerImage = ImageBank.DownloadHeader;
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.Y_AXIS);
    BoxLayout boxLayout2 = new BoxLayout(pluginInfoOutputPanel, BoxLayout.Y_AXIS);
    BoxLayout boxLayout3 = new BoxLayout(informationPanel, BoxLayout.Y_AXIS);
    boolean success;

    public PluginDownloader(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
        this.pluginManager = jDictionary.getPluginManager();
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        setLayout(boxLayout1);
        setBackground(Color.white);
        setAlignmentX((float) 0.0);
        setMinimumSize(new Dimension(400, 300));
        setPreferredSize(new Dimension(400, 300));

        jPanel1.setLayout(borderLayout1);
        jPanel1.setBackground(Color.white);
        jPanel1.setAlignmentX((float) 0.0);
        jPanel1.setMinimumSize(new Dimension(300, 100));
        jPanel1.setPreferredSize(new Dimension(1000, 1000));
        jPanel1.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("AvailPlugins")));
        jPanel1.add(jScrollPane1, BorderLayout.CENTER);

        jPanel2.setBackground(Color.white);
        jPanel2.setAlignmentX((float) 0.0);
        jPanel2.setMinimumSize(new Dimension(0, 80));
        jPanel2.setPreferredSize(new Dimension(0, 160));
        jPanel2.setLayout(borderLayout3);
        jPanel2.setBorder(BorderFactory.createTitledBorder(JDictionary.getString("Tips")));
        jPanel2.add(jScrollPane2);

        jLabel1.setBackground(Color.white);
        jLabel1.setMinimumSize(new Dimension(300, 65));
        jLabel1.setPreferredSize(new Dimension(500, 65));
        jLabel1.setIcon(headerImage);

        jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.getViewport().setBackground(Color.white);
        jScrollPane2.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane2.getViewport().add(informationPanel, null);
        jScrollPane1.getViewport().add(pluginInfoOutputPanel, null);

        pluginInfoOutputPanel.setBackground(Color.white);
        pluginInfoOutputPanel.setLayout(borderLayout2);

        informationPanel.setLayout(boxLayout3);
        informationPanel.setBackground(Color.white);

        addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip1"), IconBank.bulb, 0));
        addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip2"), IconBank.bulb, 0));


        add(Box.createRigidArea(new Dimension(0, 3)));
        add(jLabel1, null);
        add(jPanel1, null);
        add(Box.createRigidArea(new Dimension(0, 10)));
        add(jPanel2, null);
    }

    public void addToOutputPanel(String message, ImageIcon icon) {
        messageLabel = new JLabel(message, icon, 0);
        SwingUtilities.invokeLater(new Runnable() {
                                       public void run() {
                                           pluginInfoOutputPanel.removeAll();
                                           pluginInfoOutputPanel.add(messageLabel);
                                           pluginInfoOutputPanel.validate();
                                       }
                                   }
                                  );
    }


    public void run() {
        addToOutputPanel(JDictionary.getString("DownloadingInfo"), IconBank.hourGlass);
        Object[] sheets = downloadPluginInfoSheets();
        if (sheets != null) {
            showPluginInfos(sheets);
            addToInformationPanel(new JLabel(JDictionary.getString("AvailPluginsPref") + sheets.length + JDictionary.getString("AvailPluginsPostf"), IconBank.info, 0));
            success = true;
        } else {
            addToOutputPanel(JDictionary.getString("NetError"), IconBank.caution);
            addToInformationPanel(new JLabel(JDictionary.getString("PossibleProblems"), IconBank.caution, 0));
            addToInformationPanel(new JLabel(JDictionary.getString("Problem1")));
            addToInformationPanel(new JLabel(JDictionary.getString("Problem2/1")));
            addToInformationPanel(new JLabel(JDictionary.getString("Problem2/2")));
            addToInformationPanel(new JLabel(JDictionary.getString("Problem3")));
            addToInformationPanel(new JLabel(JDictionary.getString("DownloadTip3"), IconBank.bulb, 0));
            }
    }

    Object[] downloadPluginInfoSheets() {
        URL url = null;
        Object[] sheets = null;

        try {
            url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoSheetsFile") + "_" + JDictionary.getLanguage());
        } catch (java.net.MalformedURLException e) {}
        sheets = PluginInfoSheet.CreateInfoSheets(url);
        if (sheets != null)
            return sheets;

        try {
            url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoSheetsFile"));
        } catch (java.net.MalformedURLException e) {}
        sheets = PluginInfoSheet.CreateInfoSheets(url);
        return sheets;
    }


    void showPluginInfos(final Object[] sheets) {
        SwingUtilities.invokeLater(new Runnable() {
                                       public void run() {
                                           pluginInfoOutputPanel.removeAll();
                                           pluginInfoOutputPanel.setLayout(boxLayout2);

                                       for (int n = 0; n < sheets.length; n++) {
                                               PluginInfoAndDownloadPanel pluginInfoAndDownloadPanel = new PluginInfoAndDownloadPanel(jDictionary, (PluginInfoSheet) sheets[n]);
                                               pluginInfoOutputPanel.add(pluginInfoAndDownloadPanel);
                                               pluginInfoPanels.add(pluginInfoAndDownloadPanel);

                                           if (n < sheets.length - 1) {
                                                   JLabel spacer = new JLabel(spacerLine);
                                                   spacer.setPreferredSize(new Dimension(200, 1));
                                                   pluginInfoOutputPanel.add(spacer);
                                               }

                                           }
                                           pluginInfoOutputPanel.validate();
                                           jScrollPane1.validate();
                                       }
                                   }
                                  );
    }


    void addToInformationPanel(final JLabel label) {
        SwingUtilities.invokeLater(new Runnable() {
                                       public void run() {
                                           label.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
                                           informationPanel.add(label);
                                           jScrollPane2.validate();
                                           jScrollPane2.getVerticalScrollBar().setValue(jScrollPane2.getVerticalScrollBar().getMaximum());
                                       }
                                   }
                                  );
    }

    public void updateInfoPanelsState() {
        for (int n = 0; n < pluginInfoPanels.size(); n++)
            ((PluginInfoAndDownloadPanel) pluginInfoPanels.get(n)).updateState();
    }

    public boolean isSuccess() {
      return success;
    }

    class PluginInfoAndDownloadPanel extends JPanel {
        JDictionary jDictionary;
        boolean downloading = false;
        boolean activated = true;
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane1 = new JScrollPane();
        BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.X_AXIS);
        BoxLayout boxLayout2 = new BoxLayout(jPanel1, BoxLayout.Y_AXIS);
        BoxLayout boxLayout3 = new BoxLayout(jPanel3, BoxLayout.Y_AXIS);
        JButton button = new JButton();
        PluginInfoSheet sheet;
        PluginInfoSheetPanel sheetPanel;
        Downloader downloader;
        JProgressBar progressBar;


        public PluginInfoAndDownloadPanel(JDictionary jDictionary, PluginInfoSheet sheet) {
            this.jDictionary = jDictionary;
            this.sheet = sheet;
            sheetPanel = new PluginInfoSheetPanel(sheet);

            pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener() {
                public void pluginAdded(PluginStructureChangeEvent e) {
                    updateState();
                }
                public void pluginRemoved(PluginStructureChangeEvent e) {
                    updateState();
                }
            });


            try {
                jbInit();
            } catch (Exception e) {
                e.printStackTrace();
            }
            updateState();
        }

        private void jbInit() throws Exception {
            setBackground(new Color(255, 255, 255));
            setPreferredSize(new Dimension(370, 85));
            setMinimumSize(new Dimension(300, 85));
            setLayout(boxLayout1);
            setBorder(BorderFactory.createEmptyBorder(10, 3, 10, 3));
            setAlignmentX((float) 0.0);

            jPanel1.setBackground(new Color(255, 255, 255));
            jPanel1.setPreferredSize(new Dimension(160, 55));
            jPanel1.setLayout(boxLayout2);

            jPanel2.setBackground(new Color(255, 255, 255));

            jPanel3.setBackground(new Color(255, 255, 255));
            jPanel3.setAlignmentX((float)0.0);
            jPanel3.setLayout(boxLayout3);

            jScrollPane1.setPreferredSize(new Dimension(300, 70));
            jScrollPane1.setMinimumSize(new Dimension(100, 70));

            button.setAlignmentX((float)0.0);
            button.setMargin(new Insets(0, 3, 0, 3));
            button.addActionListener(new java.awt.event.ActionListener() {
                                         public void actionPerformed(ActionEvent e) {
                                             button_actionPerformed(e);
                                         }
                                     }
                                    );

            jPanel1.add(jPanel3);
            jPanel1.add(Box.createVerticalGlue());
            jPanel1.add(button);
            jPanel2.add(jPanel1);
            add(jScrollPane1);
            add(jPanel2);
            jScrollPane1.getViewport().add(sheetPanel, 0);
        }


        void startDownload() {
            addToInformationPanel(new JLabel(JDictionary.getString("DownloadingFile") + sheet.getName(), IconBank.FolderIn, 0));
            downloading = true;
            showProgressBar();
            downloader = new Downloader();
            downloader.start();
            updateState();
        }


        void showProgressBar() {
            //this is in the event dispatcher thread.
            jPanel3.removeAll();
            progressBar = new JProgressBar(0, new Integer(sheet.getSize()).intValue());
            progressBar.setPreferredSize(new Dimension(button.getWidth(), button.getHeight()));

            progressBar.setStringPainted(true);
            jPanel3.add(progressBar);
            jPanel1.validate();
            jPanel1.repaint();
        }


        synchronized void updateState() {
            SwingUtilities.invokeLater(new Runnable() {
                                           public void run() {
                                           if (downloading) {
                                                   button.setIcon(IconBank.stop);
                                                   button.setText(JDictionary.getString("StopDownloading"));
                                                   jPanel1.validate();
                                                   jPanel1.repaint();
                                                   return;
                                               }
                                              jPanel3.removeAll();
                                              JLabel label;
                                              activated = true;
                                           if (sheet.getMinJDictionaryVersion() != null && (Float.parseFloat(sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion())) {
                                                  label = new JLabel(JDictionary.getString("JDict") + sheet.getMinJDictionaryVersion() + JDictionary.getString("Needed"), IconBank.info, 0);
                                                  label.setToolTipText(JDictionary.getString("PleseUpgr") + sheet.getMinJDictionaryVersion());
                                                  jPanel3.add(label);
                                                  button.setToolTipText(JDictionary.getString("PleseUpgr") + sheet.getMinJDictionaryVersion());
                                                  button.setText(JDictionary.getString("DownInst"));
                                                  button.setIcon(IconBank.FolderIn);
                                                  button.setEnabled(false);
                                          }
                                          else
                                              if (pluginManager.isPluginFileLoaded(sheet.getFileName())) {
                                                  label = new JLabel(JDictionary.getString("AlreadyInstalled"), IconBank.info, 0);
                                                  jPanel3.add(label);
                                                  button.setText(JDictionary.getString("DownInst"));
                                                  button.setIcon(IconBank.FolderIn);
                                                  button.setEnabled(false);
                                              }
                                              else
                                                  if(pluginManager.isItAvailable(sheet.getFileName(), true)) {
                                                      activated = false;
                                                      label = new JLabel(JDictionary.getString("InstalledButDeactivated"), IconBank.info, 0);
                                                      jPanel3.add(label);
                                                      button.setText(JDictionary.getString("Activate"));
                                                      button.setIcon(IconBank.FolderIn);
                                                      button.setEnabled(true);
                                                  }
                                              else
                                                  if(pluginManager.isItAvailable(sheet.getFileName(), false) && pluginManager.isThereNewerPluginFileAvailable(sheet.getFileName())) {
                                                      label = new JLabel(JDictionary.getString("YouHaveNewerVersion"), IconBank.info, 0);
                                                      jPanel3.add(label);
                                                      button.setText(JDictionary.getString("DownInst"));
                                                      button.setIcon(IconBank.FolderIn);
                                                      button.setEnabled(false);
                                                    }

                                              else {

                                                  if (pluginManager.isItAvailable(sheet.getFileName(), false) && pluginManager.isThereNewerPluginFileAvailable(sheet.getFileName()) == false)
                                                      label = new JLabel(JDictionary.getString("NewerAvailable"), IconBank.info, 0);
                                                  else
                                                      label = new JLabel(JDictionary.getString("NotInstalled"), IconBank.info, 0);
                                                  jPanel3.add(label);
                                                  button.setText(JDictionary.getString("DownInst"));
                                                  button.setIcon(IconBank.FolderIn);
                                                  button.setEnabled(true);
                                               }
                                               jPanel1.validate();
                                               jPanel1.repaint();
                                           }

                                       }
                                      );
        }


         void button_actionPerformed(ActionEvent e) {
            if(activated == false) {
                jDictionary.getPluginManager().setActive(sheet.getFileName());
                    pluginManager.scanPlugins();
                return;
            }

            if (downloading) {
                downloading = false;
                downloader.terminate();
                return;
            }
            startDownload();
        }


        class Downloader extends Thread {

            FileDownloader fileDownloader = new FileDownloader();
            PluginDeployer deployer = new PluginDeployer();
            byte[] b;
            boolean stop = false;
            URL url = null;
            int length;

            public void terminate() {
                fileDownloader.terminate();
                addToInformationPanel(new JLabel(JDictionary.getString("DownStopPref") + sheet.getName() + JDictionary.getString("DownStopPost"), IconBank.stop, 0));
                stop = true;
                updateState();
            }

            public void run() {
                try {
                    //url = new URL(JDictionary.getString("PluginServerURL") + "/" + sheet.getFileName());
                    url = new URL(sheet.getURL());
                    length = url.openConnection().getContentLength();
                }
                catch (java.net.MalformedURLException ex) {}
                catch (java.io.IOException ex) {}

                b = fileDownloader.download(url, progressBar, length);

                if(!stop)
                    if (b != null) { //this means that the download process was successfull.
                        addToInformationPanel(new JLabel(JDictionary.getString("Installing") + sheet.getName(), IconBank.info, 0));
                        button.setEnabled(false);
                        deployer.deploy(b, sheet.getFileName());
                        pluginManager.setActive(sheet.getFileName());

                        pluginManager.addPluginStructureChangeListener(new PluginStructureChangeListener() {
                            public void pluginRemoved(PluginStructureChangeEvent e) {}
                            public void pluginAdded(PluginStructureChangeEvent e) {
                                if (pluginManager.isItInstalled(sheet))
                                    addToInformationPanel(new JLabel(sheet.getName() + JDictionary.getString("ReadyToUse"), IconBank.ThumbUp, 0));
                                else
                                    addToInformationPanel(new JLabel(JDictionary.getString("ErrorAtInstall") + sheet.getName(), IconBank.caution, 0));
                                pluginManager.removePluginStructureChangeListener(this);
                                updateState();
                            }
                        });

                        pluginManager.scanPlugins();
                    }
                    else {
                        addToInformationPanel(new JLabel(JDictionary.getString("ErrorAtDownload") + sheet.getName(), IconBank.caution, 0));

                    }
                    downloading = false;
            }
        }
    }
}