/*
 * 01/09/2002 - 20:43:57
 *
 * JDictionaryTheme.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import javax.swing.plaf.*;

public class JDictionaryTheme extends javax.swing.plaf.metal.DefaultMetalTheme {

    private final ColorUIResource primary1 = new ColorUIResource(0, 0, 0);
    private final ColorUIResource primary2 = new ColorUIResource(115, 148, 209);
    private final ColorUIResource primary3 = new ColorUIResource(136, 191, 247);
    private final ColorUIResource secondary1 = new ColorUIResource(130, 130, 130);
    private final ColorUIResource secondary2 = new ColorUIResource(180, 180, 180);
    private final ColorUIResource secondary3 = new ColorUIResource(224, 224, 224);
    private final FontUIResource menuTextFont = new FontUIResource("Dialog", 0, 12);
    private final FontUIResource controlTextFont = new FontUIResource("Dialog", 0, 12);


    public String getName() {
        return "JDictionaryTheme";
    }

    public FontUIResource getControlTextFont() {
        return controlTextFont;
    }

    public FontUIResource getMenuTextFont() {
        return menuTextFont;
    }

    protected ColorUIResource getPrimary1() {
        return primary1;
    }

    protected ColorUIResource getPrimary2() {
        return primary2;
    }

    protected ColorUIResource getPrimary3() {
        return primary3;
    }


    protected ColorUIResource getSecondary1() {
        return secondary1;
    }

    protected ColorUIResource getSecondary2() {
        return secondary2;
    }

    protected ColorUIResource getSecondary3() {
        return secondary3;
    }

}


