/*
 * 01/09/2002 - 20:43:57
 *
 * Prefs.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary;

import java.io.*;
import javax.swing.*;
import java.util.ArrayList;

public class Prefs implements Serializable {

    public Prefs() {}


    static Prefs loadPrefs(String path) {
        Prefs p;
        File f = new File(path);
        try {
            FileInputStream fin = new FileInputStream(f);
            ObjectInputStream oin = new ObjectInputStream(fin);
            p = (Prefs) oin.readObject();
        }
        catch (java.io.FileNotFoundException e) {
            p = new Prefs();
        }
        catch (java.io.StreamCorruptedException e) {
            System.out.println("loadPrefs: StreamCorrupted loading defaults");
            p = new Prefs();
        }
        catch (java.io.IOException e) {
            System.out.println("loadPrefs: IOException loading defaults");
            p = new Prefs();
        }
        catch (java.lang.ClassNotFoundException e) {
            System.out.println("loadPrefs: ClassNotFound loading defaults");
            p = new Prefs();
        }
        return p;
    }


    static void savePrefs(Prefs prefs, String path) {
        File f = new File(path);
        try {
            FileOutputStream fout = new FileOutputStream(f);
            ObjectOutputStream oout = new ObjectOutputStream(fout);
            oout.writeObject(prefs);
        }
        catch (java.io.FileNotFoundException e) {}
        catch (java.io.IOException e) {
            System.out.println("savePrefs: IOException, unable to save prefs");
        }
    }


    //fields to save
    public info.jdictionary.pluginstuff.PluginInfoSheet pluginInfoSheet;
    public String selectedNodeName;
    public String selectedLookAndFeel = "ModifiedKunststoff"; //default is the Modified Kunststoff
    public int width = 745;
    public int height = 555;
    public int dividerLocation = 200;
    public ArrayList InActivePlugins = new ArrayList();




}