/*
 * 01/09/2002 - 20:43:57
 *
 * NewJDictionaryVersionChecker.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary;

import java.net.URL;
import java.util.Vector;
import java.io.DataInputStream;
import info.jdictionary.events.NewJDictionaryVersionEvent;
import info.jdictionary.listeners.NewJDictionaryVersionListener;

public class NewJDictionaryVersionChecker extends Thread{

    private URL url;
    private float latestVersion;
    private boolean isNewerAvailable = false;
    private Vector newJDictionaryVersionListeners = new Vector();

    public NewJDictionaryVersionChecker() {
        try {
            this.url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("LatestFile"));
        }
        catch(java.net.MalformedURLException e) {this.url = null;}
    }

    public void run() {
        latestVersion = getLatestVersion();
        if(latestVersion > JDictionary.getJDictionaryVersion()) {
            isNewerAvailable = true;
            notifyNewJDictionaryVersionListeners(latestVersion);
        }
    }


    private float getLatestVersion() {
        if(url == null)
            return 0;
        byte[] b = new byte[32];
        try {
            DataInputStream dis = new DataInputStream(url.openStream());
            dis.read(b);
        } catch (java.io.IOException e) {
            return 0;
        }
        Float f = new Float(new String(b));
        return f.floatValue();
    }



    void notifyNewJDictionaryVersionListeners(float latestVersion) {
        Vector tmpList;
        NewJDictionaryVersionEvent event = new NewJDictionaryVersionEvent(this, latestVersion);
        synchronized(this) {
            tmpList = (Vector)newJDictionaryVersionListeners.clone();
        }
        for(int i = 0; i < tmpList.size(); i++) {
            ((NewJDictionaryVersionListener)tmpList.elementAt(i)).newJDictionaryVersionAvailable(event);
        }
    }

    public synchronized void addNewJDictionaryVersionListener(NewJDictionaryVersionListener listener) {
        newJDictionaryVersionListeners.addElement(listener);
    }

    public synchronized void removeNewJDictionaryVersionListener(NewJDictionaryVersionListener listener) {
        newJDictionaryVersionListeners.removeElement(listener);
    }

}