/*
 * 01/09/2002 - 20:43:57
 *
 * JDictionary.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary;

import info.jdictionary.pluginstuff.*;
import info.jdictionary.gui.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.net.URL;
import com.incors.plaf.kunststoff.*;
import info.jdictionary.modules.*;

public class JDictionary extends JFrame {
    static public ResourceBundle JDictionaryResources;
    private Prefs prefs;
    private PluginManager pluginManager;
    private PluginDownloader pluginDownloader;
    private PluginStatusChanger pluginStatusChanger;
    private JDictionaryFrame frame;
    private DefaultFrameAssembler assembler;
    private NewJDictionaryVersionChecker newJDictionaryVersionChecker = new NewJDictionaryVersionChecker();


    public JDictionary() {

        prefs = loadPrefs();
        frame = new JDictionaryFrame();
        pluginManager = new PluginManager(this);
        assembler = new DefaultFrameAssembler(this, frame);
        newJDictionaryVersionChecker.start(); //checking for new jdictionary version
        pluginManager.scanPlugins();
    }

    public JPanel getSplashScreen() {
        return new AboutPanel();
    }


    public JPanel getNoPluginInstalledScreen() {
        return new NoPluginsPanel();
    }


    public JPanel getAllPluginsDeactivatedScreen() {
        return new AllPluginsDeactivatedPanel();
    }


    public PluginStatusChanger getPluginStatusChanger() {
        if(pluginStatusChanger == null) {
            pluginStatusChanger = new PluginStatusChanger(this);
            Thread pluginStatusChangerThread = new Thread(pluginStatusChanger);
            pluginStatusChangerThread.start();
        }
        return pluginStatusChanger;
    }


    public PluginDownloader getPluginDownloader() {
        if(pluginDownloader == null || pluginDownloader.isSuccess() == false) {
            pluginDownloader = new PluginDownloader(this);
            Thread pluginDownloaderThread = new Thread(pluginDownloader);
            pluginDownloaderThread.start();
        }
        return pluginDownloader;
    }


    public NewJDictionaryVersionChecker getNewJDictionaryVersionChecker() {
        return newJDictionaryVersionChecker;
    }


    public JDictionary getJDictionary() {
        return this;
    }


    public void closeJDictionary() {
        savePrefs();
        pluginManager.removeAllPlugins();
        System.exit(0);
    }


    public void savePrefs() {
        assembler.savePrefs();
        //other items in prefs are already adjusted
        Prefs.savePrefs(prefs, getSavedDir() + getFileSeparator() + getString("SavedPrefsFileName"));
    }


    public Prefs loadPrefs() {
        return Prefs.loadPrefs(getSavedDir() + getFileSeparator() + getString("SavedPrefsFileName"));
    }


    public PluginManager getPluginManager() {
        return pluginManager;
    }


    public Prefs getPrefs() {
        return prefs;
    }


//////////static methods/////////////////////////////////

    public static void main(String[] args) {
        JDictionary jDictionary = new JDictionary();
    }


    static public String getString(String key) {
        if (JDictionaryResources == null)
            JDictionaryResources = ResourceBundle.getBundle("info.jdictionary.resource.JDictionaryResources",new Locale("en","en"));
        return JDictionaryResources.getString(key);
    }


    static public String getGlobalPluginDirPath() {
        return JDictionary.getBaseDir() + JDictionary.getFileSeparator() + getString("PluginDirName");
    }


    public static float getJDictionaryVersion() {
        return Float.parseFloat(getString("JDictionaryVersion"));
    }


    public static String getUserHome() {
        return System.getProperty("user.home");
    }


    public static String getBaseDir() {
        return System.getProperty("user.dir");
    }


    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }


    public static String getLanguage() {
        return System.getProperty("user.language");
    }


    public static String getSavedDir() {
        File dir = new File(getUserHome() + getFileSeparator() + getString("SavedDirName"));
        if(!dir.exists() || !dir.isDirectory())
            dir.mkdir();
        return dir.getAbsolutePath();
    }


    public static String getPluginDirPath() {
        File dir = new File(getSavedDir() + getFileSeparator() + getString("PluginDirName"));
        if(!dir.exists() || !dir.isDirectory())
            dir.mkdir();
        return dir.getAbsolutePath();
    }
}