/*
 * 01/09/2002 - 20:43:57
 *
 * FileDownloader.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary;

import javax.swing.*;
import java.net.*;
import java.io.*;

public class FileDownloader {
    public boolean stop = false;

    public void terminate() {
        stop = true;
    }

    public byte[] download(URL url, JProgressBar progressBar, int fileSize) {
        DataInputStream din = null;
        int offset = 0;
        int length = 2048;
        int temp = 0;
        byte[] b = new byte[fileSize];
        try {
            din = new DataInputStream(url.openStream());
        }
        catch (java.io.IOException ex) {}

        while (true) {
            if (stop) {
                return null;
            }
            try {
                temp = din.read(b, offset, length);
            } catch (java.io.IOException e) {
                return null;
            }
            if (temp == -1) {
                return b;
            }

            offset = offset + temp;
            if (fileSize - offset < length)
                length = fileSize - offset;
            notifyProgressBar(progressBar, offset, fileSize);

        }
    }

    void notifyProgressBar(final JProgressBar progressBar, final int currentState, final int topValue) {
        SwingUtilities.invokeLater(new Runnable() {
                                       public void run() {
                                       if (progressBar != null) {
                                               progressBar.setValue(currentState);
                                               progressBar.setString(currentState / 1024 + " " + JDictionary.getString("KB of") + " " + topValue / 1024 + " " + JDictionary.getString("KB"));
                                               progressBar.validate();
                                               progressBar.repaint();
                                           }
                                       }
                                   }
                                  );
    }
}