/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.pluginstuff;

import info.jdictionary.JDictionary;
import info.jdictionary.Plugin;
import info.jdictionary.Prefs;
import info.jdictionary.events.PluginFilesChangeEvent;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.listeners.PluginFilesChangeListener;
import info.jdictionary.listeners.PluginScanFinishedListener;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.pluginstuff.DirFilter;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PluginManager {
    HashMap plugins = new HashMap();
    String[] pluginFiles;
    JDictionary jDictionary;
    PluginInfoSheet selectedPlugin;
    String selectedSubPlugin;
    Vector pluginStructureChangeListeners = new Vector();
    Vector pluginFilesChangeListeners = new Vector();
    Vector pluginSelectionListeners = new Vector();
    Vector pluginScanFinishedListeners = new Vector();
    ScanThread scanThread;

    public PluginManager(JDictionary jDictionary) {
        this.jDictionary = jDictionary;
    }

    void pushPlugin(PluginInfoSheet infoSheet, Plugin plugin) {
        if (!this.plugins.containsKey(infoSheet)) {
            this.plugins.put(infoSheet, new ArrayList());
        }
        ((ArrayList)this.plugins.get(infoSheet)).add(plugin);
    }

    public ArrayList getPlugin(PluginInfoSheet infoSheet) {
        if (this.plugins.containsKey(infoSheet)) {
            return (ArrayList)this.plugins.get(infoSheet);
        }
        return null;
    }

    void removePlugin(PluginInfoSheet infoSheet) {
        Iterator it = ((AbstractList)this.getPlugin(infoSheet)).iterator();
        while (it.hasNext()) {
            ((Plugin)it.next()).stop();
        }
        this.plugins.remove(infoSheet);
        this.notifyPluginRemovedListeners(infoSheet);
    }

    public void removeAllPlugins() {
        Object[] sheets = this.getSheets();
        int n = 0;
        while (n < sheets.length) {
            this.removePlugin((PluginInfoSheet)sheets[n++]);
        }
    }

    public Object[] getSheets() {
        return this.plugins.keySet().toArray();
    }

    public int getNumberOfLoadedPlugins() {
        return this.plugins.size();
    }

    public int getNumberOfAvailablePlugins() {
        return this.getAvailablePluginFileNames().length;
    }

    public void checkPluginDirForChanges() {
        File f = new File(JDictionary.getPluginDirPath());
        String[] fileList = f.list(new DirFilter(".jar"));
        String[] knownPluginFiles = this.getAvailablePluginFileNames();
        if (knownPluginFiles.length != fileList.length) {
            this.notifyPluginFilesChangedListeners(fileList);
        } else {
            for (int i = 0; i < knownPluginFiles.length; ++i) {
                int j;
                for (j = 0; j < fileList.length && !fileList[j].equals(knownPluginFiles[i]); ++j) {
                }
                if (j != fileList.length) continue;
                this.notifyPluginFilesChangedListeners(fileList);
                break;
            }
        }
        this.pluginFiles = fileList;
    }

    public String[] getAvailablePluginFileNames() {
        if (this.pluginFiles == null) {
            File f = new File(JDictionary.getPluginDirPath());
            String[] fileList = f.list(new DirFilter(".jar"));
            this.pluginFiles = fileList;
        }
        return this.pluginFiles;
    }

    public ZipFile[] getAvailablePluginFiles() {
        String[] fileNames = this.getAvailablePluginFileNames();
        ZipFile[] pluginFiles = new ZipFile[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            try {
                ZipFile z;
                pluginFiles[i] = z = new ZipFile(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(fileNames[i]))));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return pluginFiles;
    }

    public boolean isItInstalled(PluginInfoSheet infoSheet) {
        Iterator sheetsIterator = this.plugins.keySet().iterator();
        while (sheetsIterator.hasNext()) {
            PluginInfoSheet tempSheet = (PluginInfoSheet)sheetsIterator.next();
            if (!infoSheet.getFileName().equals(tempSheet.getFileName()) || this.extractVersionNumberFromFileName(infoSheet.getFileName()) != this.extractVersionNumberFromFileName(tempSheet.getFileName())) continue;
            return true;
        }
        return false;
    }

    public float getNewestVersion(PluginInfoSheet infoSheet) {
        Iterator sheetsIterator = this.plugins.keySet().iterator();
        float newestVersion = 0.0f;
        while (sheetsIterator.hasNext()) {
            PluginInfoSheet tempSheet = (PluginInfoSheet)sheetsIterator.next();
            if (!infoSheet.getFileName().equals(tempSheet.getFileName()) || !(Float.parseFloat(tempSheet.getVersion()) > newestVersion)) continue;
            newestVersion = Float.parseFloat(tempSheet.getVersion());
        }
        return newestVersion;
    }

    public float extractVersionNumberFromFileName(String fileName) {
        int s = fileName.lastIndexOf("-");
        int e = fileName.lastIndexOf(".jar");
        if (s > -1 && s < e) {
            return Float.parseFloat(new String(fileName.substring(s + 1, e)).replace('_', '.'));
        }
        return 0.0f;
    }

    public String getNameWithoutVersion(String fileName) {
        int s = fileName.lastIndexOf("-");
        if (s > -1) {
            return fileName.substring(0, s);
        }
        s = fileName.lastIndexOf(".jar");
        if (s > -1) {
            return fileName.substring(0, s);
        }
        return fileName;
    }

    public boolean isPluginFileLoaded(String fileName) {
        Object[] sheets = this.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            String name = ((PluginInfoSheet)sheets[n]).getFileName();
            if (!name.equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public boolean isItActive(String fileName) {
        String name = this.getNameWithoutVersion(fileName);
        Iterator it = ((AbstractList)this.jDictionary.getPrefs().InActivePlugins).iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(name)) continue;
            return false;
        }
        return true;
    }

    public void selectPlugin(PluginInfoSheet sheet) {
        this.selectPlugin(sheet, null);
    }

    public void selectPlugin(PluginInfoSheet sheet, String subPluginName) {
        ArrayList plugin = this.getPlugin(sheet);
        if (sheet == this.selectedPlugin && subPluginName == this.selectedSubPlugin || sheet == this.selectedPlugin && subPluginName == null) {
            return;
        }
        if (plugin == null) {
            this.selectedPlugin = null;
            this.selectedSubPlugin = null;
            this.jDictionary.getPrefs().pluginInfoSheet = this.selectedPlugin;
            this.jDictionary.getPrefs().selectedNodeName = this.selectedSubPlugin;
            this.notifyPluginSelectedListeners();
            return;
        }
        this.selectedPlugin = sheet;
        for (int i = 0; i < plugin.size(); ++i) {
            if (!plugin.get(i).toString().equals(subPluginName)) continue;
            this.selectedSubPlugin = subPluginName;
            this.notifyPluginSelectedListeners();
            this.jDictionary.getPrefs().pluginInfoSheet = this.selectedPlugin;
            this.jDictionary.getPrefs().selectedNodeName = this.selectedSubPlugin;
            return;
        }
        this.selectedSubPlugin = null;
        this.jDictionary.getPrefs().pluginInfoSheet = this.selectedPlugin;
        this.jDictionary.getPrefs().selectedNodeName = this.selectedSubPlugin;
        this.notifyPluginSelectedListeners();
    }

    public void setActive(String fileName) {
        String name = this.getNameWithoutVersion(fileName);
        ((AbstractCollection)this.jDictionary.getPrefs().InActivePlugins).remove(name);
    }

    public void setInActive(String fileName) {
        String name = this.getNameWithoutVersion(fileName);
        this.jDictionary.getPrefs().InActivePlugins.add(name);
    }

    public void cleanUpInactivePluginList() {
        Iterator inactivePlugins = ((AbstractList)this.jDictionary.getPrefs().InActivePlugins).iterator();
        while (inactivePlugins.hasNext()) {
            if (this.isItAvailable(inactivePlugins.next().toString(), false)) continue;
            inactivePlugins.remove();
        }
    }

    public boolean isThereNewerPluginFileAvailable(String fileName) {
        String[] pluginDir = this.getAvailablePluginFileNames();
        float version = this.extractVersionNumberFromFileName(fileName);
        for (int i = 0; i < pluginDir.length; ++i) {
            float tempVersion;
            if (!this.getNameWithoutVersion(pluginDir[i]).equals(this.getNameWithoutVersion(fileName)) || !((tempVersion = this.extractVersionNumberFromFileName(pluginDir[i])) > version)) continue;
            return true;
        }
        return false;
    }

    public boolean isItAvailable(String fileName, boolean careWithVersion) {
        String[] fileNames = this.getAvailablePluginFileNames();
        for (int i = 0; i < fileNames.length; ++i) {
            if (!(careWithVersion ? fileNames[i].equals(fileName) : this.getNameWithoutVersion(fileNames[i]).equals(this.getNameWithoutVersion(fileName)))) continue;
            return true;
        }
        return false;
    }

    public void syncPluginFiles() {
        File f = new File(JDictionary.getGlobalPluginDirPath());
        if (!f.exists()) {
            this.cleanUpInactivePluginList();
            this.checkPluginDirForChanges();
            return;
        }
        String[] globalPluginDirFiles = f.list();
        for (int i = 0; i < globalPluginDirFiles.length; ++i) {
            if (this.isItAvailable(globalPluginDirFiles[i], true) || this.isItAvailable(globalPluginDirFiles[i], false) && this.isThereNewerPluginFileAvailable(globalPluginDirFiles[i])) continue;
            File sourceFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getGlobalPluginDirPath()))).append(JDictionary.getFileSeparator()).append(globalPluginDirFiles[i]))));
            try {
                FileInputStream sourceStream = new FileInputStream(sourceFile);
                int offset = 0;
                int loadedBytesCount = 0;
                int fileLength = (int)sourceFile.length();
                byte[] b = new byte[fileLength];
                while (loadedBytesCount < fileLength) {
                    if ((loadedBytesCount = sourceStream.read(b, offset += loadedBytesCount, fileLength -= loadedBytesCount)) != -1) continue;
                    System.err.println("PluginLoader.syncPluginFiles(): Wrong thing happened when I attempted to copy the file named: ".concat(String.valueOf(String.valueOf(sourceFile.getName()))));
                }
                File destFile = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(globalPluginDirFiles[i]))));
                FileOutputStream outStream = new FileOutputStream(destFile);
                System.out.println("PluginLoader.syncPluginFiles(): writing: ".concat(String.valueOf(String.valueOf(destFile.getName()))));
                outStream.write(b);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.cleanUpInactivePluginList();
        this.checkPluginDirForChanges();
    }

    public void scanPlugins() {
        if (this.scanThread != null) {
            try {
                this.scanThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.scanThread = new ScanThread();
        this.scanThread.start();
    }

    void cleanupPlugins() {
        Object[] sheets = this.getSheets();
        for (int n = 0; n < sheets.length; ++n) {
            PluginInfoSheet sheet = (PluginInfoSheet)sheets[n];
            String name = sheet.getFileName();
            if (!this.isItAvailable(name, true)) {
                this.removePlugin(sheet);
                continue;
            }
            if (!this.isThereNewerPluginFileAvailable(name) && this.isItActive(name)) continue;
            this.removePlugin(sheet);
        }
    }

    long getSize(ZipFile zipFile) {
        File f = new File(zipFile.getName());
        return f.length();
    }

    void notifyPluginAddedListeners(PluginInfoSheet sheet) {
        Vector tmpList;
        PluginStructureChangeEvent event = new PluginStructureChangeEvent(this, sheet);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginStructureChangeListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginStructureChangeListener)tmpList.elementAt(i)).pluginAdded(event);
        }
    }

    void notifyPluginRemovedListeners(PluginInfoSheet sheet) {
        Vector tmpList;
        PluginStructureChangeEvent event = new PluginStructureChangeEvent(this, sheet);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginStructureChangeListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginStructureChangeListener)tmpList.elementAt(i)).pluginRemoved(event);
        }
    }

    void notifyPluginFilesChangedListeners(String[] fileList) {
        Vector tmpList;
        PluginFilesChangeEvent event = new PluginFilesChangeEvent(this, fileList);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginFilesChangeListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginFilesChangeListener)tmpList.elementAt(i)).pluginFilesChanged(event);
        }
    }

    void notifyPluginSelectedListeners() {
        Vector tmpList;
        PluginSelectionEvent event = new PluginSelectionEvent(this, this.selectedPlugin, this.selectedSubPlugin);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginSelectionListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginSelectionListener)tmpList.elementAt(i)).pluginSelected(event);
        }
    }

    void notifyPluginScanFinishedListeners() {
        Vector tmpList;
        PluginScanFinishedEvent event = new PluginScanFinishedEvent(this, this.plugins);
        PluginManager pluginManager = this;
        synchronized (pluginManager) {
            tmpList = (Vector)this.pluginScanFinishedListeners.clone();
        }
        for (int i = 0; i < tmpList.size(); ++i) {
            ((PluginScanFinishedListener)tmpList.elementAt(i)).pluginScanFinished(event);
        }
    }

    public synchronized void addPluginStructureChangeListener(PluginStructureChangeListener listener) {
        this.pluginStructureChangeListeners.addElement(listener);
    }

    public synchronized void removePluginStructureChangeListener(PluginStructureChangeListener listener) {
        this.pluginStructureChangeListeners.removeElement(listener);
    }

    public synchronized void addPluginFilesChangeListener(PluginFilesChangeListener listener) {
        this.pluginFilesChangeListeners.addElement(listener);
    }

    public synchronized void removePluginFilesChangeListener(PluginFilesChangeListener listener) {
        this.pluginFilesChangeListeners.removeElement(listener);
    }

    public synchronized void addPluginSelectionListener(PluginSelectionListener listener) {
        this.pluginSelectionListeners.addElement(listener);
    }

    public synchronized void removePluginSelectionListener(PluginSelectionListener listener) {
        this.pluginSelectionListeners.removeElement(listener);
    }

    public synchronized void addPluginScanFinishedListener(PluginScanFinishedListener listener) {
        this.pluginScanFinishedListeners.addElement(listener);
    }

    public synchronized void removePluginScanFinishedListener(PluginScanFinishedListener listener) {
        this.pluginScanFinishedListeners.removeElement(listener);
    }

    class ScanThread
    extends Thread {
        ScanThread() {
        }

        public void run() {
            PluginManager.this.syncPluginFiles();
            PluginManager.this.cleanupPlugins();
            boolean loadLastUsed = true;
            int i = 0;
            String[] baseDirFiles = PluginManager.this.getAvailablePluginFileNames();
            while (i < baseDirFiles.length) {
                String fileNameToLoad = baseDirFiles[i];
                try {
                    File f;
                    if (loadLastUsed) {
                        loadLastUsed = false;
                        Prefs prefs = PluginManager.this.jDictionary.getPrefs();
                        if (prefs.pluginInfoSheet != null && PluginManager.this.isItAvailable(prefs.pluginInfoSheet.getFileName(), true) && PluginManager.this.isItActive(prefs.pluginInfoSheet.getFileName())) {
                            fileNameToLoad = PluginManager.this.jDictionary.getPrefs().pluginInfoSheet.getFileName();
                            i = -1;
                        }
                    }
                    if (PluginManager.this.isThereNewerPluginFileAvailable(fileNameToLoad)) {
                        f = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(fileNameToLoad))));
                        f.delete();
                        ++i;
                        continue;
                    }
                    if (!PluginManager.this.isItActive(fileNameToLoad)) {
                        ++i;
                        continue;
                    }
                    if (PluginManager.this.isPluginFileLoaded(fileNameToLoad)) {
                        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Plugin ").append(fileNameToLoad).append(" is already loaded"))));
                        ++i;
                        continue;
                    }
                    f = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(JDictionary.getPluginDirPath()))).append(JDictionary.getFileSeparator()).append(fileNameToLoad))));
                    ZipFile jarFile = new ZipFile(f);
                    System.out.println("\nscanPlugins(): Processing file: ".concat(String.valueOf(String.valueOf(jarFile.getName()))));
                    if (jarFile != null) {
                        System.out.println("Loading InfoSheet from file named: ".concat(String.valueOf(String.valueOf(jarFile.getName()))));
                        PluginInfoSheet sheet = PluginInfoSheet.CreateInfoSheet(jarFile);
                        if (sheet == null) {
                            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unable 0to load InfoSheet from file named: ").append(jarFile.getName()).append(" Skipping..."))));
                            ++i;
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        if (Float.parseFloat(sheet.getMinJDictionaryVersion()) > JDictionary.getJDictionaryVersion()) {
                            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Unable to load plugin named ").append(sheet.getName()).append(" (JDictionary version ").append(sheet.getMinJDictionaryVersion()).append(" or higher needed) Skipping..."))));
                            ++i;
                            try {
                                jarFile.close();
                            }
                            catch (IOException iOException) {}
                            continue;
                        }
                        sheet.setFileName(fileNameToLoad);
                        sheet.setSize(new Long(PluginManager.this.getSize(jarFile)).toString());
                        PluginLoader pluginLoader = new PluginLoader(jarFile.getName());
                        Enumeration<? extends ZipEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            String entryName = entries.nextElement().getName();
                            if (!entryName.endsWith("Plugin.class")) continue;
                            System.out.println("scanPlugins(): I want the PluginLoader to load the class named: ".concat(String.valueOf(String.valueOf(entryName))));
                            Class<?> pluginClass = pluginLoader.loadClass(entryName);
                            Object plugin = pluginClass.newInstance();
                            if (!(plugin instanceof Plugin)) continue;
                            PluginManager.this.pushPlugin(sheet, (Plugin)plugin);
                        }
                        PluginManager.this.notifyPluginAddedListeners(sheet);
                    }
                    ++i;
                    try {
                        jarFile.close();
                    }
                    catch (IOException ex) {
                        System.out.println("Unable to close jarFile");
                    }
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer("scanPlugins(): An error occurred while loading plugin named: ").append(fileNameToLoad).append(" Skipping..."))));
                    e.printStackTrace();
                    ++i;
                }
            }
            PluginManager.this.notifyPluginScanFinishedListeners();
            PluginManager.this.checkPluginDirForChanges();
        }
    }
}

