/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import jchessboard.PGN;

public class InfoPanel
extends JScrollPane {
    private PGN.STR str = new PGN.STR();
    private TagTableModel tableModel = new TagTableModel();
    private JTable jTable = new JTable(this.tableModel);
    private JPopupMenu tagTableContextMenu;

    private void updateFields() {
        if (this.str == null) {
            return;
        }
        this.tableModel.fireTableChanged(new TableModelEvent(this.tableModel));
    }

    public void setSTR(PGN.STR sTR) {
        this.str = sTR;
        this.updateFields();
    }

    public PGN.STR getSTR() {
        return this.str;
    }

    public InfoPanel() {
        this.setViewportView(this.jTable);
        this.jTable.setFont(new Font("SansSerrif", 0, 10));
        this.jTable.setRowSelectionAllowed(false);
        this.tagTableContextMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Remove tag");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoPanel.this.str.removeTag((String)InfoPanel.this.tableModel.getValueAt(InfoPanel.this.jTable.getSelectedRow(), 0));
                InfoPanel.this.tableModel.fireTableChanged(new TableModelEvent(InfoPanel.this.tableModel));
            }
        });
        this.tagTableContextMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Add tag...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(null, "Tag name:", "Add tag", 3);
                if (string != null && !string.equals("") && !InfoPanel.this.str.hasTag(string)) {
                    InfoPanel.this.str.setTag(string, "");
                    InfoPanel.this.tableModel.fireTableChanged(new TableModelEvent(InfoPanel.this.tableModel));
                }
            }
        });
        this.tagTableContextMenu.add(jMenuItem2);
        this.jTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    InfoPanel.this.tagTableContextMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    InfoPanel.this.tagTableContextMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    class TagTableModel
    extends AbstractTableModel {
        TagTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return InfoPanel.this.str.size();
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Tag";
            }
            if (n == 1) {
                return "Value";
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return InfoPanel.this.str.tags()[n];
            }
            if (n2 == 1) {
                return InfoPanel.this.str.getTag(InfoPanel.this.str.tags()[n]);
            }
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1 && object instanceof String) {
                InfoPanel.this.str.setTag(InfoPanel.this.str.tags()[n], (String)object);
            }
        }
    }
}

