/*
 * Decompiled with CFR 0.152.
 */
package jchessboard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import jchessboard.GameNode;
import jchessboard.JChessBoard;
import jchessboard.PGN;
import jchessboard.VirtualBoard;

class History
extends JScrollPane {
    private HistorySelectionListener selectionListener;
    private JChessBoard jcb;
    private JTree tree;
    private boolean isChanged = true;
    private JPopupMenu treeContextMenu;
    private GameNode topGameNode;
    private DefaultTreeModel treeModel;
    private GameNode currentGameNode;
    private int gameIndex = -1;
    PGN.STR str = null;

    public static String getVersion() {
        return "$Id: History.java,v 1.45 2004/12/24 23:56:43 cdivossen Exp $";
    }

    public void editComment() {
        int n;
        Object[] objectArray;
        Object[] objectArray2 = new Object[4];
        String string = this.currentGameNode.getComment();
        objectArray2[0] = "Edit comment:\n(Linefeeds will be removed.)";
        JTextArea jTextArea = new JTextArea(string, 5, 40);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        objectArray2[1] = jScrollPane;
        JList jList = null;
        if (this.currentGameNode.isLeaf()) {
            objectArray2[2] = "Numerical Annotation Glyphs (NAG):";
            objectArray = new Vector();
            for (n = 0; n < PGN.NAGStrings.length; ++n) {
                objectArray.add(n + ". " + PGN.NAGStrings[n]);
            }
            jList = new JList(objectArray);
            objectArray2[3] = new JScrollPane(jList);
        } else {
            objectArray2[2] = null;
            objectArray2[3] = null;
        }
        jList.setSelectedIndices(this.currentGameNode.getNags());
        objectArray = new Object[]{"OK", "Cancel"};
        n = JOptionPane.showOptionDialog(null, objectArray2, "Edit comment", 0, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            StringBuffer stringBuffer = new StringBuffer(jTextArea.getText());
            for (int i = 0; i < stringBuffer.length(); ++i) {
                if (stringBuffer.charAt(i) != '\n') continue;
                stringBuffer.setCharAt(i, ' ');
            }
            if (stringBuffer.length() > 0) {
                this.currentGameNode.setComment(stringBuffer.toString());
            }
            if (this.currentGameNode.isLeaf()) {
                int[] nArray = jList.getSelectedIndices();
                if (nArray.length > 1 || nArray.length == 1 && nArray[0] > 0) {
                    this.currentGameNode.setNags(nArray);
                } else {
                    this.currentGameNode.setNags(new int[0]);
                }
            }
            this.treeModel.nodeChanged(this.currentGameNode);
            this.isChanged = true;
        }
    }

    public String getPGNBody() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.topGameNode.getPGN());
        if (this.str != null) {
            if (this.str.getTag("Result").equals("?")) {
                stringBuffer.append(((GameNode)this.topGameNode.getLastLeaf()).getBoard().getResult());
            } else {
                stringBuffer.append(this.str.getTag("Result"));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public void setBoard(VirtualBoard virtualBoard) {
        this.currentGameNode.setBoard(virtualBoard);
        this.treeModel.nodeChanged(this.currentGameNode);
        this.isChanged = true;
    }

    public VirtualBoard getStartBoard() {
        return this.topGameNode.getBoard();
    }

    public VirtualBoard getCurrentBoard() {
        return this.currentGameNode.getBoard();
    }

    public GameNode getCurrentGameNode() {
        return this.currentGameNode;
    }

    public GameNode getTopGameNode() {
        return this.topGameNode;
    }

    public void loadGame(String string, PGN.STR sTR) throws VirtualBoard.ImpossibleMoveException {
        this.str = sTR;
        this.topGameNode.reset();
        this.currentGameNode = this.topGameNode;
        try {
            if (sTR.hasTag("SetUp")) {
                this.topGameNode.getBoard().initFromFEN(sTR.getTag("FEN"));
            }
            PGN.parseGame(this, this.topGameNode.getBoard(), string, false);
            this.treeModel.reload();
            this.isChanged = false;
        }
        catch (VirtualBoard.ImpossibleMoveException impossibleMoveException) {
            this.treeModel.reload();
            this.isChanged = false;
            throw new VirtualBoard.ImpossibleMoveException(impossibleMoveException.toString());
        }
    }

    public void setResult(String string) {
        this.str.setTag("Result", string);
        this.isChanged = true;
    }

    public void clear() {
        this.topGameNode.reset();
        this.treeModel.reload();
        this.gotoGameNode(this.topGameNode);
        this.gameIndex = -1;
        this.isChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatchMove(String string, VirtualBoard virtualBoard) {
        History history = this;
        synchronized (history) {
            GameNode gameNode = new GameNode(string, virtualBoard);
            if (this.currentGameNode.getMove().length() == 0) {
                if (this.currentGameNode.isLeaf()) {
                    this.treeModel.insertNodeInto(gameNode, this.currentGameNode, 0);
                } else {
                    GameNode gameNode2 = new GameNode("", this.currentGameNode.getBoard());
                    this.treeModel.insertNodeInto(gameNode2, this.currentGameNode, 1);
                    this.treeModel.insertNodeInto(gameNode, gameNode2, 0);
                }
            } else {
                int n;
                GameNode gameNode3 = (GameNode)this.currentGameNode.getParent();
                int n2 = gameNode3.getIndex(this.currentGameNode);
                for (n = gameNode3.getChildCount() - 1; !gameNode3.getChildAt(n).isLeaf() && n > 0; --n) {
                }
                if (n2 == n) {
                    this.treeModel.insertNodeInto(gameNode, gameNode3, gameNode3.getChildCount());
                } else {
                    GameNode gameNode4 = new GameNode("", this.currentGameNode.getBoard());
                    int n3 = n2 + 1;
                    while (!gameNode3.getChildAt(n3).isLeaf()) {
                        ++n3;
                    }
                    this.treeModel.insertNodeInto(gameNode4, gameNode3, n3 + 1);
                    this.treeModel.insertNodeInto(gameNode, gameNode4, 0);
                }
            }
            this.currentGameNode = gameNode;
        }
        this.isChanged = true;
    }

    public void addMove(String string, VirtualBoard virtualBoard) {
        this.addBatchMove(string, virtualBoard);
        this.gotoGameNode(this.currentGameNode);
    }

    public void addComment(String string) {
        this.currentGameNode.addComment(string);
        this.treeModel.nodeChanged(this.currentGameNode);
        this.isChanged = true;
    }

    public void addNAG(int n) {
        this.currentGameNode.addNAG(n);
        this.treeModel.nodeChanged(this.currentGameNode);
        this.isChanged = true;
    }

    public void addVariation(VirtualBoard virtualBoard, String string) throws VirtualBoard.ImpossibleMoveException {
        GameNode gameNode = this.currentGameNode;
        GameNode gameNode2 = (GameNode)this.currentGameNode.getParent();
        int n = gameNode2.getIndex(this.currentGameNode);
        GameNode gameNode3 = new GameNode("", virtualBoard);
        this.treeModel.insertNodeInto(gameNode3, gameNode2, n + 1);
        this.currentGameNode = gameNode3;
        PGN.parseGame(this, virtualBoard, string, false);
        this.currentGameNode = gameNode;
        this.isChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLastMove() {
        History history = this;
        synchronized (history) {
            if (this.currentGameNode == this.topGameNode || !this.currentGameNode.isLeaf()) {
                return;
            }
            GameNode gameNode = this.currentGameNode;
            while ((gameNode = (GameNode)gameNode.getNextSibling()) != null && !gameNode.isLeaf()) {
            }
            if (gameNode != null) {
                return;
            }
            gameNode = this.currentGameNode;
            this.prev();
            GameNode gameNode2 = (GameNode)gameNode.getParent();
            this.treeModel.removeNodeFromParent(gameNode);
            if (gameNode2.isLeaf() && gameNode2 != this.topGameNode) {
                this.prev();
                this.treeModel.removeNodeFromParent(gameNode2);
            }
            this.isChanged = true;
        }
    }

    public int getFullMoveNumber() {
        return this.currentGameNode.getFullMoveNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotoGameNode(GameNode gameNode) {
        if (gameNode == null) {
            return;
        }
        JChessBoard jChessBoard = this.jcb;
        synchronized (jChessBoard) {
            History history = this;
            synchronized (history) {
                this.selectionListener.setEnabled(false);
                TreePath treePath = new TreePath(gameNode.getPath());
                this.tree.setSelectionPath(treePath);
                this.tree.makeVisible(treePath);
                this.tree.scrollRowToVisible(this.tree.getRowForPath(treePath));
                this.currentGameNode = gameNode;
                this.selectionListener.setEnabled(true);
                this.jcb.update();
            }
        }
    }

    public void gotoLast() {
        this.gotoGameNode((GameNode)this.topGameNode.getLastLeaf());
    }

    public void gotoFirst() {
        this.gotoGameNode(this.topGameNode);
    }

    public List getAllBoards() {
        GameNode gameNode;
        Vector<VirtualBoard> vector = new Vector<VirtualBoard>();
        GameNode gameNode2 = gameNode = this.currentGameNode;
        vector.add(gameNode.getBoard());
        do {
            if (gameNode == null) {
                return vector;
            }
            do {
                gameNode2 = gameNode;
            } while ((gameNode = (GameNode)gameNode.getPreviousSibling()) != null && !gameNode.isLeaf());
            if (gameNode != null && gameNode.isLeaf()) {
                vector.add(gameNode.getBoard());
            }
            if (gameNode != null) continue;
            gameNode = (GameNode)gameNode2.getParent();
        } while (gameNode != null);
        return vector;
    }

    public GameNode getPreviousGameNode() {
        GameNode gameNode = this.currentGameNode;
        while ((gameNode = (GameNode)gameNode.getPreviousSibling()) != null && !gameNode.isLeaf()) {
        }
        if (gameNode == null) {
            gameNode = (GameNode)this.currentGameNode.getParent();
        }
        if (gameNode != null) {
            return gameNode;
        }
        return this.currentGameNode;
    }

    public void prev() {
        this.gotoGameNode(this.getPreviousGameNode());
    }

    public GameNode getNextGameNode() {
        if (!this.currentGameNode.isLeaf()) {
            return (GameNode)this.currentGameNode.getChildAt(0);
        }
        GameNode gameNode = this.currentGameNode;
        while ((gameNode = (GameNode)gameNode.getNextSibling()) != null && !gameNode.isLeaf()) {
        }
        if (gameNode != null) {
            return gameNode;
        }
        return this.currentGameNode;
    }

    public void next() {
        this.gotoGameNode(this.getNextGameNode());
    }

    public History(JChessBoard jChessBoard) {
        this.jcb = jChessBoard;
        VirtualBoard virtualBoard = new VirtualBoard();
        virtualBoard.init();
        this.currentGameNode = this.topGameNode = new GameNode("", virtualBoard);
        this.treeModel = new DefaultTreeModel(this.currentGameNode);
        this.str = new PGN.STR();
        this.tree = new JTree(this.treeModel);
        this.tree.setEditable(false);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(false);
        this.selectionListener = new HistorySelectionListener();
        this.tree.addTreeSelectionListener(this.selectionListener);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treeContextMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Edit comment...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                History.this.editComment();
                History.this.jcb.update();
            }
        });
        this.treeContextMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Remove variation");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                for (defaultMutableTreeNode = History.this.currentGameNode; defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode != History.this.topGameNode; defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) {
                }
                if (defaultMutableTreeNode != History.this.topGameNode) {
                    History.this.gotoGameNode((GameNode)defaultMutableTreeNode.getPreviousSibling());
                    History.this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
                }
            }
        });
        this.treeContextMenu.add(jMenuItem2);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    History.this.treeContextMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    History.this.treeContextMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            this.tree.setRowHeight(16);
        }
        this.setVerticalScrollBarPolicy(22);
        this.getViewport().add(this.tree);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    class HistorySelectionListener
    implements TreeSelectionListener {
        boolean isEnabled = true;

        HistorySelectionListener() {
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!this.isEnabled) {
                return;
            }
            DefaultTreeModel defaultTreeModel = History.this.treeModel;
            synchronized (defaultTreeModel) {
                TreePath treePath = treeSelectionEvent.getPath();
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (defaultMutableTreeNode instanceof GameNode) {
                    History.this.gotoGameNode((GameNode)defaultMutableTreeNode);
                }
            }
        }
    }
}

