/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;

public class BreadBoard
extends JFrame {
    public ImageIcon breadBoard;
    public JMenu filemenu;
    public JMenuBar mainMenu;
    public JToolBar toolBar;
    public JMenuItem refresh;
    public Graphics g;
    public static int icToggleKey = 1;
    public static int ledTogglekey = 1;
    public ImageIcon MenuChip;
    public static WireFabric wireFrame;
    public BreadPanel breadPanel;
    public JButton Wire;
    public JButton addLED;
    public JButton simulate;
    public JButton addIc;
    public static SimulationExec Execute;
    public static Image fnelson_logo;
    public ImageIcon wireButtonIcon;
    public ImageIcon wireButtonIconX;
    public ImageIcon simButton;
    public ImageIcon ledButton;
    public JMenu aboutMenu;
    public JMenuItem about;
    public JMenuItem help_topic;
    public Property_pane properties;
    public static StatusBar statbar;
    public JMenu breadTheme;
    public JRadioButton theme1;
    public JRadioButton theme2;
    public ButtonGroup themeGroup;

    public BreadBoard() {
        super("'4 nelson' Digital Logic Circuit Simulator Beta 1.01");
        this.setLayout(new BorderLayout());
        this.setSize(1038, 488);
        fnelson_logo = new ImageIcon(this.getClass().getResource("4nelson logo.png")).getImage();
        this.setIconImage(fnelson_logo);
        this.setDefaultCloseOperation(3);
        this.breadPanel = new BreadPanel();
        this.add((Component)this.breadPanel, "Center");
        this.filemenu = new JMenu("File");
        this.aboutMenu = new JMenu("Help");
        this.filemenu.setMnemonic('F');
        this.MenuChip = new ImageIcon(this.getClass().getResource("ic little button.png"));
        this.refresh = new JMenuItem("Refresh");
        this.refresh.setMnemonic('R');
        this.refresh.setToolTipText("Refresh Breadboard");
        this.about = new JMenuItem("About");
        this.help_topic = new JMenuItem("User guide");
        this.properties = new Property_pane();
        this.filemenu.add(this.refresh);
        this.aboutMenu.add(this.about);
        this.aboutMenu.add(this.help_topic);
        this.breadTheme = new JMenu("Breadboard theme");
        this.themeGroup = new ButtonGroup();
        this.themeGroup.add(this.theme1);
        this.themeGroup.add(this.theme2);
        this.mainMenu = new JMenuBar();
        this.setJMenuBar(this.mainMenu);
        this.mainMenu.add((Component)this.filemenu, "East");
        this.mainMenu.add(this.aboutMenu);
        this.toolBar = new JToolBar();
        this.addIc = new JButton();
        this.addIc.setIcon(this.MenuChip);
        this.addIc.setMnemonic('I');
        this.addIc.setToolTipText("Spawn Ic");
        this.toolBar.add(this.addIc);
        this.Wire = new JButton();
        this.wireButtonIcon = new ImageIcon(this.getClass().getResource("wirebutton.png"));
        this.wireButtonIconX = new ImageIcon(this.getClass().getResource("wirebuttonX.png"));
        this.Wire.setIcon(this.wireButtonIcon);
        this.Wire.setToolTipText("(W) Wire Connection Mode");
        this.Wire.setMnemonic('w');
        this.toolBar.add(this.Wire);
        this.addLED = new JButton();
        this.ledButton = new ImageIcon(this.getClass().getResource("ledbutton.png"));
        this.addLED.setIcon(this.ledButton);
        this.addLED.setMnemonic('l');
        this.addLED.setToolTipText("(L) Spawn Led");
        this.toolBar.add(this.addLED);
        this.simulate = new JButton();
        this.simButton = new ImageIcon(this.getClass().getResource("simbutton.png"));
        this.simulate.setMnemonic('s');
        this.simulate.setIcon(this.simButton);
        this.simulate.setToolTipText("(S) Simulate");
        this.toolBar.add(this.simulate);
        this.toolBar.setToolTipText("Drawing menu");
        this.toolBar.setName("Drawing");
        this.add((Component)this.toolBar, "North");
        menuHandler handler1 = new menuHandler();
        this.refresh.addActionListener(handler1);
        this.Wire.addActionListener(handler1);
        this.addLED.addActionListener(handler1);
        this.simulate.addActionListener(handler1);
        this.addIc.addActionListener(handler1);
        this.refresh.addActionListener(handler1);
        this.about.addActionListener(handler1);
    }

    public void connectionButtonToggler(boolean key) {
        WireHole tempnext;
        int j;
        WireHole temp;
        int i = 0;
        while (true) {
            if (i >= WireFabric.upperPanelHoles.size()) break;
            temp = WireFabric.upperPanelHoles.get(i);
            temp.buttonHole.setVisible(key);
            temp.buttonHole.setEnabled(key);
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= WireFabric.lowerPanelHoles.size()) break;
            temp = WireFabric.lowerPanelHoles.get(i);
            temp.buttonHole.setVisible(key);
            temp.buttonHole.setEnabled(key);
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= WireFabric.midPanel1Holes.size()) break;
            temp = WireFabric.midPanel1Holes.get(i);
            for (j = 0; j < temp.nexHoles.size(); ++j) {
                tempnext = temp.nexHoles.get(j);
                tempnext.buttonHole.setVisible(key);
                tempnext.buttonHole.setEnabled(key);
            }
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= WireFabric.midpanel2Holes.size()) break;
            temp = WireFabric.midpanel2Holes.get(i);
            for (j = 0; j < temp.nexHoles.size(); ++j) {
                tempnext = temp.nexHoles.get(j);
                tempnext.buttonHole.setVisible(key);
                tempnext.buttonHole.setEnabled(key);
            }
            ++i;
        }
    }

    public class BreadPanel
    extends JPanel {
        public BreadPanel() {
            this.setLayout(null);
            wireFrame = new WireFabric();
            wireFrame.setBounds(0, 0, 1024, 270);
            this.add(wireFrame);
            wireFrame.setEnabled(false);
            BreadBoard.this.connectionButtonToggler(false);
            BreadBoard.this.breadBoard = new ImageIcon(this.getClass().getResource("breadboard full2.png"));
            statbar = new StatusBar();
            statbar.setBounds(0, 270, 1024, 400);
            this.add(statbar);
        }

        @Override
        public void paintComponent(Graphics g) {
            BreadBoard.this.breadBoard.paintIcon(this, g, 0, 0);
        }
    }

    public class menuHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == BreadBoard.this.refresh) {
                BreadBoardExec.refresh_set();
            }
            if (event.getSource() == BreadBoard.this.addIc) {
                WireFabric.icLocationHighlighter = true;
                BreadBoard.this.repaint();
                wireFrame.icToggler(icToggleKey);
                ++icToggleKey;
            }
            if (event.getSource() == BreadBoard.this.addLED) {
                WireFabric.ledLocationHighlighter = true;
                BreadBoard.this.repaint();
                wireFrame.LEDtoggler(ledTogglekey);
                ++ledTogglekey;
            } else if (event.getSource() == BreadBoard.this.Wire) {
                if (wireFrame.isEnabled()) {
                    BreadBoard.this.Wire.setIcon(BreadBoard.this.wireButtonIcon);
                    BreadBoard.this.Wire.setToolTipText("{W} Wire Connection Mode");
                    BreadBoard.this.Wire.setMnemonic('w');
                    BreadBoard.this.addIc.setEnabled(true);
                    BreadBoard.this.addLED.setEnabled(true);
                    BreadBoard.this.simulate.setEnabled(true);
                    wireFrame.setEnabled(false);
                    BreadBoard.this.connectionButtonToggler(false);
                } else {
                    BreadBoard.this.Wire.setIcon(BreadBoard.this.wireButtonIconX);
                    BreadBoard.this.Wire.setToolTipText("{E} End Connection Mode");
                    BreadBoard.this.Wire.setMnemonic('e');
                    BreadBoard.this.addIc.setEnabled(false);
                    BreadBoard.this.addLED.setEnabled(false);
                    BreadBoard.this.simulate.setEnabled(false);
                    wireFrame.setEnabled(true);
                    BreadBoard.this.connectionButtonToggler(true);
                }
            } else if (event.getSource() == BreadBoard.this.simulate) {
                Execute = new SimulationExec();
                for (int i = 0; i < 4; ++i) {
                    Execute.VCCinitiator();
                    Execute.GNDinitiator();
                    Execute.midPanel1_initiator();
                    Execute.midPanel2_initiator();
                    Execute.findIc();
                    Execute.findPin_midpanel1();
                    Execute.findPin_midpanel2();
                    Execute.enableIc();
                    Execute.findLED();
                    Execute.sendOutput();
                    Execute.midPanel1_initiator();
                    Execute.midPanel2_initiator();
                    Execute.TriggerLED();
                    Execute.lightLED();
                    Execute.tempPrinter();
                }
            } else if (event.getSource() == BreadBoard.this.about) {
                AboutFrame frame = new AboutFrame();
                frame.setUndecorated(true);
                About ab = new About();
                TransparentBackground bg = new TransparentBackground(frame);
                bg.setLayout(new BorderLayout());
                ab.setOpaque(false);
                bg.add((Component)ab, "Center");
                frame.getContentPane().add((Component)bg, "Center");
                frame.pack();
                frame.setSize(520, 420);
                frame.setLocation(300, 20);
                frame.setVisible(true);
            }
        }
    }
}

