/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.AbstractInterruptSource;
import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.MachineCyclesListener;

public class Timer2
extends AbstractInterruptSource
implements MCS51Peripheral,
MachineCyclesListener {
    MCS51 cpu;
    public static final int T2CON = 200;
    public static final int T2CON_TF2 = 128;
    public static final int T2CON_EXF2 = 128;
    public static final int T2CON_TR2 = 4;
    public static final int T2CON_CP = 1;
    public static final int T2MOD = 201;
    public static final int T2MOD_DCEN = 1;
    public static final int TL2 = 204;
    public static final int TH2 = 205;
    public static final int RCAP2H = 203;
    public static final int RCAP2L = 202;
    public static final int IEN0 = 168;
    public static final int IEN0_ET2 = 32;
    public static final int IEN1 = 177;

    public Timer2() {
        super(43);
    }

    public void sfrWrite(int n, int n2) {
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        mCS51.setSfrName(204, "TL2");
        mCS51.setSfrName(204, "TH2");
        mCS51.setSfrName(201, "T2MOD");
        mCS51.setSfrName(200, "T2CON");
        mCS51.setSfrName(203, "RCAP2H");
        mCS51.setSfrName(202, "RCAP2L");
        mCS51.addInterruptSource(168, this, "TIMER2");
        mCS51.addInterruptSource(200, this, "TIMER2");
        mCS51.addMachineCycleListener(this);
    }

    @Override
    public void cycles(int n) {
        if (!this.cpu.sfrIsSet(200, 4)) {
            return;
        }
        int n2 = this.cpu.sfr16(205, 204);
        if ((n2 += n) >= 65535) {
            this.cpu.sfrSet(200, 128);
            if (!this.cpu.sfrIsSet(200, 1)) {
                n2 = this.cpu.sfr(203) * 256 + this.cpu.sfr(202);
            }
        }
        this.cpu.sfr16(n2, 205, 204);
    }

    @Override
    public void interruptStart() {
        this.cpu.sfrReset(200, 128);
    }

    @Override
    public boolean interruptCondition() {
        return this.cpu.sfrIsSet(168, 32) && this.cpu.sfrIsSet(200, 128);
    }
}

