/*
 * Decompiled with CFR 0.152.
 */
package j51.intel;

import j51.intel.BytePort;
import j51.intel.MCS51;
import j51.intel.MCS51Peripheral;
import j51.intel.SfrWriteListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;

class MCS51Port
extends JPanel
implements MCS51Peripheral,
SfrWriteListener {
    private BytePort m1;
    private BytePort m2;
    private BytePort p;
    private MCS51 cpu;

    public MCS51Port(int n) {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        this.m1 = new BytePort("P" + n + "M1");
        this.m2 = new BytePort("P" + n + "M2");
        this.p = new BytePort("P" + n);
        this.add((Component)this.m1, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.m2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.p, gridBagConstraints);
    }

    @Override
    public void registerCpu(MCS51 mCS51) {
        this.cpu = mCS51;
        this.m1.registerCpu(mCS51);
        this.m2.registerCpu(mCS51);
        this.p.registerCpu(mCS51);
        if (this.m1.getSfr() != -1) {
            mCS51.addSfrWriteListener(this.m1.getSfr(), this);
        } else {
            this.m1.setDisableMask(255);
        }
        if (this.m2.getSfr() != -1) {
            mCS51.addSfrWriteListener(this.m2.getSfr(), this);
        } else {
            this.m2.setDisableMask(255);
        }
    }

    @Override
    public void sfrWrite(int n, int n2) {
        int n3 = this.cpu.sfr(this.m1.getSfr());
        int n4 = this.cpu.sfr(this.m2.getSfr());
        for (int i = 0; i < 8; ++i) {
            boolean bl;
            int n5 = 1 << i;
            boolean bl2 = (n3 & n5) != 0;
            boolean bl3 = bl = (n4 & n5) != 0;
            if (!bl2 && bl) {
                this.p.setDisabled(i, true);
                continue;
            }
            this.p.setDisabled(i, false);
        }
    }

    public void setPortName(int n, String string) {
        this.p.setBitName(n, string);
    }

    public void setSfrM1(int n) {
        this.m1.setSfr(n);
    }

    public void setSfrM2(int n) {
        this.m2.setSfr(n);
    }

    public void setSfrP(int n) {
        this.p.setSfr(n);
    }

    public void setDisableMask(int n) {
        this.m1.setDisableMask(n);
        this.m2.setDisableMask(n);
        this.p.setDisableMask(n);
    }
}

