(********************************************************************************************
** PROGRAM     : cgiListStudents
** VERSION     : 1.0.0
** DESCRIPTION : Example cgi/database program.
** AUTHOR      : Stuart King
** COPYRIGHT   : Copyright (c) Irie Tools, 2003. All Rights Reserved.
** NOTES       :
**    This sample program is distributed with Irie Pascal, and is an example of how to
** write CGI programs that access databases using Irie Pascal.
** When this program is run under Windows it attempts to use a Data Source Name (DSN),
** called 'TestIrieDB' to connect to an ODBC database engine. As a result you should be
** familiar with DSN's and basic database administration, if you want to run this sample
** under Windows.
** When this program is run under Linux, FreeBSD, Solaris/x86, or Solaris/Sparc it attempts
** to connect to a MySQL database called 'TestIrieDB', and user 'test', with password 'testpwd'.
** The connection is made through the socket '/tmp/mysql.sock'. As a result you will need to
** create the database and setup the user with the appropriate permissions, if you want to run
** this sample under those operating systems.
** This sample program assumes that certain tables exists, the best way to make certain of this
** is to run the sample program 'TestIrieDB' (located in samples\database).
** NOTE: The only ODBC or MySQL specific code in this program is the code that gets the
** connection string.
**********************************************************************************************)
program cgiListStudents;
const
	MAX_SQL_COMMAND = 2000;
	MAX_STUDENT_ID = 8;
	MAX_STUDENT_LASTNAME = 20;
	MAX_STUDENT_FIRSTNAME = 20;
	MAX_DATETIME = 10;
	MAX_SUBJECT_NAME = 40;
type
	positive = 0..maxint;
	SQLCommandType = string[MAX_SQL_COMMAND];

	StudentCodeType = integer;
	StudentIdType = string[MAX_STUDENT_ID];
	StudentLastNameType = string[MAX_STUDENT_LASTNAME];
	StudentFirstNameType = string[MAX_STUDENT_FIRSTNAME];
	DateTimeType = string[MAX_DATETIME];
	SubjectNameType = string[MAX_SUBJECT_NAME];
	SubjectScoreType = real;

	StudentInfo = record
		Code : StudentCodeType;
		Id : StudentIdType;
		LastName : StudentLastNameType;
		FirstName : StudentFirstNameType;
		DateOfBirth : DateTimeType;
		SubjectName : SubjectNameType;
		SubjectScore : SubjectScoreType;
	end;
var
	strSQLCommand : SQLCommandType;
	StudentInfoList : list of StudentInfo;
	objConn : connection;
	objRec : recordset;
	bConnectionOpen : boolean;

	function EscapeCharacters(s : string) : string; forward;
	procedure ErrorMsg(msg : string); forward;
	procedure Done; forward;
	procedure DisplayErrors; forward;

	procedure Init;
	begin (* Init *)
		strSQLCommand := '';
		new(StudentInfoList);
		new(objConn);
		new(objRec);
		bConnectionOpen := false;
	end; (* Init *)

	procedure OpenConnection;
	var
		strConnectionString : string;

		function GetODBCConnectionString : string;
		begin (* GetODBCConnectionString *)
			GetODBCConnectionString := 'ODBC;DSN=TestIrieDB';
		end; (* GetODBCConnectionString *)

		function GetMySQLConnectionString : string;
		begin (* GetMySQLConnectionString *)
			GetMySQLConnectionString := 'MYSQL;user="test";password="testpwd";database="TestIrieDB";socket="/tmp/mysql.sock"'
		end; (* GetMySQLConnectionString *)

	begin (* OpenConnection *)
		if supported(feature_odbc) then
			strConnectionString := GetODBCConnectionString
		else if supported(feature_mysql) then
			strConnectionString := GetMySQLConnectionString
		else
			ErrorMsg('Databases are not supported on this platform');
		writeln('Opening connection with: ', strConnectionString);
		traperrors(false);
		objConn.open(strConnectionString);
		traperrors(true);
		if getlasterror <> 0 then
			begin
				DisplayErrors;
				Done;
			end;
		bConnectionOpen := true
	end; (* OpenConnection *)

	procedure CloseConnection;
	begin (* CloseConnection *)
		if bConnectionOpen then
			begin
				objConn.close;
				bConnectionOpen := false
			end;
	end; (* CloseConnection *)

	//PURPOSE: Generates the response to send back to the browser.
	procedure GenerateResponse;

		procedure GenerateHeader;
		begin (* GenerateHeader *)
			//Generate the response headers (including the blank line at the end).
			writeln('content-type: text/html');
			writeln;

			writeln('<html>');
			writeln('<head>');
			writeln('<title>Irie Pascal CGI/Database application</title>');
			writeln('</head>');
		end; (* GenerateHeader *)

		procedure GenerateBody;
		var
			i, iNum : positive;

			procedure ReadStudentInfo;
			var
				StudentInfoRec : StudentInfo;
			begin (* ReadStudentInfo *)
				strSQLCommand := 'SELECT Student.Code, Student.Id, LastName, FirstName, DateOfBirth, Subject.Name, Score.SubjectScore ';
				strSQLCommand := strSQLCommand + 'FROM Student, Subject, Score ';
				strSQLCommand := strSQLCommand + 'WHERE Student.Code=Score.StudentCode ';
				strSQLCommand := strSQLCommand + 'AND Score.SubjectCode=Subject.Code ';
				strSQLCommand := strSQLCommand + 'ORDER BY Student.Id, Score.SubjectScore';
				objRec.open(objConn, strSQLCommand, rsforward);
				while not objRec.eof do
					begin
						with StudentInfoRec do
							begin
								Code := objRec.('Code');
								Id := objRec.('Id');
								LastName := objRec.('LastName');
								FirstName := objRec.('FirstName');
								DateOfBirth := copy(objRec.('DateOfBirth'), 1, MAX_DATETIME);
								SubjectName := objRec.('Name');
								SubjectScore := objRec.('SubjectScore');
							end;
						insert(StudentInfoRec, StudentInfoList);
						objRec.movenext;
					end;
				objRec.close
			end; (* ReadStudentInfo *)

			procedure WriteStudentInfo(var studinfo : StudentInfo);
			begin (* WriteStudentInfo *)
				with studinfo do
					begin
						write('<p>');
						write(Code:1, ' ', EscapeCharacters(Id), ' ', EscapeCharacters(LastName), ' ', EscapeCharacters(FirstName), ' ');
						write(EscapeCharacters(DateOfBirth), ' ', EscapeCharacters(SubjectName), ' ', SubjectScore:3:2);
						writeln('</p>');
					end
			end; (* WriteStudentInfo *)

		begin (* GenerateBody *)
			writeln('<body>');
			OpenConnection;
			ReadStudentInfo;
			CloseConnection;
			writeln('<h1>Student Scores</h1>');
			iNum := length(StudentInfoList);
			writeln('<p>', iNum:1, ' students</p>');
			for i := 1 to iNum do
				WriteStudentInfo(StudentInfoList[i]);
			writeln('</body>');
		end; (* GenerateBody *)

		procedure GenerateFooter;
		begin (* GenerateFooter *)
			writeln('</html>');
		end; (* GenerateFooter *)

	begin (* GenerateResponse *)
		GenerateHeader;
		GenerateBody;
		GenerateFooter;
	end; (* GenerateResponse *)
              
	//*************************************************************************
	//PURPOSE: This function converts certain characters that have a
	//         special meaning in HTML documents to their HTML representation.
	//ARGUMENT(s): s - The string to be escaped.
	//RETURNS: The string with all special characters escaped.
	//NOTES: The characters converted are < > "
	function EscapeCharacters;
	const
		LessThanChar = '<';
		GreaterThanChar = '>';
		QuoteChar = '"';
		HTMLLessThan = '&lt;';
		HTMLGreaterThan = '&gt;';
		HTMLQuote = '&quot;';
	var
		i : positive;

		procedure ReplaceChar(var strBuffer : string; strReplace : string; i : positive);
		begin (* ReplaceChar *)
			delete(strBuffer, i, 1);
			insert(strReplace, strBuffer, i)
		end; (* ReplaceChar *)

	begin (* EscapeCharacters *)
		repeat
			i := pos(LessThanChar, s, 1);
			if i > 0 then
				ReplaceChar(s, HTMLLessThan, i)
		until i = 0;

		repeat
			i := pos(GreaterThanChar, s, 1);
			if i > 0 then
				ReplaceChar(s, HTMLGreaterThan, i)
		until i = 0;

		repeat
			i := pos(QuoteChar, s, 1);
			if i > 0 then
				ReplaceChar(s, HTMLQuote, i)
		until i = 0;

		EscapeCharacters := s;
	end; (* EscapeCharacters *)

	procedure ErrorMsg;
	begin (* ErrorMsg *)
		writeln('ERROR: ', msg);
		Done;
	end; (* ErrorMsg *)

	procedure DisplayErrors;
	var
		iNumErrors, iCurrError : integer;

		procedure DisplayAnError(e : error);
		begin (* DisplayAnError *)
			with e do
				writeln('ERROR: ', number:1, ' ', name, ' ', description);
		end; (* DisplayAnError *)

	begin (* DisplayErrors *)
		iNumErrors := length(errors);
		for iCurrError := 1 to iNumErrors do
			DisplayAnError(errors[iCurrError])
	end; (* DisplayErrors *)

	procedure Done;
	begin
		if bConnectionOpen then
			CloseConnection;
		dispose(objRec);
		dispose(objConn);
		dispose(StudentInfoList);
		halt
	end;

begin
	Init;
	GenerateResponse;
	Done;
end.
