/* REXX Script to install Ini2URLs on the desktop */

	call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	call SysLoadFuncs

	fldrName = ''
	Do WHILE fldrName = ''
		SAY 'Enter a name for the new URL Folder'
		PARSE PULL fldrName
		fldrName = TRANSLATE(fldrName, '_', '*') /* I imagine this is a bad one! */
		fldrName = TRANSLATE(fldrName, '_', '?') /* I imagine this is a bad one! */
		fldrName = STRIP(fldrName, 'B', '_')
		fldrName = STRIP(fldrName, 'B', '+')
		fldrName = STRIP(fldrName, 'B', '-')
		fldrName = STRIP(fldrName, 'B', '=')
		fldrName = SPACE(fldrName, 1, '_')
		if fldrName = '' then
			SAY 'That is not a valid name.  Please try a different name.'
	End
	
	If SysCreateObject("WPFolder", fldrName, '<WEBXURLS>', "CCVIEW=YES;ICONFONT=8.Helv;ALWAYSSORT=YES;DEFAULTSORT=3;DEFAULTVIEW=ICON;ICONVIEW=NONFLOWED,MINI;OBJECTID=<WEBX_" || fldrName || "_FOLDER>", "fail") Then
	Do
		rc = SysSetObjectData('<WEBX_' || fldrName || '_FOLDER>', 'ICONFILE=' || DIRECTORY() || '\Icons\NETF.ICO;ICONNFILE=1,' || DIRECTORY() || '\Icons\NETFOP.ICO')
		rc = SysSaveObject('<WEBX_' || fldrName || '_FOLDER>', 0)
		Say 'Create the new URL folder ' || fldrName
	End
	Else
	Do
		Say 'Could not create the folder.  Does it still exist?'
		Say 'If not, try running FIX-FOLD.CMD after deleting all the folders'
		Say 'created by Ini2URLs.  (Then reinstall)'
		Say ' '
		Say 'If this still does not work, email jroepcke@compusmart.ab.ca'
		Say 'for free support.'
		Exit
	End
	
