{ ==========================================================================
                      L    III BBB  RRR   AA  RRR  Y   Y
                      L     I  B  B R  R A  A R  R  Y Y
                      L     I  BBB  RRR  AAAA RRR    Y
                      L     I  B  B R  R A  A R  R  Y
                      LLLL III BBB  R  R A  A R  R Y
  __________________________________________________________________________
  LIBRARY ipsHookExample

  COPYRIGHT ________________________________________________________________
  All code contained within this file is the exclusive property of the
  author Terje Flaarnning. It may not be copied, changed or used without
  written permission.

  Information about contacting the owner/author may be found at ...

    http://www.flaaronning.net/

  DESCRIPTION ______________________________________________________________

  TO-DO LIST _______________________________________________________________

  HISTORY __________________________________________________________________
  2002.04.03 - Initial history entry
  __________________________________________________________________________ }
library ipsHookExample;
{$IFDEF OS2}
  {$Cdecl+,OrgName+,Use32+}
{$ENDIF OS2}
{$IFDEF WIN32}
  {$StdCall+,OrgName+,Use32+}
{$ENDIF WIN32}
uses
  // Object Pascal units
  SysUtils,
  // InetPowerServer units
  ipsHookInterface;

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  This method is called by IPS when the .dll is first loaded when configured
  as a static Hook .dll.

  The method should return True (1) if the Initialization succeeded and the
  .dll will stay loaded. In the other case it should return False (0) and
  IPS will unload the .dll (without calling ipsFinalize).

  ARGUMENTS ________________________________________________________________
  [1] HookInfo: ipsPHookInfo          Pointer to HookInfo provided by IPS
  [R] Integer                         Return value

  HISTORY __________________________________________________________________
  2002.04.03 - Initial history entry
  __________________________________________________________________________ }
function ipsInitialize(HookInfo: ipsPHookInfo): Integer; export;
begin
  Result := Integer(True);
end; // function ipsInitialize

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  An example IPS hook method.

  Possible return values are ...

  <0               Reserverd for internal use, to not return these values
  0 (False)        Continue execution as if the Hook was not called
  1 (True)         Modify execution (possible including more return data)
  >1               Other possible return values, depends on hook point

  ARGUMENTS ________________________________________________________________
  [1] HookInfo: ipsPHookInfo          Pointer to HookInfo provided by IPS
  [R] Integer                         Return value

  HISTORY __________________________________________________________________
  2002.04.03 - Initial history entry
  __________________________________________________________________________ }
function ipsExample1(HookInfo: ipsPHookInfo): Integer; export;
var
  GetValue:                  ipsFGetValue;
  SetValue:                  ipsFSetValue;
  Send:                      ipsFSend;
  Log:                       ipsFLog;
  Value:                     PChar;
begin
  // Assign addresses to callback method prototypes
  GetValue := HookInfo^.Proc^.GetValue;
  SetValue := HookInfo^.Proc^.SetValue;
  Send := HookInfo^.Proc^.Send;
  Log := HookInfo^.Proc^.Log;

  // Write log entry
  Log(HookInfo, $ffffffff, 0, 'ipsHookExample1 has been called');

  // Allocate a string buffer
  Value := StrAlloc(100);

  // Requesting a IPS value
  if GetValue(HookInfo, ivtVariableValue, 'configsection', Value, 100) then
    Log(HookInfo, $ffffffff, 0, PChar(Format('ipsHookExample1 configsection="%s"', [Value])))
  else
    Log(HookInfo, $ffffffff, 0, 'ipsHookExample1 configsection was unavailable');

  // Deallocate string buffer
  StrDispose(Value);

  // Return False (0) to let IPS know we didn't change anything
  Result := Integer(False);
end; // function ipsExample1

{ ==========================================================================
  DESCRIPTION ______________________________________________________________
  This method is called by IPS when the .dll is about to be unloaded when
  configured as a static Hook .dll.

  The method should always return True (1).

  ARGUMENTS ________________________________________________________________
  [1] HookInfo: ipsPHookInfo          Pointer to HookInfo provided by IPS
  [R] Integer                         Return value

  HISTORY __________________________________________________________________
  2002.04.03 - Initial history entry
  __________________________________________________________________________ }
function ipsFinalize(HookInfo: ipsPHookInfo): Integer; export;
begin
  Result := Integer(True);
end; // function ipsFinalize

{ ==========================================================================
                     EEEE X   X PPP   OO  RRR  TTTTT  SSS
                     E     X X  P  P O  O R  R   T   S
                     EEE    X   PPP  O  O RRR    T    SS
                     E     X X  P    O  O R  R   T      S
                     EEEE X   X P     OO  R  R   T   SSS
  __________________________________________________________________________ }
exports
  ipsInitialize,
  ipsExample1,
  ipsFinalize;

{ ==========================================================================
    III N   N III TTTTT III  AA  L    III ZZZZZ  AA  TTTTT III  OO  N   N
     I  NN  N  I    T    I  A  A L     I     Z  A  A   T    I  O  O NN  N
     I  N N N  I    T    I  AAAA L     I    Z   AAAA   T    I  O  O N N N
     I  N  NN  I    T    I  A  A L     I   Z    A  A   T    I  O  O N  NN
    III N   N III   T   III A  A LLLL III ZZZZZ A  A   T   III  OO  N   N
  __________________________________________________________________________
  HISTORY __________________________________________________________________
  2002.04.03 - Initial history entry
  __________________________________________________________________________ }
initialization

{ ==========================================================================
         FFFF III N   N  AA  L    III ZZZZZ  AA  TTTTT III  OO  N   N
         F     I  NN  N A  A L     I     Z  A  A   T    I  O  O NN  N
         FFF   I  N N N AAAA L     I    Z   AAAA   T    I  O  O N N N
         F     I  N  NN A  A L     I   Z    A  A   T    I  O  O N  NN
         F    III N   N A  A LLLL III ZZZZZ A  A   T   III  OO  N   N
  __________________________________________________________________________
  HISTORY __________________________________________________________________
  2002.04.03 - Initial history entry
  __________________________________________________________________________ }
//finalization

end. // unit

{ ==========================================================================
                               EEEE N   N DDD
                               E    NN  N D  D
                               EEE  N N N D  D
                               E    N  NN D  D
                               EEEE N   N DDD
  __________________________________________________________________________
  0        1         2         3         4         5         6         7
  12345678901234567890123456789012345678901234567890123456789012345678901234
  __________________________________________________________________________
      7         6         5         4         3         2         1
  43210987654321098765432109876543210987654321098765432109876543210987654321
  __________________________________________________________________________ }
