/* $Id: callbacks.c,v 1.1 2003/10/26 21:58:18 hei Exp $ */
/**
 * @file callbacks.c
 *
 * IPS callback API's. These are the functions that IPS makes available to 
 * installed Hooks. You can call these functions directly from your hook
 * functions.
 *
 * $Revision: 1.1 $
 * @author Harald Eilertsen (haraldei@anduin.net)
 */

#include "ipsHookInterface.h"

/**
 * Retreive a value from IPS.
 *
 * @param pHookInfo  \b IN Pointer to IPS Hook information.
 * @param type       \b IN Type of value requested. (See @ref valuetypes)
 * @param ident      \b IN A string that identifies the value.
 * @param buf        \b OUT Pointer to a buffer to receive the requested value.
 * @param size       \b IN Size of supplied buffer.
 *
 * @return TRUE if the value was found, FALSE otherwise.
 */
IPSBOOL IPSCALL IpsGetValue(PIPSHOOKINFO pHookInfo, int type, char* ident, char* buf, int size)
{
   return pHookInfo->pproc->GetValue(pHookInfo, type, ident, buf, size);
}

/**
 * Set a value in IPS.
 *
 * @param pHookInfo  \b IN Pointer to IPS Hook information.
 * @param type       \b IN Type of value requested.
 * @param ident      \b IN A string that identifies the value.
 * @param text       \b IN Pointer to zero terminated string to assign the 
 *                         value.
 *
 * @return TRUE if the value was set, FALSE if an error occured.
 */
IPSBOOL IPSCALL IpsSetValue(PIPSHOOKINFO pHookInfo, int type, char* ident, char* text)
{
   return pHookInfo->pproc->SetValue(pHookInfo, type, ident, text);
}
 
/**
 * Send data to client.
 *
 * This function sends data to the client using the connection set up by IPS.
 *
 * @param pHookInfo  \b IN Pointer to IPS Hook information.
 * @param buf        \b IN Pointer to buffer containing data to send.
 * @param size       \b IN Size of supplied buffer.
 *
 * @return TRUE if data was successfully sent, FALSE otherwise.
 */
IPSBOOL IPSCALL IpsSend(PIPSHOOKINFO pHookInfo, void* buf, int size)
{
   return pHookInfo->pproc->Send(pHookInfo, buf, size);
}

/**
 * Receive data from client.
 *
 * <b>This function is not yet implemented.</b>
 *
 * @param pHookInfo  \b IN Pointer to IPS Hook information.
 * @param buf        \b OUT Pointer to buffer to receive data to.
 * @param size       \b IN Size of supplied buffer.
 *
 * @return TRUE if data was successfully received, FALSE otherwise.
 */
IPSBOOL IPSCALL IpsRecv(PIPSHOOKINFO pHookInfo, void* buf, int size)
{
   return  pHookInfo->pproc->Recv(pHookInfo, buf, size);
}


/**
 * Add a message to the logs.
 *
 * This functin will write the supplied message to one or more of the IPS
 * log-files. Which log file the message is written to may depend on the
 * \c code param, as well as the session where \c Log is called.
 *
 * @param pHookInfo  \b IN Pointer to IPS Hook information.
 * @param code       \b IN Logging code. (See @ref loggingcodes)
 * @param level      \b IN Level of the message, used by LogLevel to filter
 *                         messages based on log level.
 * @param text       \b IN Zero terminated ascii string to append to the log.
 *
 * @return TRUE on success, FALSE on failure.
 */
IPSBOOL IPSCALL IpsLog(PIPSHOOKINFO pHookInfo, unsigned code, int level, char* text)
{
   return  pHookInfo->pproc->Log(pHookInfo, code, level, text);
}

