/****************************************************************
 *   vector.c							*
 *   	Various vector and matrix allocation routines 		*
 *								*
 ****************************************************************/

#include <math.h>
#include <malloc.h>
#include <stdio.h>
#include "vector.h"


double          * 
dvector2(nl, nh)
        int             nl, nh;
{
        double          *v;
 
        v = (double *) calloc((unsigned) (nh - nl + 1), sizeof(double));
        if (!v)
                printf("allocation failure in vector()");
        return v - nl;
}

float          * 
fvector2(nl, nh)
        int             nl, nh;
{
        float          *v;
 
        v = (float *) calloc((unsigned) (nh - nl + 1), sizeof(float));
        if (!v)
                printf("allocation failure in vector()");
        return v - nl;
}
float          * 
lvector2(nl, nh)
        int             nl, nh;
{
        long          *v;
 
        v = (long *) calloc((unsigned) (nh - nl + 1), sizeof(long));
        if (!v)
                printf("allocation failure in vector()");
        return (float *)(v - nl);
}

unsigned char  *
cvector2(nl, nh)
        int             nl, nh;
{
        unsigned char  *v;
 
        v = (unsigned char *) calloc((unsigned) (nh - nl + 1), sizeof(char));
        if (!v)
                printf("allocation failure in cvector()");
        return v - nl;
}
int            * 
ivector2(nl, nh)
        int             nl, nh;
{
        int            *v;
 
        v = (int *) calloc((unsigned) (nh - nl + 1), sizeof(int));
        if (!v)
                printf("allocation failure in ivector()");
        return v - nl;
}
 

void 
free_dvector2(v, nl, nh)
        double		*v;
        int             nl, nh;
{
        free((double *) (v + nl));
}


void 
free_cvector2(v, nl, nh)
        unsigned char  *v;
        int             nl, nh;
{
        free((char *) (v + nl));
}
void 
free_fvector2(v, nl, nh)
        float          *v;
        int             nl, nh;
{
        free((char *) (v + nl));
}
 
void 
free_ivector2(v, nl, nh)
        int            *v, nl, nh;
{
        free((char *) (v + nl));
}

