/* $Id: dwt.h,v 1.8 1998/03/05 19:34:42 hjlee Exp $ */
/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was developed by                                         */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation and Texas Instruments             */ 
/****************************************************************************/

/************************************************************/
/*     Sarnoff Very Low Bit Rate Still Image Coder          */
/*     Copyright 1995, 1996, 1997, 1998 Sarnoff Corporation */
/************************************************************/

/* DWT and inverse DWT header file 
   Created by Shipeng Li, Sarnoff Corporation, Jan. 1998
   Copyright (c) Sarnoff Corporation
*/
#ifndef _DWT_H_
#define _DWT_H_
#include "momusys.h"



#ifdef DATA
#undef DATA
#endif
#define DATA Int  


#define ROUNDDIV(x, y) ((x)>0?(Int)(((Int)(x)+((y)>>1))/(y)):(Int)(((Int)(x)-((y)>>1)) /(y)))
enum {  /* DWT or IDWT return values */
  DWT_OK,
  DWT_FILTER_UNSUPPORTED,
  DWT_MEMORY_FAILED,
  DWT_COEFF_OVERFLOW,
  DWT_INVALID_LEVELS,
  DWT_INVALID_WIDTH,
  DWT_INVALID_HEIGHT,
  DWT_INTERNAL_ERROR,
  DWT_NOVALID_PIXEL
};

#define VTC_RECTANGULAR -1

/* Image data type */
enum { 
  UCHAR_ENUM,
  USHORT_ENUM
};
enum { /* filter class */
  ODD_SYMMETRIC,
  EVEN_SYMMETRIC,
  ORTHORGONAL
};


enum {
  POS_EVEN,
  POS_ODD
};


enum {
  HORIZONTAL,
  VERTICAL
};

enum {
  NONZERO_HIGH,
  ZERO_HIGH,
  WVT_ALL_ZERO
};

#define  OUT0 0
#define  IN   1
#define  OUT1 2
#define  OUT2 3
#define  OUT3 4

enum { /* filter type */
  INT_TYPE,
  DBL_TYPE
};

typedef struct {
  Int Class; 
  /* 0: Odd Symmetric 1: Even Symmetric 2: Orthogonal (not supported)
   Note: This is not defined by MPEG4-CD syntax but should be, since different 
   wavelets corresponds to different extension. 
   Ref. "Shape Adpative Discrete Wavelet Transform for Arbitrarily-Shaped 
   Visual Object Coding" S. Li and W. Li (submitted to IEEE T-CSVT) 
   */
  Int Type;
  /* 0: Short Coeff; 1: Double Coeff */
  Int HPLength;
  Int LPLength;
  Void *HPCoeff;
  Void *LPCoeff;
  Int Scale;
} FILTER;

#include "dwt.p"
#include "idwt.p"
#include "dwt_aux.p"
#include "idwt_aux.p"
#include "dwtmask.p"

#endif /*_DWT_H_ */
