/****************************************************************************/
/*   MPEG4 Visual Texture Coding (VTC) Mode Software                        */
/*                                                                          */
/*   This software was jointly developed by                                 */
/*   Sarnoff Coporation                   and    Texas Instruments          */
/*   Iraj Sodagar   (iraj@sarnoff.com)           Jie Liang (liang@ti.com)   */
/*   Hung-Ju Lee    (hjlee@sarnoff.com)                                     */
/*   Paul Hatrack   (hatrack@sarnoff.com)                                   */
/*   Shipeng Li     (shipeng@sarnoff.com)                                   */
/*   Bing-Bing Chai (bchai@sarnoff.com)                                     */
/*                                                                          */
/*   and                                                                    */
/*                                                                          */
/*   Oki Electric Industry Co., Ltd.                                        */
/*   Zhixiong Wu    (sgo@hlabs.oki.co.jp)                                   */
/*   Yoshihiro Ueda (yueda@hlabs.oki.co.jp)                                 */
/*   Toshifumi Kanamaru (kanamaru@hlabs.oki.co.jp)                          */
/*                                                                          */
/* In the course of development of the MPEG-4 standard. This software       */
/* module is an implementation of a part of one or more MPEG-4 tools as     */
/* specified by the MPEG-4 standard.                                        */
/*                                                                          */
/* The copyright of this software belongs to ISO/IEC. ISO/IEC gives use     */
/* of the MPEG-4 standard free license to use this  software module or      */
/* modifications thereof for hardware or software products claiming         */
/* conformance to the MPEG-4 standard.                                      */
/*                                                                          */
/* Those intending to use this software module in hardware or software      */
/* products are advised that use may infringe existing  patents. The        */
/* original developers of this software module and their companies, the     */
/* subsequent editors and their companies, and ISO/IEC have no liability    */
/* and ISO/IEC have no liability for use of this software module or         */
/* modification thereof in an implementation.                               */
/*                                                                          */
/* Permission is granted to MPEG memebers to use, copy, modify,             */
/* and distribute the software modules ( or portions thereof )              */
/* for standardization activity within ISO/IEC JTC1/SC29/WG11.              */
/*                                                                          */
/* Copyright (C) 1998  Sarnoff Coporation  and Texas Instruments            */ 
/****************************************************************************/

/****************************************************************************/
/*     Texas Instruments Predictive Embedded Zerotree (PEZW) Image Codec    */
/*     Copyright 1996, 1997, 1998 Texas Instruments	      		    */
/****************************************************************************/

#ifndef _PEZW_ZEROTREE_H_
#define  _PEZW_ZEROTREE_H_

#include "momusys.h"
#include "PEZW_ac.h"
#include "wvtPEZW.h"

/* declarations for zerotree coding */

#define max(a, b)       ((a) > (b) ? (a) : (b))


/* symbols actuallry used for AC coding */
#define IZER   0             /* isolated zero */
#define IVAL   1             /* isolated valued coefficient */
#define ZTRZ   2             /* zero tree root: zero */
#define ZTRV   3             /* valued zerotree root */

/* for internal use only, not sent as zerotree symbols  */
#define DZ     4               /* descendant of a ZTRV */
#define DS     5               /* descendant of a ZTRS */
#define S      6              /* positions already marked significant with nonzero descendents */
#define Z      7       	/* zero (default when undetermined), only used at encoder */
#define IS     8              /* isolated positions already marked significant, only used at encoder */

#define POS    9              /* only used at decoder */
#define NEG    10             /* only used at decoder */
#define ZTRPOS 11             /* only used at decoder */
#define ZTRNEG 12             /* only used at decoder */

#define SKIP   13			/* out of shape */						
#define SKPZTR 14			/* out of shape and zero tree root */	

#define Maximum_Decomp_Levels   10
#define No_of_states_context0   9
#define No_of_states_context1   1
#define No_of_contexts No_of_states_context0*No_of_states_context1*Maximum_Decomp_Levels


/* SYMBOLS FOR INTERNAL USE */


#define MAXPASS 20		/* not used anymore, but still in decoder */
#define MAXSNRLAYERS 20		/* Maximum number of SNR layers */

#define MAXSIZE      1000000    /* maximum bitstream size handled */
#define MAXZTRBUFFER  500000  /* size for maximum buffer for zerotree coding */

#define Code_value_bits 16

/* Models for arithmetic coding */
/* THE SET OF SYMBOLS THAT MAY BE ENCODED. */

#define No_of_chars 4		/* Number of character symbols */
/* ORIGINALLY No_of_chars was 256, change back for debugging ascii strings */
/* USING 6 for zerotrees */

#define EOF_symbol      No_of_chars     
#define CONTINUE_symbol (No_of_chars-1) 

#define No_of_symbols (No_of_chars+1) 
#define Max_frequency_TI 127


/* debugging parameters */
#define DEBUG_BS               0
#define DEBUG_BS_DETAIL        0
#define DEBUG_ZTR              1
#define DEBUG_ZTR_CONTEXTS     0
#define DEBUG_ZTR_DETAILS      0
#define DEBUG_ZTR_DETAILS_DEC  0
#define DEBUG_ZTR_DEC          1
#define DEBUG_ZTR_DEC_BS       0
#define DEBUG_ZTR_CONTEXTS_DEC 0
#define DEBUG_DEC_BS           0

#include "PEZW_utils.p"

#endif 
