/*
 *  Legacy file I/O library.
 *  (C) Copyright by Conea Software. Programmed by Andrew Belov.
 */

#ifdef RETAIN_ID
 static char SCCSID[]="$Id: filerd.c,v 1.7 2004/01/08 22:08:25 root Exp $";
#endif

#include <fcntl.h>
#ifndef linux
 #include <io.h>
 #include <share.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <csp_defs.h>
#include <filerd.h>
#if BUILDMODE==BUILD_DOS
 #include <dos.h>
#elif BUILDMODE==BUILD_OS2
 #define INCL_NOPM
 #include <os2.h>
#endif

char *all="*.*";
char *dot=".";

#ifndef F_OK
#define F_OK 0
#endif

int exist(char *file)
{
 return(!access(file, F_OK));
}

int fitswild(char *file, char *wildcard)
{
 char ci, cw;
 char *i, *w, *ifn, *ife, *wfn, *wfe;	/* Dynamically allocated */
 int j=0, n, f=1;
 i=(char *)malloc(strlen(file)+2);
 w=(char *)malloc(strlen(wildcard)+4);
 ifn=(char *)malloc(strlen(file)+2);
 wfn=(char *)malloc(strlen(wildcard)+4);
 ife=(char *)malloc(strlen(file)+2);
 wfe=(char *)malloc(strlen(wildcard)+4);
 if ((i!=NULL)&&(w!=NULL)&&(ifn!=NULL)&&(wfn!=NULL)&&(ife!=NULL)&&(wfe!=NULL))
 {
  strupr(strcpy(i, file)); strupr(strcpy(w, wildcard));
  if (w[0]=='\0') strcpy(w, all);
  if (strchr(i, dot[0])==NULL) strcat(i, dot);
  if (strchr(w, dot[0])==NULL) strcat(w, dot);
  j=strchr(i, dot[0])-i; strcpy(ifn, i); ifn[j]='\0'; strcpy(ife, i+j+1);
  j=strchr(w, dot[0])-w; strcpy(wfn, w); wfn[j]='\0'; strcpy(wfe, w+j+1);
  for (n=0; n<max(strlen(ifn), strlen(wfn)); n++)
  {
   if (n<strlen(ifn)) ci=ifn[n]; else ci='\0';
   if (n<strlen(wfn)) cw=wfn[n]; else cw='\0';
   if (cw=='*') break;
   if ((ci!=cw)&&cw!='?') f=0;
  }
  if (f!=0)
  {
   for (n=0; n<max(strlen(ife), strlen(wfe)); n++)
   {
    if (n<strlen(ife)) ci=ife[n]; else ci='\0';
    if (n<strlen(wfe)) cw=wfe[n]; else cw='\0';
    if (cw=='*') break;
    if ((ci!=cw)&&cw!='?') {f=0; break;}
   }
  }
 }
 free(i); free(w); free(ifn); free(wfn); free(ife); free(wfe);
 return(f);
}

void getfiletime(char *file, int *hours, int *minutes, int *seconds, int *year, int *month, int *day)
{
 #if BUILDMODE==BUILD_DOS
  union REGS r;
  struct SREGS s;
  int handle;
  r.x.ax=0x3D00;
  r.x.dx=FP_OFF(file);
  s.ds=FP_SEG(file);
  int86x (0x21, &r, &r, &s);
  r.x.bx=r.x.ax;
  r.x.ax=0x5700;
  r.x.cx=0;
  r.x.dx=0;
  int86 (0x21, &r, &r);
  r.h.ah=0x3E;
  int86 (0x21, &r, &r);
  *hours=r.x.cx>>11;
  *minutes=(r.x.cx>>5)%64;
  *seconds=(r.x.cx%31)*2;
  *year=(r.x.dx>>9)+1980;
  *month=(r.x.dx>>5)%16-1;
  *day=r.x.dx%32;
  close(handle);
 #elif BUILDMODE==BUILD_OS2
  #ifdef __32BIT__
   APIRET j;
   ULONG dummy;
  #else
   USHORT j;
   UINT dummy;
  #endif
  HFILE handle; FILESTATUS filestatus;

  if(!(j=DosOpen(file, &handle, &dummy, 0L, 0, FILE_OPEN, OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE, 0L)))
  {
   DosQFileInfo(handle, FIL_STANDARD, &filestatus, sizeof filestatus);
   DosClose(handle);
   *hours=(int)filestatus.ftimeLastWrite.hours;
   *minutes=(int)filestatus.ftimeLastWrite.minutes;
   *seconds=(int)filestatus.ftimeLastWrite.twosecs*2;
   *year=(int)filestatus.fdateLastWrite.year+1980;
   *month=(int)filestatus.fdateLastWrite.month-1;
   *day=(int)filestatus.fdateLastWrite.day;
  }
 #endif
}

char *rempath(char *file, char *filename, char *path)
{
 int i;
 for (i=strlen(file); (i>=0)&&(file[i]!='\\'); i--);
 if(i>=0)
 {
  strcpy(filename, file+i+1);
  memcpy(path, file, i+1);
  path[i+1]='\0';
 }
 else
 {
  strcpy(filename, file);
  path[0]='\0';
 }
 return(path);
}

char *substfnm(char *src, char *file)
{
 int i;
 for(i=strlen(src); i>0&&src[i]!='\\'; i--);
 if (i!=0) i++;
 src[i]='\0'; strcat(src, file);
 return(src);
}

char *substext(char *src, char *ext)
{
 int i, l;
 for(i=l=strlen(src); i>0&&src[i]!='.'; i--);
 if (i!=0)
  i++;
 else
 {
  src[l]='.';
  i=l+1;
 }
 strcpy(src+i, ext);
 return(src);
}
