@echo off
rem ----------------------------------------------------------------------
rem
rem PLCUPDAT.BAT
rem
rem Usage:  PLCUPDAT [source-path]
rem
rem         [source-path] Location of the updated PLC files.  Defaults 
rem                       to the current directory.  It can be any valid
rem                       path including a UNC path.
rem
rem This batch file allows you to update your IBM Networks Primary Logon
rem Client without removing it, then reinstalling the new version.
rem
rem ----------------------------------------------------------------------

echo.
setlocal

rem Default source directory to the current directory.
rem
if "%1"=="" set Source=.
if NOT "%1"=="" set Source=%1

rem Test to make sure PLC is installed and that the update
rem files exist.
rem
if NOT EXIST %SystemRoot%\system32\ibmgina.dll goto NotInstalled
if NOT EXIST %Source%\ibmgina.dl_ goto BadSource

rem Warning message!
rem
echo  This batch file will update the IBM Networks Primary Logon Client
echo  with the files located in:
echo.
if "%Source%"=="." cd
if NOT "%Source%"=="." echo  %Source%
echo.
echo  To abort this operation, press Ctrl+C.
echo.
pause
rem goto Done

rem Rename locked files so we can update them...
rem
echo.
echo  Preparing locked files for update...
rem
erase %SystemRoot%\system32\*.plc 2>nul
erase %SystemRoot%\system\*.plc 2>nul
ren %SystemRoot%\system32\runlsapp.exe *.plc
ren %SystemRoot%\system32\wdls.exe *.plc
ren %SystemRoot%\system32\lsapi.dll *.plc
ren %SystemRoot%\system32\ibmntcfg.exe *.plc
ren %SystemRoot%\system32\net.exe *.plc
ren %SystemRoot%\system32\net2.exe *.plc
ren %SystemRoot%\system32\ibmnetnt.dll *.plc
ren %SystemRoot%\system32\ibmntmsg.exe *.plc
ren %SystemRoot%\system32\ibmnt32.dll *.plc
ren %SystemRoot%\system32\ibmnt16.exe *.plc
ren %SystemRoot%\system32\ibmnt16b.exe *.plc
ren %SystemRoot%\system32\ibmginau.dll *.plc
ren %SystemRoot%\system32\ibmgina.dll *.plc
ren %SystemRoot%\system32\ibmginas.exe *.plc
ren %SystemRoot%\system32\ntdomain.dll *.plc
ren %SystemRoot%\system32\smbdomai.dll *.plc
ren %SystemRoot%\system32\graddce.dll *.plc
ren %SystemRoot%\system32\regcreds.exe *.plc
ren %SystemRoot%\system32\dm.dll *.plc
ren %SystemRoot%\system32\fixntacc.exe *.plc
ren %SystemRoot%\system\dlsnet.dll *.plc
ren %SystemRoot%\system\dlstb.dll *.plc
ren %SystemRoot%\system\windls.dll *.plc


rem Rename locked files so we can update them...
rem
echo  Updating files for IBM Networks Primary Logon Client...
rem
copy %Source%\oemsetup.inf %SystemRoot%\system32\oemibmnt.inf >nul
copy %Source%\checkver.exe %SystemRoot%\system32 >nul
copy %Source%\ibmntcfg.exe %SystemRoot%\system32 >nul
copy %Source%\ibmntcfg.hlp %SystemRoot%\system32 >nul

%SystemRoot%\system32\expand %Source%\runlsapp.ex_ %SystemRoot%\system32\runlsapp.exe >nul
%SystemRoot%\system32\expand %Source%\wdls.ex_     %SystemRoot%\system32\wdls.exe >nul
%SystemRoot%\system32\expand %Source%\lsapi.dl_    %SystemRoot%\system32\lsapi.dll >nul
%SystemRoot%\system32\expand %Source%\net.ex_      %SystemRoot%\system32\net.exe >nul
%SystemRoot%\system32\expand %Source%\net2.ex_     %SystemRoot%\system32\net2.exe >nul
%SystemRoot%\system32\expand %Source%\lsapi.ms_    %SystemRoot%\system32\lsapi.msg >nul
%SystemRoot%\system32\expand %Source%\lsapih.ms_   %SystemRoot%\system32\lsapih.msg >nul
%SystemRoot%\system32\expand %Source%\gui.ms_      %SystemRoot%\system32\gui.msg >nul
%SystemRoot%\system32\expand %Source%\ibmnetn2.dl_ %SystemRoot%\system32\ibmnetnt.dll >nul
%SystemRoot%\system32\expand %Source%\ibmntmsg.ex_ %SystemRoot%\system32\ibmntmsg.exe >nul
%SystemRoot%\system32\expand %Source%\ibmnt32.dl_  %SystemRoot%\system32\ibmnt32.dll >nul
%SystemRoot%\system32\expand %Source%\ibmnt16.ex_  %SystemRoot%\system32\ibmnt16.exe >nul
%SystemRoot%\system32\expand %Source%\ibmnt16b.ex_ %SystemRoot%\system32\ibmnt16b.exe >nul
%SystemRoot%\system32\expand %Source%\ibmginau.dl_ %SystemRoot%\system32\ibmginau.dll >nul
%SystemRoot%\system32\expand %Source%\ibmgina.dl_  %SystemRoot%\system32\ibmgina.dll >nul
%SystemRoot%\system32\expand %Source%\ibmginas.ex_ %SystemRoot%\system32\ibmginas.exe >nul
%SystemRoot%\system32\expand %Source%\ntdomain.dl_ %SystemRoot%\system32\ntdomain.dll >nul
%SystemRoot%\system32\expand %Source%\smbdomai.dl_ %SystemRoot%\system32\smbdomai.dll >nul
%SystemRoot%\system32\expand %Source%\graddce.dl_  %SystemRoot%\system32\graddce.dll >nul
%SystemRoot%\system32\expand %Source%\regcreds.ex_ %SystemRoot%\system32\regcreds.exe >nul
%SystemRoot%\system32\expand %Source%\dm.dl_       %SystemRoot%\system32\dm.dll >nul
%SystemRoot%\system32\expand %Source%\fixntacc.ex_ %SystemRoot%\system32\fixntacc.exe >nul
%SystemRoot%\system32\expand %Source%\discovry.av_ %SystemRoot%\system32\discovry.avi >nul
%SystemRoot%\system32\expand %Source%\logon.av_    %SystemRoot%\system32\logon.avi >nul

%SystemRoot%\system32\expand %Source%\dlsnet.dl_   %SystemRoot%\system\dlsnet.dll >nul
%SystemRoot%\system32\expand %Source%\dlstb.dl_    %SystemRoot%\system\dlstb.dll >nul
%SystemRoot%\system32\expand %Source%\windls.dl_   %SystemRoot%\system\windls.dll >nul

%SystemRoot%\system32\expand %Source%\wnt2net.hl_ %SystemRoot%\help\wntnet.hlp >nul
%SystemRoot%\system32\expand %Source%\wnt2net.cn_ %SystemRoot%\help\wntnet.cnt >nul



rem Success message
rem
echo.
echo  The IBM Networks Primary Logon Client has been updated.
echo.
echo  Please shutdown and restart your computer for the changes
echo  to take effect.
goto Done

:NotInstalled
echo  The IBM Networks Primary Logon Client for Windows NT must be
echo  installed before you can update it with this batch file.
echo.
goto Done

:BadSource
echo  The source directory does not contain the updated files 
echo  for the IBM Networks Primary Logon Client.
echo.
echo  Usage:  PLCUPDAT [source-path]
echo.
goto Done

:Done
endlocal
