.. ----------------------------------------
.2 [=BASETITLE] commands
.. ----------------------------------------
.an CMD
.an MY_ANCHOR

[=TOPICS]

.su V30 u

.. ----------------------------------------
.3 ...in general
.. ----------------------------------------
.an CMD_GENERAL

All [=TITLE] commands...
.ul
- start with a period.
- must start in the first column of the source file.
.p
  As all commands start with a period, a period is not allowed in the
  first column unless it is the first character of a [=TITLE] command.
  Place all other text containing a period that way, that the period is not
  the first character of a line.
- can be abbreviated, with the exception of some few commands.
.p
  That means, typing only the period plus at least two more characters
  of the command name is sufficient.
.p
  The following commands may not be abbreviated:
.ul compact
  - [.CMD_HTOC]
  - [.CMD_INCLUDE]
  - [.CMD_IF]
  - [.CMD_ELSE]
  - [.CMD_ENDIF]
  - [.CMD_LOL]
  - [.CMD_TTCHAR]
  - [.CMD_TTFONT]

Attributes can be specified for many commands. Some attributes have value
strings, like in #key=value# or for values consisting of multiple words
#key='value string'#. The following rules apply:

.ul
- Attributes may be abbreviated by typing the first character, except
  key=value types.
- Attributes are case-insensitive, except font names used in the value
  part.
- The value string may be enquoted with either single or double quotes,
  if it is prepared to take a multi-word expression.

.. ----------------------------------------
.3 Empty lines and vertical spacing
.. ----------------------------------------
.an CMD_EMPTYLINES

[=TITLE] supports you with adding or removing vertical spaces
automatically, when required.

That was implemented, because many IPF environments add an empty line at
their start or their end, but unfortunately not very consistent. Moreover,
IPF won't check if a user has already specified an empty line. It simply
always adds it, if defined.

*How it works:*
.ul
- Normally, an empty line creates a par break and makes the following
  text start in a new paragraph.
- Multiple empty lines are always combined to one. Now you can add as many
  empty lines as you want.
- In order to create intended additional par breaks or line breaks, e.g. for
  creating additional vertical space, the [.CMD_PAR] or
  [.CMD_LINEBREAK line break] command can be used.
- Empty lines at the top of a page before the first paragraph are ignored.
- Superfluous par breaks or line breaks are removed at the end of a page.
- For commands and environments that create par breaks themselves,
  additional empty lines can be specified, without ending up with two
  par breaks: [=TITLE] will remove those user-specified empty lines.
- IPF's *:exmp.* tag looks best in IBM's View when it is followed by a
  par break. That was added to [.CMD_FORMAT .FORMAT ON]. Otherwise View
  wouldn't always show the following text separated by an empty line.
  As a drawback, NewView now always shows an empty line too much.
- List endings require a par break for the following material. For compact
  lists, a line break is used instead. This makes list skips look good
  and you don't have to bother with them, depending on the use of the
  #compact# option or not.
- Some IPF environments require that the previous par is already ended,
  because they don't handle that themselves. For those environments, the
  required par break is added, when not specified.
- All levels of all list environments are ended when an empty line occurs.
  These lists are: [.CMD_ULIST], [.CMD_OLIST], [.CMD_PLIST], [.CMD_SLIST],
  [.CMD_TABLE], [.CMD_LINES], [.CMD_NOTE].
- In order to create multiple paragraphs in these environments, use the
  [.CMD_PAR] command instead of an empty line. Alternatively, you can also
  specify two [.CMD_LINEBREAK line break] commands.

[=NOTE]
.ul
- Horizontal spacing is not controlled. Multiple spaces create multiple
  spaces in the IPF source and also in the helpfile. That applies also to
  text with leading spaces (except for list items).
- An empty line in an IPF source file usually creates a space, not a new
  paragraph. Therefore empty lines should better be avoided in the IPF file!
- The current version of [ [=URL_NEWVIEW] NewView] has still
  some issues with vertical spacing. That is planned to be fixed in v2.20
  of it.
- Therefore the vertical space correction is optimized for View instead of
  NewView, when workarounds for both were not possible.

.. ----------------------------------------
.3 ...by category
.. ----------------------------------------
.an CMD_CATEGORY
.. Explicitly defined dimensions won't be changed by the .SU command
.di 0 0 30 100

.pl compact tsize=5
- Toc and index
= [.CMD_HTOC] - [.CMD_HIDE] - [.CMD_INDEX] - [.CMD_HINDEX] - [.CMD_LOL]
- Pages and headers
= [.CMD_TITLE] - [.CMD_HEADER] - [.CMD_FN] - [.CMD_HRULE]
- Common page options
= [.CMD_HNUMBERING] - [.CMD_HTOC] - [.CMD_HINDEX] - [.CMD_HCLEAR]
- Specific page options
= [.CMD_DIMENSIONS] - [.CMD_RESID] - [.CMD_HIDE] -
  [.CMD_LMARGIN] - [.CMD_RMARGIN]
- Paragraphs and lines
= [.CMD_PAR] - [.CMD_LINEBREAK] - [.CMD_LINES] - [.CMD_EMPTYLINES]
- Alignment
= [.CMD_CENTER] - [.CMD_LINES] - [.CMD_LMARGIN] - [.CMD_RMARGIN]
- Lists
= [.CMD_SLIST] - [.CMD_ULIST] - [.CMD_OLIST] - [.CMD_PLIST] - [.CMD_NOTE]
- Emphasizing
= [.ESC_ATTRIBUTES_STANDARD ##italic##] - [.ESC_ATTRIBUTES_STANDARD **bold**] -
  [.ESC_ATTRIBUTES_STANDARD __underlined__] -
  [.ESC_ATTRIBUTES_MONOSPACE ~~typewriter type~~] - [.CMD_ATTRIBUTE]
- Monospace font and verbatim text
= [.CMD_ATTRIBUTE .ATTRIBUTE TT] - [.CMD_FORMAT .FORMAT TEXT] -
  [.CMD_FORMAT .FORMAT OFF] - [.ESC_ATTRIBUTES_MONOSPACE ~~] - [.CMD_TTCHAR] -
  [.CMD_TTFONT]
- Table
= [.CMD_TABLE]
- Links
= [.LINK_INTERNAL [[section title]]] - [.LINK_INTERNAL [[.ANCHORNAME]]] -
  [.LINK_URL [[URL]]] - [.LINK_INF [[inf:FILENAME search string]]] -
  [.CMD_SUBLINK] - [.CMD_ANCHOR] - [.CMD_ALIAS] - [.CMD_RESID] - [.CMD_LOL]
- Text replacements
= [.LINK_REPLACEMENTS [[=.ANCHORNAME]]] - [.LINK_REPLACEMENTS [[=ENVVARNAME]]]
- Environment variables
= [.CMD_SET] - [.CMD_GET] - [.LINK_REPLACEMENTS [[=ENVVARNAME]]]
- Includes
= [.CMD_INCLUDE] - [.CMD_TEXTINCLUDE] - [.CMD_CINCLUDE] - [.CMD_MIRROR]
- Preprocessing
= [.CMD_IF] - [.CMD_ELSE] - [.CMD_ENDIF] - [.CMD_EXIT]
- Debugging
= [.CMD_TRACE] - [.CMD_HTRACE]

Back to [.CMD]

.. ----------------------------------------
.3 .
.. ----------------------------------------
.an CMD_LINEBREAK

*.* - line break

Example:

.fo off
 This line and
 .
 this line will be split by a line break.
.fo on

A period in the first column forces a line break.

See also: [.CMD_PAR].

.. ----------------------------------------
.3 ..
.. ----------------------------------------

*..* - comment line

Example:

.fo off
 .. This is a comment line
.fo on

Two periods at column one and two start a comment line.

[=NOTE]
.ul compact
- In order to achieve multi-line comments, the [.CMD_IF .IF] command can
  be used:
.fo off
 .if 0 = 1
 These lines
 will be ignored.
 .endif
.fo on
  Except for contained [.CMD_ELSE] or [.CMD_ENDIF] commands,
  every text can be used within the ignored block.

.. ----------------------------------------
.3 .1 to .6
.. ----------------------------------------
.an CMD_HEADER

*.1* to *.6* - page header

Example:

.fo off
 .1 This is the page title
.fo on

These commands open up a new IPF page.

The following rules apply:
.ul compact
- The number is specifying the level, where the top level is 1, the
  lowest possible level is 6.
- The text following the page header command is taken for title of the page
  and must be specified.
- A document always must start with level 1.
- You may not skip a level when increasing the level number, but you
  may of course skip a level when decreasing the level number.

The following would be a *valid* level sequence:
.sl compact
- .1 This is level one
- .2 This is level two
- .3 This is level three
- .1 this is another level one page
- .2 This is level two again
- .2 This is another level two page

The following would be an *invalid* level sequence:
.sl compact
- .1 This is level one
- .3 This is level three
.at hilite
(Level 2 is missing!)
.at
- .1 This is another level one page
- .2 This is level two again
- .2 This is another level two page

.. ----------------------------------------
.3 .ALIAS
.. ----------------------------------------
.an CMD_ALIAS

*.ALIAS* - set a title alias for sublink lists

Example:
.fo off
 .al This is the title alias for this panel
.fo on

This command sets a title alias for the panel where it is defined.
This title alias is uses within lists created with the [.CMD_SUBLINK]
command.

.. ----------------------------------------
.3 .ANCHOR
.. ----------------------------------------
.an CMD_ANCHOR

*.ANCHOR* - set a link or footnote anchor

Example:

.fo off
 .an MY__ANCHOR
.fo on

This command sets a link anchor. It can be used
.ul
- with the [.ESC_LINK_INTERNAL anchor link] in order to refer to the page
  or footnote, where the anchor has been set.
- together with the [.CMD_RESID] command to allow external linkage.

The above anchor would for an internal link be referred to with the
following line:

.fo off
  This is the [[.MY__ANCHOR section for further explanation]].
.fo on

.hr Result of the example above

This is the [.MY_ANCHOR section for further explanation].

(On clicking on the link, the parent panel panel is activated,
because it has the anchor MY__ANCHOR set somewhere on its
page.)

.. ----------------------------------------
.3 .ATTRIBUTE
.. ----------------------------------------
.an CMD_ATTRIBUTE

*.ATTRIBUTE* - set a text attribute or reset to default

Example:

.fo off
 .at hilite
 This text will appear in red!
 .at
.fo on

This command can toggle the following text attributes:
.ul compact
- #bold#
- #italic#
- #underlined#
- #hilite# (turns on red)
- #tt# (use typewriter type font)

Additionally, the following key=value parameters exist:
.ul compact
- #fc=#colorname (foreground color)
- #bc=#colorname (background color)
- #font=#'Font Name' or #font=#'Height.Font Name'
.
  or alternatively: #facename=# with the same meaning as #font=#
- #size=#Height or #size=#HeightxWidth (in points)

[=NOTE]
.ul compact
- You can toggle the #bold#, #italic# and #underlined# attribute also
  with [.ESC_ATTRIBUTES].
- You can specify more than one attribute at a time.
- One or more attributes can be active at a time with the following
  exceptions:
  - #Hilighted# and #typewriter type# ignore all other attibutes if set.
  - #Italic# and #underlined# attribute being active let ignore the #bold#
    attribute.
- You can abbreviate the attribute names to a single character, except
  the key=value parameters.
- Always remember that you toggle attributes on or off, corresponding
  to the current status.
- Specify no attribute to reset all attributes to default.
- To reset only a #fc#, #bc#, #font# or #size# attribute, specify the
  value #default# for it.
- All text attributes are reset automatically at the end of a page.
- Font names are case-sensitive.
- The font value must be enclosed in quotes if it cotains a space.
- View.exe uses #'12.System Proportional'# and #'Courier'# in the size
  #18x12# as standard fonts.
- If a specified font size doesn't exist, the IPF compiler selects a
  similar size. Not all existing sizes can be selected.

Following colors are allowed:
.lm 5
.at italic
.pl compact break=none tsize=25
- black
= darkgray
- darkblue
= blue
- darkgreen
= green
- darkcyan
= cyan
- darkred
= red
- darkpink
= pink
- brown
= yellow
- palegray
= white

.at
.lm
Following font names are allowed:
.lm 5
.at italic
.pl compact break=none tsize=25
- System Proportional
= System Monospaced
- Helv
= System VIO
- Tms Rmn
= Courier

.at
.lm

.. ----------------------------------------
.3 .BITMAP
.. ----------------------------------------
.an CMD_BITMAP

*.BITMAP* - include a bitmap

Example:

.fo off
 This bitmap
 .bi ns.bmp
 is for URL links.
.fo on

This command includes a bitmap into the IPF text. A given bitmap is searched
at the following places:
.ul compact
- within the specified directory (current directory if none specified),
- within the directory, from where *htext.cmd* is called from,
- within the subdirectory *htext* from the directory, from where *htext.cmd*
  is called from,
- within all directories of the *INCLUDE* environment variable, if present,
- within all directories of the *HTINCLUDE* environment variable, if present.

By default, the bitmap is inserted in the current line. In order to align
it on a separate line, an additional parameter for the *.BITMAP* command can
be specified. Following alignment parameters exist:
.pl compact tsize=5
- #left#
= for a left-aligned bitmap
- #center#
= for a centered bitmap
- #right#
= for a right-aligned bitmap.
.el
The values may be abbreviated with one character at least.

For files with spaces in the filename, surround it with either double
or single quotes.

In order to create bitmap links (IPF artlinks), see [.LINK_ADVANCED]. For
other alignment environments, see [.CMD_CENTER] and [.CMD_LINES].

.hr Result of the example above

This bitmap
.bi ns.bmp
is for URL links.

.. ----------------------------------------
.3 .CENTER
.. ----------------------------------------
.an CMD_CENTER

*.CENTER* - center a line

Example:

.fo off
 .ce This line is centered
.fo on

This command centers text on a line. Because IPF's *.ce* control word is
used, the following IPF limitations apply here:
.ul
- The text cannot contain any IPF tags. It can, however, contain nameit
  symbols and IPFC symbols.
- The *.ce* control word's centering effect is limited to text on the same
  line with the control word.

Additionally, a simple [=BASETITLE] text replacement can be used in
the text as well.

See also: [.CMD_LINES].

.. ----------------------------------------
.3 .CINCLUDE
.. ----------------------------------------
.an CMD_CINCLUDE

*.CINCLUDE* - include a C file

Example:

.fo off
 .cinclude header.h
.fo on

This command will include a C source file in order to import
C *##define* symbols as macros.

The file is being searched at the following places:
.ul compact
- within the current or specified directory,
- within all directories of the *INCLUDE* environment variable, if present,
- within all directories of the *HTINCLUDE* environment variable, if
  present.

[=NOTE]
.ul compact
- The *.CINCLUDE* command may not abbreviated!
- All other elements of the C source than *##define* statements are
  ignored.
- Lines of *##define* symbols can be concatenated by a leading backslash.
- All double quotes are simply parsed off.
- Conditional compiles (##if, ##ifdef, ##ifndef ...) are ignored.
- Symbols embedded in a symbol value are resolved.
- Tilde characters (used in strings for PM resources to define key
  accelerators) are scanned off.
- Tab sequences *\t* (used in strings for menu entries) are scanned off.
- For files with spaces in the filename, surround it with either double
  or single quotes.
- To optionally include only a part of a file, specify as second and
  third parameter the line numbers #STARTLINE# #ENDLINE#.

.. ----------------------------------------
.3 .DIMENSIONS
.. ----------------------------------------
.an CMD_DIMENSIONS

*.DIMENSIONS* - define panel dimensions

Example:

.fo off
 .1 This is a help panel
 .di 0 0 50 50
.fo on

This command defines the dimensions of a panel by
specifying four numeric values, which are a percentage
value for the x and y coordinate of the starting point
(starting at the lower left edge) and the width and height.

Specifying '0 0 100 100' would make a panel cover 100% of
the panel area.

[=NOTE]
.ul compact
- If a panel is a subpanel being handled by a [.CMD_SUBLINK] command,
  then specifying *.DIMENSION* values will avoid the usual downscaling.
  That window will have the dimensions specified for the *.DIMENSION*
  command.
- An auto-link won't be added as well for such a panel. Therefore that
  panel won't open automatically with a superior panel.

.. - Any values specified with the *.DIMENSIONS* command are
..   downscaled if the panel, for which it is defined,
..   is a subpanel being handled by a [.CMD_SUBLINK] command.
..   In that case the window will not have the dimensions
..   that you specified with the *.DIMENSIONS* command, but sizes
..   relatively to the area of the screen, that the [.CMD_SUBLINK] command
..   has determined for the window.

.. ----------------------------------------
.3 .ELIST
.. ----------------------------------------
.an CMD_ELIST

*.ELIST* - end list level

Example:

.fo off
 .. end a list level
 .ul compact
 - first item of the main list
 - second item of the main list
   - first list item in the second level
     - first item in the third level
     - second item in the third level
 .el
 .at hi
     and this text belongs to the item in the
     second level again because we ended the
     third level!
 .at
   - last item in the second level
 - last item in the first level
.fo on

This command will end a level of a list created with the
[.CMD_ULIST], [.CMD_OLIST], [.CMD_PLIST], [.CMD_SLIST], [.CMD_TABLE],
[.CMD_LINES] and [.CMD_NOTE] commands. You normally will
require this command only if you use either nested lists or multiple list
levels, and cannot use an empty line within a list to end a level,
because an empty line will end up all open lists.

.hr Result of the example above

.ul compact
- first item of the main list
- second item of the main list
  - first list item in the second level
    - first item in the third level
    - second item in the third level
.el
.at hi
    and this text belongs to the item in the
    second level again because we ended the
    third level!
.at
  - last item in the second level
- last item in the first level

.. ----------------------------------------
.3 .ELSE
.. ----------------------------------------
.an CMD_ELSE

*.ELSE* - switch conditional compile

Example:

.fo off
 .. compile the following if environment variable MYVAR is defined
 .ifdef MYVAR
 the condition is true
 .else
 the condition is false
 .endif
.fo on

This command will switch the condition for conditional compilation,
that can be started with the [.CMD_IF] commands.

[=NOTE]
.ul compact
- The *.ELSE* command may not abbreviated!

.. ----------------------------------------
.3 .ENDIF
.. ----------------------------------------
.an CMD_ENDIF

*.ENDIF* - stop conditional compile

Example:

.fo off
 .. compile the following if environment variable MYVAR is defined
 .ifdef MYVAR
 this is some text
 .endif
.fo on

This command will stop conditional compilation,
that can be started with the [.CMD_IF] commands.

[=NOTE]
.ul compact
- The *.ENDIF* command may not abbreviated!

.. ----------------------------------------
.3 .EXIT
.. ----------------------------------------
.an CMD_EXIT

*.EXIT* - stop compile for the current (include) file

Example:

.fo off
 .EXIT
.fo on

This command will stop compilation of the current file.

[=NOTE]
.ul compact
- If the current file is an include file (included
  with the [.CMD_INCLUDE] command), compilation is ended
  only for the include file, not for the including file.

.. ----------------------------------------
.3 .FORMAT
.. ----------------------------------------
.an CMD_FORMAT

*.FORMAT* - toggle IPF formatting on/off

Example:

.fo text
 .fo off
 This text will appear in monospace font
 (just like the sample here).
 .fo on
 The text here will be layouted by IPF again.
 .fo text
 This text will appear in monospace font.
 Compared to .fo off, even Hypertext/2
 *escape chars* and [links] are not resolved.
 .fo on
.fo on

This command toggles IPF layout off and on. Toggle IPF layout off for
example:
.ul compact
- if you want to create tables,
- if you want to make clear that some text is somewhat special (just like
  the example above),
- if you quote contents from a text window of a special file.

[=NOTE]
.ul compact
- The *.FORMAT TEXT* command is useful for including a text, without
  having to double contained [=TITLE] escape chars. Links and commands are
  not possible as well.
- After *.FORMAT TEXT*, the only recognized command is *.FORMAT ON* (or any
  of its abbreviated variants. All other commands are ignored. Therefore
  it's not possible to let an environment variable insert the *.FORMAT ON*
  line, what would be useful to define an own environment with it. This
  limitation doesn't apply to *.FORMAT OFF*, where all commands are
  recognized.
- See also: [.CMD_TEXTINCLUDE]
- For inline text being set in a monospace (or typewriter type) font, see
  also: [.CMD_TTCHAR], [.ESC_ATTRIBUTES_MONOSPACE] and [.CMD_ATTRIBUTE].

.. ----------------------------------------
.3 .FN
.. ----------------------------------------
.an CMD_FN

*.FN* - footnode header

Example:

.fo off
 .. here is the normal IPF text again linking to
 .. the footnote below.
 Here is the [[MYFOOTNOTE footnote]].
 .fn
 .an MYFOOTNOTE
 This is a footnote and can be linked to with the
 anchor .MYFOOTNOTE.
.fo on

This command creates an IPF footnote.

The following rules apply to footnotes:
.ul compact
- They are linked to exactly like one would link to normal pages.
- You must use the [.CMD_ANCHOR] command to set an anchor for the
  footnote, so that you can link to the footnote with it.

.hr Result of the example above

.. here is the normal IPF text again linking to
.. the footnote below.
Here is the [.MYFOOTNOTE footnote].
.fn
.an MYFOOTNOTE
This is a footnote and can be linked to with the
anchor *.MYFOOTNOTE*.

.. ----------------------------------------
.3 .GET
.. ----------------------------------------
.an CMD_GET

*.GET* - include the value of an env var as source text

Example:
.fo off
 .. set the environment var
 .set MY__VAR=.ul compact|- this is a list item|- another list item||
 .. process the value of the environment var
 .get MY__VAR
.fo on

This command queries the value of an environment variable and processes
its value as [=TITLE] code command.

[=NOTE]
.ul compact
- In the environment var, the bar char | marks a lineend. Two | chars
  produce a new paragraph (via an empty line).
- In the given example, the trailing || ensures, that the list is
  closed. It can also be obtained by an empty line in the main text,
  of course.
- In order to produce | chars specified by the var, the | char has
  to be escaped with a hat symbol: ^|
- As alternate to *.GET*, the value of an environment variable can be
  queried with a [.ESC_LINK_REPLACEMENTS text replacement link] as well,
  like in [[=MY__VAR]].
- See also: [.CMD_SET], [.SAMPLE_CODE_MACRO] and [.SAMPLE_NESTED_ENV_VARS].

.hr Result of the example above

.. set the environment var
.set MY_VAR=.ul compact|- this is a list item|- another list item||
.. process the value of the environment var
.get MY_VAR

.. ----------------------------------------
.3 .HCLEAR
.. ----------------------------------------
.an CMD_HCLEAR

*.HCLEAR* - set header clear attribute

Example:
.fo off
 .. this will automatically add the clear attribute
 .. to all headers of level 2, 3 and 4
 .hc 234
 .
 .. this will stop setting the clear attribute to
 .. any of the upcoming headers
 .hc
.fo on

This command will automatically add the clear attribute to all headers, that
apply to the specified levels. The clear attribute lets IPF close all open windows
when a window with this attribute is opened.

This is very useful when using the .[.CMD_SUBLINK] commands to split windows, which
otherwise would leave a lot of windows open when jumping between windows.
Usually you will likely determine one level in your header hierarchy, that will
split windows first. It is recommended to specify exactly this level with
the *.HCLEAR* command. As an alternative, you can also specify the *clear* attribute
with every [.CMD_SUBLINK] command.

Specifying no headers will clear the list of levels to get the clear attribute set.

.. ----------------------------------------
.3 .HIDE
.. ----------------------------------------
.an CMD_HIDE

*.HIDE* - hides a panel from the contents list

Example:

.fo off
 .3 this is a help panel not appearing in the contents list
 .hid
.fo on

This command will hide the panel from the contents view.

[=NOTE]
.ul compact
- Although it comes before the [.CMD_HINDEX] command in alphabetic order,
  you have to specify at least three letters of the *.HIDE* command,
  so at least
.fo off
 .hid
.fo on
 in order to distinct it from the [.CMD_HINDEX] command. This is done to keep
 compatibility with older files having been compiled using older versions of [=TITLE],
 where otherwise .hi would not mean to be the [.CMD_HINDEX] anymore.
- Due to a restriction in the INF/HLP file viewer of *OS/2*, the panel is not
  hidden if a subpanel exists that is not hidden, even if the hide attribute
  is set for the panel to be hidden.
- The plus and minus sign of a parent panel will still appear, even
  if all child panels of that parent panel are hidden. To avoid that,
  don't make the hidden panel a child panel, but raise it to the same
  level as the former parent panel. Unfortunately, this is not possible
  if you have to keep the level hierarchy because of
  used [.CMD_SUBLINK] commands.

.. ----------------------------------------
.3 .HINDEX
.. ----------------------------------------
.an CMD_HINDEX

*.HINDEX* - auto add page headers to index

Example:

.fo off
 .. this will automatically add all upcoming
 .. headers of level 2, 3 and 4 to the index
 .hi 234
 .
 .. this will stop adding any of the upcoming
 .. headers to the index
 .hi
.fo on

This command will automatically add all pages to the index, that apply to the
specified levels. This saves you from having to place an [.CMD_INDEX] command
manually to all desired pages. Specifying no headers will clear the list
of levels to be added to the index.

.. ----------------------------------------
.3 .HNUMBERING
.. ----------------------------------------
.an CMD_HNUMBERING

*.HNUMBERING* - number page headers

Examples:

.fo off
 .. this will automatically precede the
 .. headers of level 1, 2 and 3 with section
 .. numbers
 .hn 123
 .
 .. this will stop header numbering
 .hn
 .
 .. this will automatically precede the
 .. headers of level 1 and 2 with section
 .. numbers, while for level 1 alphabetical
 .. numbering is used, e.g. for the appendix
 .hn A2
.fo on

This command specifies if page headers should be numbered automatically.
All pages of the specified list of levels are numbered. For the first
level only, *A* can be specified optionally in order to produce uppercase
alphabetic numbering for the first level. The numbers are separated with
a period, while the trailing period is stripped off. The processed
headers look like e.g
.sl compact
- *1.5.2  Page header* or
- *B.3  Appendix page header*.

All numbers can be reset to 0 with

.fo off
 .hn reset
.fo on

This is useful before you change to alphabetical numbers.

Leading levels in the specified header levels can be omitted, like in
.fo off
 .hn 234
 .hn B34
.fo on

This is useful when you've decided to use the first header level as a
document part level and start with the numbered page hierarchy at the
second header level.

.. ----------------------------------------
.3 .HRULE
.. ----------------------------------------
.an CMD_HRULE

*.HRULE* - create a horizontal rule with optional header text

Example:

.fo off
  This is text of the previous paragraph.
  .hr norule bold italic darkblue Paragraph divider header
  This is text after the paragraph divider.
.fo on

The command can be used to separate one paragraph from
another, without having to create a separate page for it.

Because in IPF no tag for a horizontal rule exists, it's been
created with 80 underscore signs, followed by a line break. Above
and below a paragraph divider one empty line is created. The underscores
make the skip to the previous paragraph appear larger than to the
paragraph below. The paragraph divider header appears below the rule,
because every try to make it appear above looks ugly.
The header can be omitted to create a rule only.

.ul compact
- The following style keywords can be specified:
.pl compact tsize=1
  - #norule#
  = omit the rule above the header (by default, the rule is added)
  - #bold#  #italic#  #underlined#  #normal#
  = specify attribute for the header text (by default, the #bold# attribute
    is set and #normal# was added to reset it, while any specified attribute
    resets it, too)
  - #darkblue# (or any other foreground color listed in the [.CMD_ATTRIBUTE]
    section)
  = specify a color for the header and the rule (if specified, also the
    default #bold# attribute is reset).
.el
- The header text can be specified in two ways: either with or
  without a keyword:
.pl compact tsize=1
  - #text=#'Header text' or #text=#"Header text"
  = The text itself must be enquoted if it consists of multiple words.
    The so-specified header text doesn't have the following limitations,
    but is a bit harder to type and read.
  - Header text
  = This one cannot start with a word being a known style keyword from
    the list above. All style keywords have to be specified before the
    text. Any word, not being known as style keyword, would make the rest
    of the parameter line be handled as header text.
- The header text is optional. *.hr* creates a rule only.
- The vertical space above is set to two empty lines, below to one empty
  line at least.
- The command *.hr* #norule# creates only vertical space of two empty
  lines.
- Without a specified text attribute or foreground color, the default
  attribute #bold# applies.
  For an example of its appearance, see the following *.hr* paragraph
  divider, introducing the result of the example above:

.hr Result of the example above

This is text of the previous paragraph.
.hr norule bold italic darkblue Paragraph divider header
This is text after the paragraph divider.

.. ----------------------------------------
.3 .HTOC
.. ----------------------------------------
.an CMD_HTOC

*.HTOC* - header levels shown in toc

Example:

.fo off
 .. this will add all headers of level 1
 .. and 2 to the table of contents
 .htoc 12
.fo on

This command controls the header levels displayed in the table of contents.
By default all header levels are included.

[=NOTE]
.ul compact
- The *.HTOC* command may not abbreviated!

.. ----------------------------------------
.3 .HTRACE
.. ----------------------------------------
.an CMD_HTRACE

*.HTRACE* - activate interactive debugging for a header/page

This command activates the REXX instruction [inf:rexx TRACE] with
parameter ?i for the rest of the current page. Tracing is
automatically deactivated when the next header occurs.

[=NOTE]
.ul compact
- See also: [.CMD_TRACE]

.. ----------------------------------------
.3 .IF/.IFDEF/.IFNDEF
.. ----------------------------------------
.an CMD_IF

*.IF* - start conditional compile

Examples:
.fo off
 .. compile the following if environment
 .. variable MYVAR is defined
 .ifdef MYVAR
 .endif
 .
 .. compile the following if environment
 .. variable MYVAR is not defined
 .ifndef MYVAR
 .endif
 .
 .. compile the following if environment
 .. variable MYVAR is equal to '1'
 .. and MYVAR2 is equal to '2'
 .if MYVAR=1 & MYVAR2=2
 .endif
.fo on

This command will conditionally compile source until the
next *.ELSE* or *.ENDIF*.

The following rules apply to conditional compilation:
.ul compact
- Only environment variables can be examined with the .IF** commands.
- The .IF** commands may not be nested.
- The .IF command supports
  - for comparison only the equal operator
  - for evaluation of boolean expressions the operators
     - & for logical *and*
     - | for logical *or*
  - while you *cannot* use round brackets to group boolean expressions!

[=NOTE]
.ul compact
- The *.IFDEF* and *.IFNDEF* commands may not abbreviated!
- See also the commands [.CMD_ELSE] and [.CMD_ENDIF].

.. ----------------------------------------
.3 .INCLUDE
.. ----------------------------------------
.an CMD_INCLUDE

*.INCLUDE* - include a hypertext file

Example:

.fo off
 .include subchapter.txt
.fo on

This command will include another [=TITLE] source compatible
textfile. The file is being searched at the following places:
.ul compact
- within the current or specified directory,
- within all directories of the *INCLUDE* environment variable, if present,
- within all directories of the *HTINCLUDE* environment variable, if
  present.

[=NOTE]
.ul compact
- The *.INCLUDE* command may not abbreviated!
- Anchor names and other elements of the source syntax of [=TITLE] are
  resolved. In order to have a file included without any modification,
  you have to use the [.CMD_TEXTINCLUDE] command.
- For files with spaces in the filename, surround it with either double
  or single quotes.
- To optionally include only a part of a file, specify as second and
  third parameter the line numbers #STARTLINE# #ENDLINE#.

.. ----------------------------------------
.3 .INDEX
.. ----------------------------------------
.an CMD_INDEX

*.INDEX* - add a page to the index with an alternative text

Example:

.fo off
 .. add the page to the index with the title text
 .in
 .. add the page to the index with an alternate text
 .in This is a special page!
.fo on

This command adds the current page to the index, using either:
.ul compact
- the page title, if no alternate text is specified or
- the text specified.

[=NOTE]
.ul compact
- You can add the same page with different text as many times as you want.

.. ----------------------------------------
.3 .LINES
.. ----------------------------------------
.an CMD_LINES

*.LINES* - format a block with line breaks as specified

Example:

.fo off
 .li r
 These lines are right-aligned.
 This is a longer line. This is a longer line. This is a longer line.
 .p
 This is the last line.

 This is normal text.
.fo on

This command starts an environment, where the contained lines are
formatted as specified, without adding line breaks.

By default, the lines are left-aligned, but that can be changed
with an additional parameter for the *.LINES* command. Following
alignment parameters exist:
.pl compact tsize=5
- #left#
= for a left-aligned bitmap
- #center#
= for a centered bitmap
- #right#
= for a right-aligned bitmap.
.el
The values may be abbreviated with one character at least.

At its start and end an empty line is added by the environment.

The environment must be ended either by an [.CMD_ELIST] command or by
an empty line.

See also: [.CMD_CENTER].

.hr Result of the example above

.li r
These lines are right-aligned.
This is a longer line. This is a longer line. This is a longer line.
.p
This is the last line.

This is normal text.

.. ----------------------------------------
.3 .LMARGIN
.. ----------------------------------------
.an CMD_LMARGIN

*.LMARGIN* - set left margin

Example:

.fo off
 .. set left margin to 5
 .lm 5
 .. reset left margin to default (that is 1)
 .lm
.fo on

This command sets the left margin.

[=NOTE]
.ul compact
- Due to a limitation of the IPF compiler, you cannot set the left margin
  to zero. The standard value for the left margin is 1.
- For indenting a block, it's recommended to use common indent values. All
  lists use an indent equivalent to *.LMARGIN 5*, except the [.CMD_PLIST]
  command, that uses 10 as default value. (In order to create more
  homogeneous documents, you should better try to set that to 5 as well
  or, at least, always advance the margin value in steps of 5.)
- The command takes effect for the following paragraphs (not the
  current) of a page.

.. ----------------------------------------
.3 .LOL
.. ----------------------------------------
.an CMD_LOL

*.LOL* - insert list of internet links

Example:

.fo off
 The following internet links are used in this
 document:
 .lol
.fo on

This command creates an unordered compact list with all internet links
being used before its occurence. This means, that you have to put it
at the end of the document to include them all.

[=NOTE]
.ul compact
- The command may not be abbreviated!
- The list can also be used to validate the links easily.
- For the result of the example above, see [.IDPNL_LOL].

.. ----------------------------------------
.3 .MIRROR
.. ----------------------------------------
.an CMD_MIRROR

*.MIRROR* - mirror a page

Example:

.fo off
 .. mirror the contents of another page
 .mi MIRRORED-PAGE

 This text is completely ignored, because only
 the contents of the mirrored page will be displayed in
 this page.
.fo on

This command mirrors the contents of another page, that
you define with its anchorname.

The following rules apply to mirroring pages:
.ul compact
- All other content of the page is ignored, only the content
  of the mirrored page is inserted.
- You can mirror only one page. If you specify the *.MIRROR*
  command more than once within a page, only the last specified
  page is mirrored.
- All attributes of the mirrored page, which have been set by a
  [.CMD_SUBLINK], are copied to the mirroring page.

.. ----------------------------------------
.3 .NOTE
.. ----------------------------------------
.an CMD_NOTE

*.NOTE* - start a note environment

Example:

.fo off
 .. using here the unordered and compact options
 .note u compact
 - Use this command to include paragraphs in a note.
   You also can use it within paragraphs and lists.
 - End this environment before you begin another
   note environment, either by an **.el** command or
   an empty line.
 - Always include the text attributes and maybe the
   trailing colon in the note text.

 .. .note is ended by an empty line
.fo on

This command starts a new paragraph with *Note:*, followed by an empty
line. After that, a list is opened. Therefore the text of a *.NOTE*
environment must start with a minus sign, as it applies for any other
list as well.

Notes can be placed within lists and paragraphs. *.NOTE* requires an
[.CMD_ELIST] command or an empty line at the end.

By default, a simple list is created. You can specify a list type as
parameter for the *.NOTE* command to select another list. Following list
types exist for a note environment:
.pl compact tsize=5
- #ordered#
- #unordered#
- #simple# (default)
.el
The type values may be abbreviated with one character at least. Other
command parameters were submitted to the created list, so you can use
other list parameters that exist for the selected list as well, like
e.g.:
.pl compact tsize=5
- #compact#
= do not place empty lines between items
.el
To configure the text and maybe the emphasizing of the preceding
line, you can set an environment variable, maybe with the [.CMD_SET]
command, e.g.:
.fo off
 .set note=##My special note:##
.fo on
The default behavior is to use bold attributes around the word "Note:":
.fo off
 .. default definition:
 .set note=**Note:**
.fo on
In order to change the note text and emphasizing only for the current
note, specify the following parameter:
.pl compact tsize=5
- #text=#MyNoteText
= Text without spaces can be specified unenquoted.
- #text=#'My note text' or #text=#"My note text"
= Enquote the text if it contains spaces.
.el

.hr Result of the example above

.note u compact
- Use this command to include paragraphs in a note.
  You also can use it within paragraphs and lists.
- End this environment before you begin another
  note environment, either by an *.el* command or
  an empty line.
- Always include the text attributes and maybe the
  trailing colon in the note text.

.. ----------------------------------------
.3 .OLIST
.. ----------------------------------------
.an CMD_OLIST

*.OLIST* - create ordered list

Example:

.fo off
 .ol compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
.fo on

This command creates an ordered list.
The following rules apply to ordered lists:
.ul compact
- The following parm can be specified:
.pl compact italic tsize=1
  - compact
  = do not place empty lines between items
- A list must be terminated by an empty line.
- A list level can explicitly be ended with the [.CMD_ELIST] command.
- An item starts with a minus sign as the item marker being the first
  non-space character on the line.
- The indentation of the items are determined by the position of the
  item markers.
- Leading spaces in the source text are stripped off.

.hr Result of the example above

.ol compact
- this is item 1
- this is item 2
  - this is item 2.1
    - this is item 2.1.1
- this is item 3

.. ----------------------------------------
.3 .PAR
.. ----------------------------------------
.an CMD_PAR

*.PAR* - start a new paragraph

Example:

.fo off
 This is a line.
 .p
 This is a line in a new paragraph.

 This is a line in another paragraph.
.fo on

A *.PAR* always adds an empty line and starts a new paragraph. Compared to
just adding an empty line instead, *.PAR* makes sense in following cases:

.ul compact
- when a list item should contain multiple paragraphs
- when vertical space of more than one empty line should be added (multiple
  empty lines are always combined to one)
- when vertical space at the top of a page should be added.

[=NOTE]
.ul compact
- The *.PAR* command doesn't end a list, like an empty line does. The
  indentation of the current environment is kept.

.. ----------------------------------------
.3 .PLIST
.. ----------------------------------------
.an CMD_PLIST

*.PLIST* - create parameter list

Example:

.fo off
 .pl compact bold
 - term 1
 = definition 1
 - term 2
 = definition 2
 - term 3
 = definition 3
 .
 spanning two lines
.fo on

This command creates a parameter list. An entry
of a parameter list always consist of two elements:
the parameter term and the parameter definition explaining
the term.

The following rules apply to parameter lists:
.ul compact
- The following parameters can be specified:
.pl compact tsize=1
  - #compact#
  = do not place empty lines between items
  - #break=fit# or #break=none#
  = controls break between parameter term and definition
  - #tsize=n#
  = specifies the size for the parameter term. Default is 11 character units.
  - #bold  italic  underlined  hilite#
  = one or more [.CMD_ATTRIBUTE text attributes] to be used for the
    parameter term.
- A list must be terminated by an empty line.
- A list level can explicitly be ended with the [.CMD_ELIST] command.
- The first part of a parameter, the so-called parameter term, starts with
  a minus sign being the first non-space character on the line.
- The second part of a parameter, the so-called parameter definition, starts
  with an equal sign being the first non-space character on the line.
- Both term and definition can span over several lines.
- Leading spaces in the source text are stripped off.

[=NOTE]
.ul compact
- The minimum for #tsize# is 1, not 0. If 0 is specified, the default
  value applies.
- The default value for #tsize# is 10, while the default one used by the
  other lists is 5. Therefore in many cases it looks better to use
  #tsize=5# here as well, at least for unnested plists. (The parameter
  list [.CMD_BITMAP here] was set with #compact tsize=5#.)
- When nesting the *.PLIST* command with other list commands
  [.CMD_SLIST], [.CMD_OLIST] and [.CMD_ULIST], the #tsize# attribute does
  not work properly. (The parameter list above was formatted with
  #compact tsize=1#, but looks like been set with #tsize=5#.)
- To make indentations look better, use only the following values for
  #tsize#: 1, 5, 10, 15 (5**i).
- Without the #break=# attribute, the definition text always starts on
  a new line. With #break=none#, the definition text follows on the same
  line, after the term text. With #break=fit#, it only starts on the same
  line if the term text fits into the #tsize# value.
- See also: [.SAMPLE_PLIST1], [.SAMPLE_PLIST2] and [.SAMPLE_PLIST3].

.hr Result of the example above

.pl compact bold
- term 1
= definition 1
- term 2
= definition 2
- term 3
= definition 3
.
spanning two lines

.. ----------------------------------------
.3 .RESID
.. ----------------------------------------
.an CMD_RESID

*.RESID* - set a numeric resource id for a panel

Example:
.fo off
 .. set numeric resource id for external linkage
 .re 6001
 .. don't forget to set an anchor, otherwise the
 .. resid is quite useless
 .an EXTERNAL__PANEL
.fo on

This sets a resource id for external linkage for INF and HLP files.
You need external linkage when
.ul
- several INF files are viewed together concatenated like
.fo off
  start view file1.inf+file2.inf+file3.inf
.fo on
  and you want to link between the files.
- an application wants to display context sensitive help panels
  from within an application.

[=NOTE]
.ul compact
- Specify the [.USAGE_DIRECTLY parameter /RCH] for [=TITLE] to
  additionally generate a resource header file with all external
  resource ids.

.. ----------------------------------------
.3 .RMARGIN
.. ----------------------------------------
.an CMD_RMARGIN

*.RMARGIN* - set right margin

Example:
.fo off
 .. set right margin to 10
 .rm 10
 .. reset right margin to default (that is 0)
 .rm
.fo on

This command sets the right margin.

[=NOTE]
.ul compact
- The command takes effect for the following paragraphs (not the
  current) of a page.

.. ----------------------------------------
.3 .SET
.. ----------------------------------------
.an CMD_SET

*.SET* - set an environment variable

Example:

.fo off
 .. set the environment variable MYVAR to 1
 .set MYVAR=1
.fo on

This command will set a variable, that can be used
.ul compact
- to control conditional compilation with the [.CMD_IF] commands
- for text replacement
- for code macros.

[=NOTE]
.ul compact
- Since environment variables are resolved immediately on their reference
  with [.CMD_GET] or [.ESC_LINK_REPLACEMENTS text replacement links], they can be
  defined multiple times with different values.
- An environment variable, being set with the *.SET* command,
  will not remain after program termination.
- The variable value may contain values of other environment variables
  specified by a text link: [.ESC_LINK_REPLACEMENTS [[=ENVVARNAME]]]. See
  also: [.SAMPLE_NESTED_ENV_VARS].
- In the value string, the bar char | marks a lineend. Two | chars
  produce a new paragraph (via an empty line).
- In order to produce | chars specified by the var, the | char has
  to be escaped with a hat symbol: ^|
- For an example about defining code macros and using the bar char, see:
  [.SAMPLE_CODE_MACRO].
- See also: [.CMD_GET].

.. ----------------------------------------
.3 .SLIST
.. ----------------------------------------
.an CMD_SLIST

*.SLIST* - create simple list

Example:

.fo off
 .sl compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
.fo on

This command creates a simple list (without bullets or characters).
It is useful for creating indented blocks. For listing items, the
[.CMD_ULIST], [.CMD_OLIST] and [.CMD_PLIST] commands are more suited.

The following rules apply to simple lists:
.ul compact
- The following parm can be specified:
.pl compact italic tsize=1
  - compact
  = do not place empty lines between items
- A list must be terminated by an empty line.
- A list level can explicitly be ended with the [.CMD_ELIST] command.
- An item starts with a minus sign as the item marker being the first
  non-space character on the line.
- The indentation of the items are determined by the position of the item
  markers.
- Leading spaces in the source text are stripped off.

.hr Result of the example above

.sl compact
- this is item 1
- this is item 2
  - this is item 2.1
    - this is item 2.1.1
- this is item 3

.. ----------------------------------------
.3 .SUBLINK
.. ----------------------------------------
.an CMD_SUBLINK

*.SUBLINK* - creates a sublink list and/or splits windows

Example:

.fo off
  .. this sample creates three vertical windows
  .2 .SUBLINK sample - three rows
  .fo off
   .su H30 u
  .fo on
  .su H30 u

  .3 middle panel
  .fo off
   .su H30 u
  .fo on
  .su H30 u

  .4 lower panel
  .
  This window has only a height of 40% of the complete width of the INF
  application space, as the other two windows use up to 60% of it.
.fo on

This command
.ul compact
- creates a list of links to pages below the current level
  (see the section about [.CMD_HEADER header levels]) and
- splits up the window into several so-called viewports.

You can also omit either action, thus only creating the list or
only splitting up the window. Note that you can use the [.CMD_ALIAS]
command to define an alternate string for each subpanel in case that
you don't like the true titles of the subpanels to appear in the list
created by the *.SUBLINK* command.


The *.SUBLINK* command supports the following parameters:
.pl break=none tsize=15
- *x*
= where x is is the maximum levels below the current one
  that are to be processed. Specify
.pl break=none tsize=5
  - #1# to #n#
  = how all pages below the level of the current page not deeper than 1 to n
  - #0#
  = to show all pages below the level of the current page without a level
    limit
  - #-1#
  = show all following pages of exactly the same level, but not including
    subpages.
- *anchor*
= starting with a period, where the anchor defines the start page, from which the
  sublink list should determined from. Default is the current page, that
  contains the *.SUBLINK* command.
.
  This parameter may not be combined with the parameter for splitting windows.
- *list type*
= specifying one of the following values (abbreviation allowed):
.ul compact
  - #unordered#
  - #ordered#
  - #simple#
  - #breaks# (uses line breaks instead of list items)
  - #nolist# (splits windows, but creates no list)
- *clear*
= where this parameter sets the clear attribute for the link window. This
  will close all other windows before when this window is opened.
- *Vxx* or *Hxx*
= where xx is a portion of 100 percent points of width or height, where the
  screen should be split between this and the sublink pages vertically or
  horizontally. xx must be between 20 and 80 and specfies the height or width
  of the source window. The remaining percent points of screen width and
  height are used for the linked target windows.
.
  This parameter may not be specified together with an anchor name
  to determine the start page.

The following restrictions apply to sublink lists:
.ul compact
- You can use the .SUBLINK command only once per page!
- The parameters for anchor name and for splitting windows are
  mutually exclusive.

For examples for the *.SUBLINK* command, see also:
.ul compact
- [.SAMPLES_SUBLINK]
.su u 1 .SAMPLES_SUBLINK

.. ----------------------------------------
.3 .TABLE
.. ----------------------------------------
.an CMD_TABLE

*.TABLE* - create a table

Example:

.fo off
 .table cols='12 15 12' rules=both frame=box
 - 1.st item
 = 2.nd item
 = 3.rd item
 - new row!
 = next item
 = last item
.fo on

This command will create a table in monospace font.

The following rules apply to tables:
.ul compact
- The following parms can be specified:
.pl compact tsize=1
  - #cols='w1 w2 w3 ...'# or #cols="w1 w2 w3 ..."#
  = specifies the width of the columns
  - #rules=both# or #rules=horiz# or #rules=vert# or #rules=none#
  = specifies where to draw rules
  - #frame=rules# or #frame=box# or #frame=none#
  = specify where to draw borders (#rules# draws a rule at
    the top and the bottom of a table).
- A table must be terminated by an empty line.
- A table can explicitly be ended with the [.CMD_ELIST] command.
- The first item on a new row starts with a minus sign being the
  first non-space character on the line.
- A new item on the same row starts with am equal sign being the
  first non-space character on the line.
- All items can span over several lines.

.hr Result of the example above

.table cols='12 15 12' rules=both frame=box
- 1.st item
= 2.nd item
= 3.rd item
- new row!
= next item
= last item

.. ----------------------------------------
.3 .TEXTINCLUDE
.. ----------------------------------------
.an CMD_TEXTINCLUDE

*.TEXTINCLUDE* - include a text file

Example:
.fo off
 .textinclude textfile.txt
.fo on

This command will include a text file. The file is being searched at the
following places:
.ul compact
- within the current or specified directory,
- within all directories of the *INCLUDE* environment variable, if present,
- within all directories of the *HTINCLUDE* environment variable, if
  present.

[=NOTE]
.ul compact
- The *.TEXTINCLUDE* command may not abbreviated!
- Anchor names and other elements of the source syntax of [=TITLE] are not
  resolved. In order to have a [=TITLE] source textfile included, you have
  to use the [.CMD_INCLUDE] command.
- For files with spaces in the filename, surround it with either double
  or single quotes.
- To optionally include only a part of a file, specify as second and
  third parameter the line numbers #STARTLINE# #ENDLINE#.
- See also: [.CMD_FORMAT]

.. ----------------------------------------
.3 .TITLE
.. ----------------------------------------
.an CMD_TITLE

*.TITLE* - set document title

Example:

.fo off
 .ti This is the document title
.fo on

This command sets the document title. Specify that command as the very
first command in your [=TITLE] compatible source file.

.. ----------------------------------------
.3 .TRACE
.. ----------------------------------------
.an CMD_TRACE

*.TRACE* - activate interactive debugging

This command activates the REXX instruction [inf:rexx TRACE] with
parameter ?i for the rest of the document.

[=NOTE]
.ul compact
- See also: [.CMD_HTRACE]

.. ----------------------------------------
.3 .TTCHAR
.. ----------------------------------------
.an CMD_TTCHAR

*.TTCHAR* - specify a typewriter type escape char

Example:

.fo off
 Always enable the escape char
 before its first usage:
 .ttchar ~~
 .
 This line has a ~~Typewriter Type text~~ part.
.fo on

[=NOTE]
.ul compact
- You have to enable the ttfont escaping before its first usage
  by the *.TTCHAR* command.
- Specifying *.TTCHAR* without an argument, resets the
  escape char.
- The *.TTCHAR* command may not abbreviated!
- See also: [.CMD_TTFONT], [.ESC_ATTRIBUTES_MONOSPACE], [.CMD_FORMAT].

.hr Result of the example above

Always enable the escape char
before its first usage:
.ttchar ~
.
This line has a ~Typewriter Type text~ part.

.. ----------------------------------------
.3 .TTFONT
.. ----------------------------------------
.an CMD_TTFONT

*.TTFONT* - change typewriter type inline font

Example:

.fo off
 That command specifies an alternate font
 being used as typewriter type font for the
 following text in the source file:
 .ttfont facename='System VIO' size=20x12
.fo on

[=NOTE]
.ul compact
- The *.TTFONT* command may not abbreviated!
- The font specification is case-sensitive.
- IPF selects the standard text font, when the specification
  was invalid.
- The standard ttfont is #facename=Courier size=18x12#
- Specifying *.TTFONT* without an argument, resets the
  ttfont to the standard value.
- This command doesn't affect the font being used for
  [.CMD_FORMAT] environments.
- IPF lacks a tag for inline tt text parts. Therefore the font
  specification is hard-coded in your help file, using the IPF
  *:font.* tag.
-
.at hilite
  You should better avoid to change the standard ttfont,
.at fc=default
  when you plan to distribute your help file. That saves
  compatibility.
- The standard ttfont appears much too large with higher screen
  resolutions. Users of NewView can replace one hard-coded
  typewriter type font with the one they have selected for
  typewriter type paragraphs. Users of VIEW.EXE can't adjust
  anything.
- Regarding those drawbacks, you should decide first, if you better
  omit the use of typewriter type inline text at all.
- See also: [.CMD_TTCHAR], [.ESC_ATTRIBUTES_MONOSPACE].

.. ----------------------------------------
.3 .ULIST
.. ----------------------------------------
.an CMD_ULIST

*.ULIST* - create unordered list

Example:

.fo off
 .ul compact
 - this is item 1
 - this is item 2
   - this is item 2.1
     - this is item 2.1.1
 - this is item 3
.fo on

This command creates an unordered list.
The following rules apply to unordered lists:
.ul compact
- The following parm can be specified:
.pl compact italic tsize=1
  - compact
  = do not place empty lines between items
- A list must be terminated by an empty line.
- A list level can explicitly be ended with the [.CMD_ELIST] command.
- An item starts with a minus sign as the item marker being the first
  non-space character on the line.
- The indentation of the items are determined by the position of the item
  markers.
- Leading spaces in the source text are stripped off.

[=NOTE]
.ul compact
- See also: [.SAMPLE_LIST].

.hr Result of the example above

.ul compact
- this is item 1
- this is item 2
  - this is item 2.1
    - this is item 2.1.1
- this is item 3

