/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import sunw.hotjava.ui.DragAndDropEvent;
import sunw.hotjava.ui.DragAndDropEventMulticaster;
import sunw.hotjava.ui.DragAndDropListener;
import sunw.hotjava.ui.DragStartInfo;
import sunw.hotjava.ui.ListContainer;
import sunw.hotjava.ui.ListElement;
import sunw.hotjava.ui.ListItem;
import sunw.hotjava.ui.ListItemComponent;

public class ListCanvas
extends Canvas {
    ListContainer mainFolder;
    ListItem currentIcon;
    ListItem movingIcon;
    ListItem selectedItem;
    Image element_img;
    Image open_img;
    Image closed_img;
    Cursor hand_cursor = new Cursor(12);
    Cursor default_cursor = new Cursor(0);
    Dimension canvas_size;
    Panel panel;
    boolean debug = false;
    String title;
    boolean dragged = false;
    boolean handleDrop = true;
    int adjustmentFactor;
    private ListItemComponent draggee;
    private DragAndDropEvent dragStartEvent;
    protected DragAndDropListener listeners;
    Rectangle hiliteRect;

    public void dbg(String string) {
        if (this.debug) {
            System.out.println("debug> " + string);
        }
    }

    public DragAndDropListener getDragAndDropListener() {
        return new DnDListener();
    }

    public synchronized void addDragAndDropListener(DragAndDropListener dragAndDropListener) {
        this.listeners = DragAndDropEventMulticaster.add(this.listeners, dragAndDropListener);
    }

    public synchronized void removeDragAndDropListener(DragAndDropListener dragAndDropListener) {
        this.listeners = DragAndDropEventMulticaster.remove(this.listeners, dragAndDropListener);
    }

    public void dispatchDragAndDropEvent(DragAndDropEvent dragAndDropEvent) {
        if (this.listeners != null) {
            this.listeners.dragAndDropPerformed(dragAndDropEvent);
        }
    }

    public ListCanvas(Panel panel, String string, int n, int n2) {
        this.title = string;
        this.panel = panel;
        this.setSize(n, n2);
        this.addMouseListener(new ListCanvasMouseListener());
        this.addMouseMotionListener(new ListCanvasMouseListener());
    }

    public void setListElementImage(Image image) {
        this.element_img = image;
    }

    public Image getListElementImage() {
        return this.element_img;
    }

    public void setListContainerImages(Image image, Image image2) {
        this.open_img = image;
        this.closed_img = image2;
    }

    public Image getOpenContainerImage() {
        return this.open_img;
    }

    public Image getClosedContainerImage() {
        return this.closed_img;
    }

    public void createInitialFolder() {
        this.mainFolder = new ListContainer(this, null, this.title, this.open_img, this.closed_img);
        this.mainFolder.setCanvas(this);
    }

    static Point getTranslatedPoint(int n, int n2, Component component, Component component2) {
        Component component3 = component2;
        while (component3 != null && component3 != component) {
            Rectangle rectangle = component3.getBounds();
            n -= rectangle.x;
            n2 -= rectangle.y;
            component3 = component3.getParent();
        }
        if (component3 != null) {
            return new Point(n, n2);
        }
        return null;
    }

    public boolean processDragAndDropEvent(DragAndDropEvent dragAndDropEvent) {
        Component component = (Component)dragAndDropEvent.getSource();
        Point point = ListCanvas.getTranslatedPoint(dragAndDropEvent.getX(), dragAndDropEvent.getY(), component, this);
        switch (dragAndDropEvent.getID()) {
            case 91959: {
                ListItemComponent listItemComponent = (ListItemComponent)dragAndDropEvent.getArgument();
                ListItem listItem = listItemComponent.getBaseItem();
                Point point2 = listItem.getPoint();
                ListContainer listContainer = listItem.getParentListContainer();
                this.mainFolder.resolveItemLocation(listItem, new Point(point.x, point.y));
                if (listItem.getPoint().equals(point2) && listItem.getParentListContainer() == listContainer) {
                    this.handleDrop = false;
                    Graphics graphics = this.getGraphics();
                    try {
                        this.eraseHiliteBox(graphics);
                        break;
                    }
                    finally {
                        Object var10_9 = null;
                        graphics.dispose();
                    }
                }
                this.handleDrop = true;
                this.adjustSize();
                this.repaint(50L);
                break;
            }
            case 91962: {
                this.processHiliteEvent(component, point);
                break;
            }
        }
        return true;
    }

    public void processHiliteEvent(Component component, Point point) {
    }

    public void processCanvasMouseEvent(MouseEvent mouseEvent) {
        mouseEvent.getPoint();
        switch (mouseEvent.getID()) {
            case 501: {
                this.mousePressedOnCanvas(mouseEvent);
                return;
            }
            case 502: {
                this.mouseReleasedOnCanvas(mouseEvent);
                return;
            }
            case 506: {
                this.mouseDraggedOnCanvas(mouseEvent);
                return;
            }
        }
    }

    public boolean mousePressedOnCanvas(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.requestFocus();
        if (this.mainFolder == null) {
            return true;
        }
        ListItem listItem = this.mainFolder.locateItem(point.x, point.y);
        if (listItem == null || listItem.getCanvas() != this) {
            return true;
        }
        this.setCursor(this.hand_cursor);
        if (this.selectedItem != null) {
            this.selectedItem.toggleSelected();
        }
        listItem.setSelected(true);
        this.selectedItem = listItem;
        this.repaint();
        if (this.isDragSource()) {
            ListItem listItem2 = (ListItem)listItem.clone();
            listItem2.location = new Point(0, 0);
            listItem2.setSelected(true);
            this.draggee = new ListItemComponent(listItem2, listItem);
            Point point2 = this.getAdjustedLocation(listItem.location);
            this.adjustmentFactor = listItem.location.y - point2.y;
            this.dragStartEvent = this.makeDragStart(this.draggee, listItem.location, point.x, point.y);
        }
        return true;
    }

    protected Point getAdjustedLocation(Point point) {
        return point;
    }

    protected int getAdjustmentFactor() {
        return this.adjustmentFactor;
    }

    protected boolean isDragSource() {
        return true;
    }

    private DragAndDropEvent makeDragStart(Component component, Point point, int n, int n2) {
        Point point2 = new Point(n - point.x, n2 - point.y);
        DragStartInfo dragStartInfo = new DragStartInfo(this, component, point, point2, this.adjustmentFactor);
        DragAndDropEvent dragAndDropEvent = new DragAndDropEvent(this, 91960, dragStartInfo);
        return dragAndDropEvent;
    }

    public void adjustSize() {
        if (this.mainFolder == null) {
            return;
        }
        int n = this.mainFolder.getHeight() + this.mainFolder.getTotalHeight();
        int n2 = this.mainFolder.getTotalWidth();
        Dimension dimension = this.panel.getParent().getSize();
        ScrollPane scrollPane = (ScrollPane)this.panel.getParent();
        int n3 = scrollPane.getVScrollbarWidth();
        int n4 = scrollPane.getHScrollbarHeight();
        if (dimension.height - 4 > n) {
            n = dimension.height - 4;
            if (dimension.width - 4 < n2) {
                n -= n4;
            }
        }
        if (dimension.width - 4 > n2) {
            n2 = dimension.width - 4;
            if (dimension.height - 4 < n) {
                n2 -= n3;
            }
        }
        this.setSize(n2, n);
        this.panel.setSize(n2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean mouseDraggedOnCanvas(MouseEvent mouseEvent) {
        Graphics graphics;
        block6: {
            boolean bl;
            block7: {
                if (this.dragStartEvent != null) {
                    this.dispatchDragAndDropEvent(this.dragStartEvent);
                    this.dragStartEvent = null;
                }
                Point point = mouseEvent.getPoint();
                ListItem listItem = this.mainFolder.locateItemOnDrag(point.x, point.y);
                graphics = this.getGraphics();
                try {
                    String string;
                    if (listItem == null) {
                        this.eraseHiliteBox(graphics);
                        break block6;
                    }
                    ListItem listItem2 = null;
                    if (this.draggee == null) break block6;
                    listItem2 = this.draggee.getBaseItem();
                    if (listItem2 == null || listItem == null) {
                        boolean bl2 = true;
                        Object var7_8 = null;
                        graphics.dispose();
                        return bl2;
                    }
                    String string2 = listItem2.getTitle();
                    if (string2.equals(string = listItem.getTitle()) && listItem2.getParentListContainer() == listItem.getParentListContainer()) {
                        this.eraseHiliteBox(graphics);
                        bl = true;
                        break block7;
                    }
                    this.eraseHiliteBox(graphics);
                    this.paintHiliteBox(graphics, listItem);
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    graphics.dispose();
                    throw throwable;
                }
            }
            Object var7_9 = null;
            graphics.dispose();
            return bl;
        }
        Object var7_10 = null;
        graphics.dispose();
        return true;
    }

    public boolean mouseReleasedOnCanvas(MouseEvent mouseEvent) {
        this.dragStartEvent = null;
        this.draggee = null;
        this.setCursor(this.default_cursor);
        return false;
    }

    public void eraseHiliteBox(Graphics graphics) {
        if (this.hiliteRect == null) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.drawRect(this.hiliteRect.x, this.hiliteRect.y, this.hiliteRect.width - 1, this.hiliteRect.height - 1);
        this.hiliteRect = null;
    }

    public void paintHiliteBox(Graphics graphics, ListItem listItem) {
        this.hiliteRect = new Rectangle(listItem.getBoundingBox());
        this.hiliteRect.width = this.size().width;
        this.hiliteRect.x = 0;
        if (listItem instanceof ListElement) {
            this.hiliteRect.height = 1;
        }
        graphics.setColor(Color.black);
        graphics.drawRect(this.hiliteRect.x, this.hiliteRect.y, this.hiliteRect.width - 1, this.hiliteRect.height - 1);
    }

    public ListContainer getSelectedItemFolder() {
        ListContainer listContainer = null;
        this.dbg("selectedItem " + this.selectedItem);
        if (this.selectedItem == null) {
            return this.mainFolder;
        }
        if (this.selectedItem instanceof ListContainer) {
            listContainer = (ListContainer)this.selectedItem;
        }
        if (this.selectedItem instanceof ListElement) {
            listContainer = this.selectedItem.getParentListContainer();
        }
        if (listContainer == null) {
            return this.mainFolder;
        }
        return listContainer;
    }

    public ListItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setMainContainer(ListContainer listContainer) {
        this.mainFolder = listContainer;
    }

    public ListContainer getMainContainer() {
        return this.mainFolder;
    }

    public String getTitle() {
        return this.title;
    }

    public void setCurrentItem(ListItem listItem) {
        this.currentIcon = listItem;
    }

    public void setSelectedItem(ListItem listItem) {
        this.selectedItem = listItem;
    }

    public void paint(Graphics graphics) {
        if (this.mainFolder == null) {
            return;
        }
        this.mainFolder.drawItem(graphics);
        if (this.currentIcon != null) {
            this.currentIcon.drawItem(graphics);
        }
    }

    public boolean itemMoved() {
        return this.handleDrop;
    }

    private final class ListCanvasMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            ListCanvas.this.processCanvasMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ListCanvas.this.processCanvasMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ListCanvas.this.processCanvasMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        ListCanvasMouseListener() {
            ListCanvas.this = ListCanvas.this;
        }
    }

    protected class DnDListener
    implements DragAndDropListener {
        public void dragAndDropPerformed(DragAndDropEvent dragAndDropEvent) {
            ListCanvas.this.processDragAndDropEvent(dragAndDropEvent);
        }

        protected DnDListener() {
            ListCanvas.this = ListCanvas.this;
        }
    }
}

