/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.security.Certificate;
import java.security.Identity;
import sun.security.x509.X500Name;
import sunw.hotjava.applet.AppletSecurity;
import sunw.hotjava.applet.AppletSecurityContext;
import sunw.hotjava.security.AppletSecurityException;
import sunw.hotjava.security.BasePolicy;
import sunw.hotjava.security.PolicyNone;

public abstract class CommonSecurity
extends AppletSecurity {
    private static CommonSecurity beanDelegateSecurityManager = null;
    int networkMode;
    static final int NETWORK_NONE = 1;
    static final int NETWORK_HOST = 2;
    static final int NETWORK_UNRESTRICTED = 3;
    static final int PRIVELEGED_PORT = 1024;
    protected BasePolicy untrusted;
    protected BasePolicy high;
    protected BasePolicy medium;
    protected BasePolicy low;
    protected BasePolicy none;
    protected BasePolicy generic;
    protected static final int PERMISSIONS = 0;
    protected static final int SIGNED = 1;
    protected static final int UNSIGNED = 2;
    protected static final int UNSAFE = 3;
    private static final String subDirName = "security1.1";
    private static CommonSecurity csm = null;
    protected static int depthAdjustor;

    public CommonSecurity() {
        csm = this;
    }

    static CommonSecurity getCommonSecurity() {
        return csm;
    }

    protected abstract BasePolicy findPolicy(ClassLoader var1);

    public BasePolicy getUntrustedPolicy() {
        return this.untrusted;
    }

    public BasePolicy getHighTrustPolicy() {
        return this.high;
    }

    public BasePolicy getMediumTrustPolicy() {
        return this.medium;
    }

    public BasePolicy getLowTrustPolicy() {
        return this.low;
    }

    public BasePolicy getNoPolicy() {
        return this.none;
    }

    public BasePolicy getGenericPolicy() {
        return this.generic;
    }

    protected void setBeanDelegateSecurityManager(CommonSecurity commonSecurity) {
        beanDelegateSecurityManager = commonSecurity;
    }

    public static CommonSecurity getBeanDelegateSecurityManager() {
        return beanDelegateSecurityManager;
    }

    private static boolean isDir(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return true;
        }
        if (string.length() == 2 && string.endsWith(":")) {
            return new File(String.valueOf(string) + File.separator).isDirectory();
        }
        return false;
    }

    public static InputStream getInputStream(String string) throws Exception {
        String string2;
        File file;
        String string3 = System.getProperty("user.home");
        if (string3 == null) {
            throw new Exception("user.home property not set");
        }
        if (!CommonSecurity.isDir(string3)) {
            throw new Exception("Can't read user.home: " + string3);
        }
        if (string3 != null && !string3.endsWith(File.separator)) {
            string3 = String.valueOf(string3) + File.separator;
        }
        if (!(file = new File(string2 = String.valueOf(string3) + ".hotjava" + File.separator + subDirName + File.separator + string)).exists()) {
            return null;
        }
        if (!file.canRead() || !file.canWrite()) {
            throw new Exception("Can't read or write user.home: " + file);
        }
        FileInputStream fileInputStream = new FileInputStream(file.getPath());
        return new BufferedInputStream(fileInputStream);
    }

    public static OutputStream getOutputStream(String string) throws Exception {
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            throw new Exception("user.home property not set");
        }
        if (!CommonSecurity.isDir(string2)) {
            throw new Exception("Can't read user.home: " + string2);
        }
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        String string3 = String.valueOf(string2) + ".hotjava" + File.separator + subDirName;
        File file = new File(string3);
        file.mkdirs();
        String string4 = String.valueOf(string2) + File.separator + ".hotjava" + File.separator + subDirName + File.separator + string;
        File file2 = new File(string4);
        return new BufferedOutputStream(new FileOutputStream(file2.getPath()));
    }

    public synchronized void checkCreateClassLoader() {
        if (this.classLoaderDepth() == 2 + depthAdjustor) {
            throw new AppletSecurityException("checkcreateclassloader");
        }
    }

    public void checkAccess(Thread thread) {
        ClassLoader classLoader;
        BasePolicy basePolicy;
        if (this.classLoaderDepth() == 3 + depthAdjustor && !this.inThreadGroup(thread) && !(basePolicy = this.findPolicy(classLoader = this.currentClassLoader())).checkAccess(thread)) {
            throw new AppletSecurityException("checkaccess.thread");
        }
    }

    public void checkAccess(ThreadGroup threadGroup) {
        ClassLoader classLoader;
        BasePolicy basePolicy;
        if (this.classLoaderDepth() == 4 + depthAdjustor && !this.inThreadGroup(threadGroup) && !(basePolicy = this.findPolicy(classLoader = this.currentClassLoader())).checkAccess(threadGroup)) {
            throw new AppletSecurityException("checkaccess.threadgroup");
        }
    }

    public void checkExit(int n) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkExit(n)) {
            throw new AppletSecurityException("checkexit", String.valueOf(n));
        }
    }

    public void checkExec(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkExec(string)) {
            throw new AppletSecurityException("checkexec");
        }
    }

    public void checkLink(String string) {
        ClassLoader classLoader = this.currentClassLoader();
        switch (this.classLoaderDepth() - depthAdjustor) {
            case 2: 
            case 3: {
                BasePolicy basePolicy = this.findPolicy(classLoader);
                if (basePolicy.checkLink(string)) break;
                throw new AppletSecurityException("checklink", string);
            }
        }
    }

    public void checkPropertiesAccess() {
        BasePolicy basePolicy;
        ClassLoader classLoader = this.currentClassLoader();
        if (this.classLoaderDepth() == 2 + depthAdjustor && !(basePolicy = this.findPolicy(classLoader)).checkPropertiesAccess()) {
            throw new AppletSecurityException("checkpropsaccess");
        }
    }

    public void checkPropertyAccess(String string) {
        BasePolicy basePolicy;
        ClassLoader classLoader = this.currentClassLoader();
        if (!(this.classLoaderDepth() != 2 + depthAdjustor && this.classLoaderDepth() != 3 + depthAdjustor || (basePolicy = this.findPolicy(classLoader)).checkPropertyAccess(string))) {
            throw new AppletSecurityException("checkpropsaccess.key", string);
        }
    }

    public void checkRead(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (basePolicy instanceof PolicyNone) {
            return;
        }
        URL uRL = this.getAppletURL();
        if (!basePolicy.checkRead(string, uRL)) {
            throw new AppletSecurityException("checkread.exception", string);
        }
    }

    public void checkRead(String string, URL uRL) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkRead(string, uRL)) {
            throw new AppletSecurityException("checkread.exception", string);
        }
    }

    public void checkRead(String string, Object object) {
        this.checkRead(string);
        if (object != null) {
            this.checkRead(string, ((AppletSecurityContext)object).getCodeBase());
        }
    }

    public void checkRead(FileDescriptor fileDescriptor) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkRead(fileDescriptor)) {
            throw new AppletSecurityException("checkread.fd");
        }
    }

    public void checkWrite(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkWrite(string)) {
            throw new AppletSecurityException("checkwrite", string, string);
        }
    }

    public void checkWrite(FileDescriptor fileDescriptor) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkWrite(fileDescriptor)) {
            throw new AppletSecurityException("checkwrite.fd");
        }
    }

    public void checkDelete(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkDelete(string)) {
            throw new AppletSecurityException("checkdelete", string);
        }
    }

    public void checkListen(int n) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkListen(n)) {
            throw new AppletSecurityException("checklisten", String.valueOf(n));
        }
    }

    public void checkAccept(String string, int n) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkAccept(string, n)) {
            throw new AppletSecurityException("checkaccept", string, String.valueOf(n));
        }
    }

    public void checkMulticast(InetAddress inetAddress) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkMulticast(inetAddress)) {
            throw new AppletSecurityException("checkmulticast", inetAddress.toString());
        }
    }

    public void checkConnect(String string, int n) {
        int n2 = this.classDepth("sun.net.www.http.HttpClient");
        if (n2 > 1) {
            return;
        }
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkConnect(string, n)) {
            throw new AppletSecurityException("checkconnect.networknone", this.getAppletHost(), string);
        }
    }

    public boolean checkTopLevelWindow(Object object) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        return basePolicy.checkTopLevelWindow(object);
    }

    public void checkPackageAccess(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkPackageAccess(string)) {
            throw new AppletSecurityException("checkpackageaccess", string);
        }
    }

    public void checkPackageDefinition(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkPackageDefinition(string)) {
            throw new AppletSecurityException("checkpackagedefinition", string);
        }
    }

    public void checkSetFactory() {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkSetFactory()) {
            throw new AppletSecurityException("cannotsetfactory");
        }
    }

    public void checkMemberAccess(Class clazz, int n) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkMemberAccess(clazz, n, this.classLoaderDepth() - depthAdjustor)) {
            throw new AppletSecurityException("checkmemberaccess");
        }
    }

    public void checkPrintJobAccess() {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkPrintJobAccess()) {
            throw new AppletSecurityException("checkgetprintjob");
        }
    }

    public void checkSystemClipboardAccess() {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkSystemClipboardAccess()) {
            throw new AppletSecurityException("checksystemclipboardaccess");
        }
    }

    public void checkAwtEventQueueAccess() {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkAwtEventQueueAccess()) {
            throw new AppletSecurityException("checkawteventqueueaccess");
        }
    }

    public void checkSecurityAccess(String string) {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkSecurityAccess(string)) {
            throw new AppletSecurityException("checksecurityaccess", string);
        }
    }

    public void checkRun() {
        BasePolicy basePolicy = this.findPolicy(this.currentClassLoader());
        if (!basePolicy.checkRun()) {
            throw new AppletSecurityException("checkrun");
        }
    }

    public void checkFrameAccess() {
        ClassLoader classLoader = this.currentClassLoader();
        int n = this.classLoaderDepth();
        if (n > 3 + depthAdjustor || n < depthAdjustor) {
            return;
        }
        BasePolicy basePolicy = this.findPolicy(classLoader);
        if (!basePolicy.checkFrameAccess()) {
            throw new AppletSecurityException("checkframeaccess");
        }
    }

    public boolean checkFrameAccessOK() {
        this.currentClassLoader();
        int n = this.classLoaderDepth();
        return n > 2 + depthAdjustor || n < depthAdjustor;
    }

    protected BasePolicy getDefaultPermission(String string, String string2) {
        String string3 = System.getProperty(string, string2);
        if (string3.equalsIgnoreCase("Medium")) {
            return this.medium;
        }
        if (string3.equalsIgnoreCase("Low")) {
            return this.low;
        }
        if (string3.equalsIgnoreCase("Untrusted")) {
            return this.untrusted;
        }
        return this.high;
    }

    Class getCurrentClass() {
        return this.currentLoadedClass();
    }

    public String getSignerName() {
        Class clazz = this.currentLoadedClass();
        Object[] objectArray = clazz.getSigners();
        if (objectArray == null) {
            return null;
        }
        Identity identity = (Identity)objectArray[0];
        Certificate[] certificateArray = identity.certificates();
        X500Name x500Name = (X500Name)certificateArray[0].getPrincipal();
        try {
            return String.valueOf(x500Name.getOrganization()) + " " + x500Name.getCommonName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getSiteName() {
        URL uRL = this.getAppletURL();
        if (uRL == null) {
            return "local applet";
        }
        return uRL.getHost();
    }

    public String getClassName() {
        Class clazz = this.currentLoadedClass();
        return clazz.getName();
    }

    protected boolean inClassAbove() {
        Class<?>[] classArray = ((SecurityManager)((Object)this)).getClassContext();
        int n = 0;
        if (classArray[0].getName().equals("sunw.hotjava.applet.BrowserSecurityManager")) {
            n = 1;
        }
        int n2 = n + 1;
        while (n2 < classArray.length) {
            if (!classArray[n].isAssignableFrom(classArray[n2])) {
                int n3 = n2 + 1;
                while (n3 < classArray.length) {
                    if (classArray[n].isAssignableFrom(classArray[n3])) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void reset() {
        super.reset();
        String string = System.getProperty("appletviewer.security.mode");
        if (string == null) {
            string = "host";
        }
        if (string.equals("unrestricted")) {
            this.networkMode = 3;
            return;
        }
        if (string.equals("none")) {
            this.networkMode = 1;
            return;
        }
        this.networkMode = 2;
    }

    public URL getAppletURL() {
        Object object = this.getSecurityContext();
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object instanceof AppletSecurityContext) {
            return ((AppletSecurityContext)object).getCodeBase();
        }
        return null;
    }

    public String getAppletHost() {
        return this.getAppletHost(this.getAppletURL());
    }

    public String getAppletHost(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String string = uRL.getHost();
        String string2 = "applet." + uRL.getProtocol() + ".host.meaningful";
        if (!Boolean.getBoolean(string2)) {
            string = "";
        }
        return string;
    }

    boolean policyInClass(String string) {
        return this.inClass(string);
    }

    int policyClassDepth(String string) {
        return this.classDepth(string);
    }

    Class currentLoadedClassSec() {
        return this.currentLoadedClass();
    }

    void setInCheck(boolean bl) {
        ((SecurityManager)((Object)this)).inCheck = bl;
    }

    public ClassLoader policyGetLoader() {
        return this.currentClassLoader();
    }
}

