/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import sun.misc.CharacterEncoder;

public class VerbatimHeaderEncoder
extends CharacterEncoder {
    String header;

    public VerbatimHeaderEncoder(String string) {
        this.header = string;
    }

    protected void encodeBufferPrefix(OutputStream outputStream) throws IOException {
        super.encodeBufferPrefix(outputStream);
        this.pStream.print(String.valueOf(this.header) + ":");
    }

    protected void encodeLinePrefix(OutputStream outputStream, int n) throws IOException {
        this.pStream.print(" ");
    }

    protected int bytesPerAtom() {
        return 1;
    }

    protected int bytesPerLine() {
        return 75;
    }

    protected void encodeAtom(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        if (n2 != 1) {
            throw new IOException("VerbatimHeaderEncoder: bad chunk size");
        }
        outputStream.write(byArray[n]);
    }

    protected int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (n < byArray.length) {
            int n2 = inputStream.read();
            if (n2 == -1) {
                return n;
            }
            if (n2 == 13 || n2 == 10) {
                --n;
            } else {
                byArray[n] = (byte)n2;
            }
            ++n;
        }
        return byArray.length;
    }

    public static void main(String[] stringArray) {
        String string = "Usage: VerbatimHeaderEncoder <header> <content>";
        if (stringArray.length != 2) {
            System.out.println(string);
            System.exit(1);
        }
        VerbatimHeaderEncoder verbatimHeaderEncoder = new VerbatimHeaderEncoder(stringArray[0]);
        try {
            verbatimHeaderEncoder.encodeBuffer(stringArray[1].getBytes(), System.out);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error encoding header:");
            iOException.printStackTrace();
            return;
        }
    }
}

