/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.misc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.net.www.MimeEntry;
import sun.net.www.MimeTable;
import sunw.hotjava.misc.Compare;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.Sort;

public class ContentViewersManager
extends Observable
implements Compare {
    private static ContentViewersManager manager = null;
    private MimeTable viewers;
    private MimeEntry currentViewer;
    private Vector removedViewers = new Vector(10);

    public static void create() {
        ContentViewersManager.getManager();
    }

    public static ContentViewersManager getManager() {
        if (manager == null) {
            manager = new ContentViewersManager();
        }
        return manager;
    }

    private ContentViewersManager() {
        Object object;
        Object object2;
        Object object3;
        File file;
        int n;
        String string;
        Object object4;
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = hJBProperties.getProperty("admin.mimetype.handlers");
        if (string2 != null) {
            object4 = new StringTokenizer(string2, "|");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                string = ((StringTokenizer)object4).nextToken();
                n = string.indexOf(61);
                if (n <= 0) continue;
                hashtable.put(string.substring(0, n), string.substring(n + 1));
            }
        }
        if ((string2 = hJBProperties.getProperty("mimetype.handlers")) != null) {
            object4 = new StringTokenizer(string2, "|");
            while (((StringTokenizer)object4).hasMoreTokens()) {
                string = ((StringTokenizer)object4).nextToken();
                n = string.indexOf(61);
                if (n <= 0) continue;
                hashtable.put(string.substring(0, n), string.substring(n + 1));
            }
        }
        if ((object4 = System.getProperty("user.home")) != null && !((String)object4).endsWith(File.separator)) {
            object4 = String.valueOf(object4) + File.separator;
        }
        if ((file = new File(string = String.valueOf(object4) + ".hotjava" + File.separator + "content-types.properties")).exists()) {
            hJBProperties.put("content.types.user.table", string);
        }
        this.viewers = MimeTable.getDefaultTable();
        if ("JavaOS".equals(System.getProperty("os.name")) && file.exists()) {
            try {
                object3 = new Properties();
                object2 = new BufferedInputStream(new FileInputStream(file));
                object = this.viewers.elements();
                while (object.hasMoreElements()) {
                    this.viewers.remove((MimeEntry)object.nextElement());
                }
                ((Properties)object3).load((InputStream)object2);
                ((InputStream)object2).close();
                this.parse((Properties)object3);
            }
            catch (IOException iOException) {
                System.err.println("MimeTable.load: file = " + file.getPath() + ", " + iOException);
                iOException.printStackTrace();
            }
        }
        object3 = hashtable.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = (String)hashtable.get(object2);
            MimeEntry mimeEntry = this.viewers.find((String)object2);
            if (mimeEntry != null) {
                mimeEntry.setAction(1, (String)object);
                continue;
            }
            MimeEntry mimeEntry2 = new MimeEntry((String)object2);
            mimeEntry2.setAction(1, (String)object);
            this.viewers.add(mimeEntry2);
        }
        this.setCurrentViewer(this.viewers.find("text/plain"));
    }

    public MimeTable getMimeTable() {
        return this.viewers;
    }

    public MimeEntry getContentViewer(String string) {
        return this.viewers.find(string);
    }

    public MimeEntry getContentViewer(String string, String string2) {
        return this.getContentViewer(String.valueOf(string) + "/" + string2);
    }

    public Enumeration getViewersInfo() {
        return this.viewers.elements();
    }

    public MimeEntry getCurrentViewer() {
        return this.currentViewer;
    }

    public void setCurrentViewer(MimeEntry mimeEntry) {
        this.currentViewer = (MimeEntry)mimeEntry.clone();
        this.setChanged();
    }

    public void setCurrentViewerByType(String string) {
        try {
            MimeEntry mimeEntry = this.viewers.find(string);
            this.currentViewer = mimeEntry != null ? (MimeEntry)mimeEntry.clone() : new MimeEntry(string);
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("ContentViewersManager.setCurrentViewerByType: " + nullPointerException);
        }
        this.setChanged();
    }

    public void setCurrentViewerByDescription(String string) {
        try {
            MimeEntry mimeEntry = this.viewers.findByDescription(string);
            if (mimeEntry != null) {
                this.currentViewer = (MimeEntry)mimeEntry.clone();
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("ContentViewersManager.setCurrentViewerByDescription: " + nullPointerException);
        }
        this.setChanged();
    }

    public void setType(String string) {
        this.currentViewer.setType(string);
        this.setChanged();
    }

    public void setAction(int n) {
        this.currentViewer.setAction(n);
        this.setChanged();
    }

    public void setCommand(String string) {
        this.currentViewer.setCommand(string);
        this.setChanged();
    }

    public void setDescription(String string) {
        this.currentViewer.setDescription(string);
        this.setChanged();
    }

    public void setFileExtensions(String string) {
        this.currentViewer.setExtensions(string);
        this.setChanged();
    }

    public void setIconFilename(String string) {
        this.currentViewer.setImageFileName(string);
        this.setChanged();
    }

    public void remove(String string) {
        this.viewers.remove(string);
    }

    public void removeCurrentViewer() {
        String string = this.currentViewer.getType();
        MimeEntry mimeEntry = this.viewers.remove(string);
        this.removedViewers.addElement(mimeEntry);
        this.currentViewer = null;
        this.setChanged();
    }

    public void undoRemove() {
        Enumeration enumeration = this.removedViewers.elements();
        while (enumeration.hasMoreElements()) {
            MimeEntry mimeEntry = (MimeEntry)enumeration.nextElement();
            this.setCurrentViewer(mimeEntry);
            this.viewers.add(this.currentViewer);
        }
        this.setChanged();
        this.removedViewers.removeAllElements();
    }

    public void defineViewer(String string, int n, String string2, String string3, String string4, String string5) {
        MimeEntry mimeEntry = new MimeEntry(string);
        mimeEntry.setAction(n);
        if (string2 != null && string2.length() > 0) {
            mimeEntry.setCommand(string2);
        }
        if (string3 != null && string3.length() > 0) {
            mimeEntry.setExtensions(string3);
        }
        if (string4 != null && string4.length() > 0) {
            mimeEntry.setImageFileName(string4);
        }
        if (string5 != null && string5.length() > 0) {
            mimeEntry.setDescription(string5);
        }
        this.setCurrentViewer(mimeEntry);
        this.setChanged();
    }

    public void apply() {
        this.viewers.add(this.currentViewer);
        this.removedViewers.removeAllElements();
        this.setChanged();
    }

    public boolean save() {
        String string;
        String string2 = System.getProperty("user.home");
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if (this.viewers.save(string = String.valueOf(string2) + ".hotjava" + File.separator + "content-types.properties")) {
            HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
            hJBProperties.put("content.types.user.table", string);
            return true;
        }
        return false;
    }

    public int doCompare(Object object, Object object2) {
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        MimeEntry mimeEntry = (MimeEntry)object;
        MimeEntry mimeEntry2 = (MimeEntry)object2;
        return mimeEntry.getDescription().compareTo(mimeEntry2.getDescription());
    }

    public MimeEntry[] getSortedViewers() {
        Object[] objectArray = new MimeEntry[this.viewers.getSize()];
        Enumeration enumeration = this.getViewersInfo();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n] = (MimeEntry)enumeration.nextElement();
            ++n;
        }
        Sort.quicksort(objectArray, this);
        return objectArray;
    }

    void parse(Properties properties) {
        String string = (String)((Hashtable)properties).get("temp.file.template");
        if (string != null) {
            ((Hashtable)properties).remove("temp.file.template");
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            this.parse(string2, string3);
        }
    }

    void parse(String string, String string2) {
        MimeEntry mimeEntry = new MimeEntry(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.parse(string3, mimeEntry);
        }
        this.viewers.add(mimeEntry);
    }

    void parse(String string, MimeEntry mimeEntry) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        while (stringTokenizer.hasMoreTokens()) {
            if (bl) {
                string3 = stringTokenizer.nextToken().trim();
                continue;
            }
            string2 = stringTokenizer.nextToken().trim();
            bl = true;
        }
        this.fill(mimeEntry, string2, string3);
    }

    void fill(MimeEntry mimeEntry, String string, String string2) {
        if ("description".equalsIgnoreCase(string)) {
            mimeEntry.setDescription(string2);
            return;
        }
        if ("action".equalsIgnoreCase(string)) {
            mimeEntry.setAction(this.getActionCode(string2));
            return;
        }
        if ("application".equalsIgnoreCase(string)) {
            mimeEntry.setCommand(string2);
            return;
        }
        if ("icon".equalsIgnoreCase(string)) {
            mimeEntry.setImageFileName(string2);
            return;
        }
        if ("file_extensions".equalsIgnoreCase(string)) {
            mimeEntry.setExtensions(string2);
        }
    }

    int getActionCode(String string) {
        String[] stringArray = new String[]{"unknown", "browser", "save", "application"};
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }
}

