/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.text.CharacterIterator;

class TextCharIterator
implements CharacterIterator {
    char[] data;
    int startOffset;
    int offset;

    TextCharIterator(char[] cArray, int n) {
        this.data = cArray;
        this.offset = n;
        this.startOffset = n;
    }

    public Object clone() {
        return new TextCharIterator(this.data, this.offset);
    }

    public char current() {
        if (this.offset >= this.data.length) {
            return '\uffff';
        }
        return this.data[this.offset];
    }

    public int getBeginIndex() {
        return this.startOffset;
    }

    public int getEndIndex() {
        return this.data.length;
    }

    public int getIndex() {
        return this.offset;
    }

    public char first() {
        this.offset = this.startOffset;
        return this.data[this.offset];
    }

    public char last() {
        this.offset = this.data.length - 1;
        return this.data[this.offset];
    }

    public char next() {
        ++this.offset;
        if (this.offset >= this.data.length) {
            this.offset = this.data.length;
            return '\uffff';
        }
        return this.data[this.offset];
    }

    public char previous() {
        --this.offset;
        if (this.offset < this.startOffset) {
            this.offset = this.startOffset;
            return '\uffff';
        }
        return this.data[this.offset];
    }

    public char setIndex(int n) {
        this.offset = n;
        if (this.offset < this.startOffset) {
            this.offset = this.startOffset;
        } else if (this.offset >= this.data.length) {
            this.offset = this.data.length - 1;
        }
        return this.data[this.offset];
    }
}

