/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpSearchNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.TextHelpModel;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicSearchCellRenderer;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicSearchNavigatorUI
extends HelpNavigatorUI
implements SearchListener,
PropertyChangeListener,
TreeSelectionListener {
    protected JHelpSearchNavigator searchnav;
    protected JScrollPane sp;
    protected JTree tree;
    protected DefaultMutableTreeNode topNode;
    protected JTextField searchparams;
    protected boolean displayOptions;
    protected SearchEngine helpsearch;
    protected SearchQuery searchquery;
    protected DefaultMutableTreeNode lastTOCnode;
    ActionListener searchAction = new SearchActionListener();
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicSearchNavigatorUI;

    public BasicSearchNavigatorUI(JHelpSearchNavigator jHelpSearchNavigator) {
        this.setIcon(BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicSearchNavigatorUI != null ? class$javax$help$plaf$basic$BasicSearchNavigatorUI : (class$javax$help$plaf$basic$BasicSearchNavigatorUI = BasicSearchNavigatorUI.class$("javax.help.plaf.basic.BasicSearchNavigatorUI")), "images/search.gif"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private int compare(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        double d = searchTOCItem.getConfidence();
        int n = searchTOCItem.hitCount();
        SearchTOCItem searchTOCItem2 = (SearchTOCItem)defaultMutableTreeNode2.getUserObject();
        double d2 = searchTOCItem2.getConfidence();
        int n2 = searchTOCItem2.hitCount();
        if (d > d2) {
            return -1;
        }
        if (d < d2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSearchNavigatorUI((JHelpSearchNavigator)jComponent);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicSearchNavigatorUI: " + string);
        }
    }

    private DefaultMutableTreeNode findIDorURL(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD, URL uRL) {
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        if (searchTOCItem != null) {
            Map.ID iD2 = searchTOCItem.getID();
            if (iD2 != null && iD != null && iD2.equals(iD)) {
                return defaultMutableTreeNode;
            }
            URL uRL2 = searchTOCItem.getURL();
            if (uRL2 != null && uRL != null && uRL.sameFile(uRL2)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findIDorURL(defaultMutableTreeNode2, iD, uRL);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.sp != null) {
            return ((ScrollPaneLayout)this.sp.getLayout()).minimumLayoutSize(this.sp);
        }
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public void installUI(JComponent jComponent) {
        this.searchnav = (JHelpSearchNavigator)jComponent;
        HelpModel helpModel = this.searchnav.getModel();
        this.searchnav.setLayout(new BorderLayout());
        this.searchnav.addPropertyChangeListener(this);
        JLabel jLabel = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(jComponent), "search.findLabel"));
        this.searchparams = new JTextField("", 20);
        jLabel.setLabelFor(this.searchparams);
        this.searchparams.addActionListener(this.searchAction);
        Box box = Box.createHorizontalBox();
        box.add(jLabel);
        box.add(this.searchparams);
        this.searchnav.add("North", box);
        this.topNode = new DefaultMutableTreeNode();
        this.lastTOCnode = null;
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.searchnav.add("Center", this.sp);
        this.reloadData();
    }

    public synchronized void itemsFound(SearchEvent searchEvent) {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        Enumeration<TreeNode> enumeration = this.topNode.children();
        while (enumeration.hasMoreElements()) {
            object = (DefaultMutableTreeNode)enumeration.nextElement();
            vector.addElement(object);
        }
        BasicSearchNavigatorUI.debug("items found");
        object = this.searchnav.getModel();
        HelpSet helpSet = object.getHelpSet();
        Map map = helpSet.getCombinedMap();
        Enumeration enumeration2 = searchEvent.getSearchItems();
        while (enumeration2.hasMoreElements()) {
            SearchTOCItem searchTOCItem;
            URL uRL;
            SearchItem searchItem = (SearchItem)enumeration2.nextElement();
            BasicSearchNavigatorUI.debug("  item: " + searchItem);
            try {
                uRL = new URL(searchItem.getBase(), searchItem.getFilename());
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            Enumeration enumeration3 = vector.elements();
            while (enumeration3.hasMoreElements()) {
                defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration3.nextElement();
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
                URL uRL2 = searchTOCItem.getURL();
                if (uRL2 == null || uRL == null || !uRL.sameFile(uRL2)) continue;
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
                searchTOCItem.addSearchHit(new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd()));
                bl = true;
                break;
            }
            if (bl) continue;
            searchTOCItem = new SearchTOCItem(searchItem);
            defaultMutableTreeNode = new DefaultMutableTreeNode(searchTOCItem);
            vector.addElement(defaultMutableTreeNode);
        }
        this.reorder(vector);
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public void merge(NavigatorView navigatorView) {
        BasicSearchNavigatorUI.debug("merging " + navigatorView);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicSearchNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "propertyChange: " + propertyChangeEvent.getSource() + " " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.searchnav) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.reloadData();
            } else if (string.equals("font")) {
                BasicSearchNavigatorUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.tree.setFont(font);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void quickSort(DefaultMutableTreeNode[] var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = (var2_2 + var3_3) / 2;
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && this.compare(var1_1[var4_4], var1_1[var6_6]) > 0) continue block0;
                    while (var5_5 > var2_2 && this.compare(var1_1[var5_5], var1_1[var6_6]) < 0) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    this.swap(var1_1, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                this.quickSort(var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                this.quickSort(var1_1, var4_4, var3_3);
            }
        }
    }

    private void reloadData() {
        this.helpsearch = null;
        this.setCellRenderer(this.searchnav.getNavigatorView(), this.tree);
    }

    public void remove(NavigatorView navigatorView) {
        BasicSearchNavigatorUI.debug("removing " + navigatorView);
    }

    private void reorder(Vector vector) {
        BasicSearchNavigatorUI.debug("reorder nodes");
        this.topNode.removeAllChildren();
        Object[] objectArray = new DefaultMutableTreeNode[vector.size()];
        vector.copyInto(objectArray);
        this.quickSort((DefaultMutableTreeNode[])objectArray, 0, objectArray.length - 1);
        int n = 0;
        while (n < objectArray.length) {
            this.topNode.add((MutableTreeNode)objectArray[n]);
            ++n;
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    public synchronized void searchFinished(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("search Finished");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (this.lastTOCnode == null && this.topNode.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.topNode.getFirstChild();
            if (defaultMutableTreeNode != null) {
                treeSelectionModel.clearSelection();
                treeSelectionModel.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        } else {
            this.searchnav.getToolkit().beep();
        }
    }

    public synchronized void searchStarted(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("search Started");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.clearSelection();
        this.topNode.removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        if (navigatorView == null) {
            return;
        }
        Map map = navigatorView.getHelpSet().getCombinedMap();
        jTree.setCellRenderer(new BasicSearchCellRenderer(map));
    }

    private void swap(DefaultMutableTreeNode[] defaultMutableTreeNodeArray, int n, int n2) {
        DefaultMutableTreeNode defaultMutableTreeNode = defaultMutableTreeNodeArray[n];
        defaultMutableTreeNodeArray[n] = defaultMutableTreeNodeArray[n2];
        defaultMutableTreeNodeArray[n2] = defaultMutableTreeNode;
    }

    public void uninstallUI(JComponent jComponent) {
        HelpModel helpModel = this.searchnav.getModel();
        this.searchnav.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.searchnav.setLayout(null);
        this.searchnav.removeAll();
        this.searchnav = null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        BasicSearchNavigatorUI.debug("ValueChanged: " + treeSelectionEvent);
        BasicSearchNavigatorUI.debug("  model: " + this.searchnav.getModel());
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        BasicSearchNavigatorUI.debug("item:" + searchTOCItem.getURL());
        if (searchTOCItem != null) {
            HelpModel helpModel = this.searchnav.getModel();
            HelpSet helpSet = helpModel.getHelpSet();
            if (searchTOCItem.getID() != null) {
                try {
                    helpModel.setCurrentID(searchTOCItem.getID());
                }
                catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                    BasicSearchNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "BadID");
                    return;
                }
            } else if (searchTOCItem.getURL() != null) {
                helpModel.setCurrentURL(searchTOCItem.getURL());
            } else {
                return;
            }
            if (helpModel instanceof TextHelpModel) {
                TextHelpModel textHelpModel = (TextHelpModel)helpModel;
                TextHelpModel.Highlight[] highlightArray = new DefaultHelpModel.DefaultHighlight[searchTOCItem.hitCount()];
                int n = 0;
                Enumeration enumeration = searchTOCItem.getSearchHits();
                while (enumeration.hasMoreElements()) {
                    SearchHit searchHit = (SearchHit)enumeration.nextElement();
                    highlightArray[n] = new DefaultHelpModel.DefaultHighlight(searchHit.getBegin(), searchHit.getEnd());
                    ++n;
                }
                textHelpModel.setHighlights(highlightArray);
            }
        }
    }

    class SearchActionListener
    implements ActionListener {
        SearchActionListener() {
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
            HelpModel helpModel = BasicSearchNavigatorUI.this.searchnav.getModel();
            try {
                if (BasicSearchNavigatorUI.this.helpsearch == null) {
                    BasicSearchNavigatorUI.this.helpsearch = BasicSearchNavigatorUI.this.searchnav.getSearchEngine();
                    BasicSearchNavigatorUI.this.searchquery = BasicSearchNavigatorUI.this.helpsearch.createQuery();
                    BasicSearchNavigatorUI.this.searchquery.addSearchListener(BasicSearchNavigatorUI.this);
                }
                BasicSearchNavigatorUI.debug("click on search w/: " + BasicSearchNavigatorUI.this.searchparams.getText());
                if (BasicSearchNavigatorUI.this.searchquery.isActive()) {
                    BasicSearchNavigatorUI.this.searchquery.stop();
                }
                BasicSearchNavigatorUI.this.searchquery.start(BasicSearchNavigatorUI.this.searchparams.getText(), BasicSearchNavigatorUI.this.searchnav.getLocale());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

