/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import sudoku.ConfigGeneratorPanel;

public class GeneratorPatternPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private int borderWidth = 5;
    private static final int UNITS = 9;
    private boolean[] pattern = null;
    private int cellSize = -1;

    public GeneratorPatternPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(new Color(255, 255, 255));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                GeneratorPatternPanel.this.formMouseClicked(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void formMouseClicked(MouseEvent evt) {
        if (this.pattern == null || this.cellSize < 0 || evt.getButton() != 1 || evt.getX() < this.borderWidth || evt.getX() > this.borderWidth + 9 * this.cellSize || evt.getY() < this.borderWidth || evt.getY() > this.borderWidth + 9 * this.cellSize) {
            return;
        }
        int col = (evt.getX() - this.borderWidth) / this.cellSize;
        int row = (evt.getY() - this.borderWidth) / this.cellSize;
        int index = row * 9 + col;
        boolean bl = !this.pattern[index];
        this.pattern[index] = bl;
        this.updateAnzGivens();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int width = this.getWidth();
        int height = this.getHeight();
        width = width < height ? width : height;
        height = height < width ? height : width;
        int offsetX = Math.max(this.getInsets().left, this.getInsets().right);
        int offsetY = Math.max(this.getInsets().top, this.getInsets().bottom);
        int bWidth = Math.max(offsetX, offsetY);
        this.borderWidth = Math.max(5, bWidth);
        this.cellSize = (width - 2 * this.borderWidth) / 9;
        g2.setColor(Color.BLACK);
        if (this.pattern != null) {
            for (int i = 0; i < this.pattern.length; ++i) {
                if (!this.pattern[i]) continue;
                int row = i / 9;
                int col = i % 9;
                g2.fillRect(this.borderWidth + col * this.cellSize, this.borderWidth + row * this.cellSize, this.cellSize, this.cellSize);
            }
        }
        int max = 9 * this.cellSize;
        for (int i = 0; i <= 9; ++i) {
            g2.drawLine(this.borderWidth + 0, this.borderWidth + i * this.cellSize, this.borderWidth + max, this.borderWidth + i * this.cellSize);
            g2.drawLine(this.borderWidth + i * this.cellSize, this.borderWidth + 0, this.borderWidth + i * this.cellSize, this.borderWidth + max);
        }
    }

    private void updateAnzGivens() {
        Container generatorPanel = this.getParent().getParent();
        if (generatorPanel instanceof ConfigGeneratorPanel) {
            int anz = 0;
            if (this.pattern != null) {
                for (int i = 0; i < this.pattern.length; ++i) {
                    if (!this.pattern[i]) continue;
                    ++anz;
                }
            }
            ((ConfigGeneratorPanel)generatorPanel).setAnzGivens(anz);
        }
    }

    public boolean[] getPattern() {
        return this.pattern;
    }

    public void setPattern(boolean[] pattern) {
        this.pattern = pattern;
        this.repaint();
        this.updateAnzGivens();
    }
}

