/*
 * Decompiled with CFR 0.152.
 */
package generator;

import generator.SudokuGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SudokuGeneratorFactory {
    private static final SudokuGenerator defaultGenerator = new SudokuGenerator();
    private static List<generatorInstance> instances = new ArrayList<generatorInstance>();
    private static final Thread thread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Thread thread = thread;
                synchronized (thread) {
                    Iterator iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        generatorInstance act = (generatorInstance)iterator.next();
                        if (act.inUse || System.currentTimeMillis() - act.lastUsedAt <= 300000L) continue;
                        iterator.remove();
                    }
                }
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    });
    private static final long GENERATOR_TIMEOUT = 300000L;

    private SudokuGeneratorFactory() {
    }

    public static SudokuGenerator getDefaultGeneratorInstance() {
        return defaultGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SudokuGenerator getInstance() {
        SudokuGenerator ret = null;
        Thread thread = SudokuGeneratorFactory.thread;
        synchronized (thread) {
            for (generatorInstance act : instances) {
                if (act.inUse) continue;
                act.inUse = true;
                ret = act.instance;
                break;
            }
            if (ret == null) {
                ret = new SudokuGenerator();
                instances.add(new generatorInstance(ret));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void giveBack(SudokuGenerator generator) {
        Thread thread = SudokuGeneratorFactory.thread;
        synchronized (thread) {
            for (generatorInstance act : instances) {
                if (act.instance != generator) continue;
                act.inUse = false;
                act.lastUsedAt = System.currentTimeMillis();
                break;
            }
        }
    }

    static {
        thread.start();
    }

    private static class generatorInstance {
        SudokuGenerator instance = null;
        boolean inUse = true;
        long lastUsedAt = -1L;

        private generatorInstance(SudokuGenerator instance) {
            this.instance = instance;
        }
    }
}

