Unit chnlport;
{$S-,R-}
interface

uses OS2DEF, PmWin, PmGpi;

type
  CoordNum      = 1..17;

  GateShape     = object
    x0, y0 : real;
    l1, l2, l3, l4 : real;
    col: ULONG;
    c  : array[CoordNum] of POINTL;
    num: CoordNum;
    constructor init;
    procedure setup(initx0, inity0, initl1,
                     initl2, initl3, initl4:real;
                     colour:ULONG);
    procedure draw;
    procedure hide;
    procedure dragX(newX:real);
    destructor done;
  end;

  pGateShape     = ^GateShape;

(*
   (x0, y0);
   c01=c13-------------c02        -
   |                     |       l1
   c12----------c11      |        -
                  |      |       l2
   c09----------c10      |        -
   |                     |
   c08----------c07      |
                  |      |
   c05----------c06      |
   |                     |
   c04-----------------c03

   |        l3    |  l4  |*)

  mShape        = object(GateShape)
    procedure setup(initx0, inity0, initl1,
                     initl2, initl3, initl4:real;
                     colour:ULONG);
  end;

(*
   (x0, y0);
   c01=c17-------------c02        -
   |                     |       l1
   c16----------c15      |        -
                  |      |       l2
   c13----------c14      |        -
   |                     |
   c12----------c11      |
                  |      |
   c09----------c10      |        -
   |                     |
   c08----------c07      |
                  |      |
   c05----------c06      |
   |                     |
   c04-----------------c03

   |        l3    |  l4  |*)

  nShape        = object(GateShape)
    procedure setup(initx0, inity0, initl1,
                     initl2, initl3, initl4:real;
                     colour:ULONG);
  end;

  PortShape     = object
    posx, posy, GateSize, GateHeight:real;
    WallLen : integer;
    constructor init;
    procedure setup(initpx, initpy:integer;
                     initWallLen,
                     initGateSize, initGateHeight:integer);
    procedure draw;
    procedure hide;
    destructor done;
  end;

  NaPortShape   = object(PortShape)
    ms  : mShape;
    m, h: real;
    hHeight : real;
    hColour : integer;
    constructor init;
    procedure setup(initpx, initpy:integer;
                     initWallLen,
                     InitGateSize, InitGateHeight:integer;
                     initM, inith : real;
                     initMcolour, initHcolour:ULONG);
    procedure draw(newM, newH:real);
    procedure hide;
    destructor done;
  end;

  KPortShape    = object(PortShape)
    ns  : nShape;
    n   : real;
    constructor init;
    procedure setup(initpx, initpy:integer;
                     initWallLen,
                     initGateSize, initGateHeight:integer;
                     initN:real;
                     initColour:ULONG);
    procedure draw(newN:real);
    procedure hide;
    destructor done;
  end;

procedure SetHPS(hp : HPS);
procedure SetGraphParam(magx, magy, ofsx, ofsy : real);

implementation
var
  ahps : HPS;
  xMagn, yMagn, xOfs, yOfs : integer;

function WPx(x : real) : longint;
begin
  WPx := round(x * xMagn) + xOfs
end;

function WPy(y : real) : longint;
begin
  WPy := round(y * yMagn) + yOfs
end;

function PWx(x : longint) : real;
begin
  PWx := (x - xOfs) / xMagn
end;

function PWy(y : longint) : real;
begin
  PWy := (y - yOfs) / yMagn
end;


procedure DrawBarTheta(xx, yy, length, width:real;
                       theta:real;
                       col:ULONG);
var
  sinth, costh, x1, y1:real;
  xa1, xa2, ya1, ya2:integer;
  c : array[1..5] of POINTL;
  abnd : AREABUNDLE;
begin
  theta := theta * pi / 180;
  length:= length * xMagn;
  width := width  * yMagn;
  sinth := abs(sin(theta));
  costh := abs(cos(theta));
  xa1   := round(length * costh);
  ya1   := round(length * sinth);
  xa2   := round(width  * sinth);
  ya2   := round(width  * costh);
  c[1].x:= WPx(xx);
  c[1].y:= WPy(yy);
  c[2].x:= c[1].x + xa1;
  c[2].y:= c[1].y + ya1;
  c[3].x:= c[2].x - xa2;
  c[3].y:= c[2].y + ya2;
  c[4].x:= c[1].x - xa2;
  c[4].y:= c[1].y + ya2;
  c[5]  := c[1];
  abnd.lcolor := col;
  GpiSetAttrs(ahps, PRIM_AREA, ABB_COLOR, 0, abnd);
  GpiBeginArea(ahps, 0);
  GpiSetColor(ahps, col);
  GpiMove(ahps, c[1]);
  GpiPolyLine(ahps, 5, c[1]);
  GpiFloodFill(ahps, FF_BOUNDARY, col);
  GpiEndArea(ahps)
end;

constructor GateShape.init;
begin
end;

procedure GateShape.setup(initx0, inity0, initl1,
                           initl2, initl3, initl4:real;
                           colour:ULONG);
begin
  x0  := initx0;
  y0  := inity0;
  l1  := initl1;
  l2  := initl2;
  l3  := initl3;
  l4  := initl4;
  col := colour
end;

procedure GateShape.draw;
var abnd : AREABUNDLE;
begin
  abnd.lcolor := col;
  GpiSetAttrs(ahps, PRIM_AREA, ABB_COLOR, 0, abnd);
  GpiBeginArea(ahps, 0);
  GpiSetColor(ahps, col);
  GpiMove(ahps, c[1]);
  GpiPolyLine(ahps, num, c[1]);
  GpiFloodFill(ahps, FF_BOUNDARY, col);
  GpiEndArea(ahps)
end;

procedure GateShape.hide;
var abnd : AREABUNDLE;
begin
  abnd.lcolor := CLR_BLACK;
  GpiSetAttrs(ahps, PRIM_AREA, ABB_COLOR, 0, abnd);
  GpiBeginArea(ahps, 0);
  GpiSetColor(ahps, CLR_BLACK);
  GpiMove(ahps, c[1]);
  GpiPolyLine(ahps, num, c[1]);
  GpiFloodFill(ahps, FF_BOUNDARY, CLR_BLACK);
  GpiEndArea(ahps)
end;

procedure GateShape.dragX(newX:real);
var
  x1, i, ii, p1, p2:integer;
begin
  x1 := round(newX * xMagn + xOfs);
  if x1>c[1].x then
    for i:=1 to x1-c[1].x do begin
      GpiSetColor(ahps, CLR_BLACK);
      for ii:=2 to num div 2 do begin
        p1 := ii*2;
        GpiMove(ahps, c[p1]);
        p2 := succ(p1);
        Gpiline(ahps, c[p2])
      end;
      for ii:=1 to num do inc(c[ii].x);
      GpiSetColor(ahps, col);
      GpiMove(ahps, c[2]);
      GpiLine(ahps, c[3])
    end
  else
    for i:=1 to c[1].x-x1 do begin
      GpiSetColor(ahps, CLR_BLACK);
      GpiMove(ahps, c[2]);
      GpiLine(ahps, c[3]);
      for ii:=1 to num do dec(c[ii].x);
      GpiSetColor(ahps, col);
      for ii:=2 to num div 2 do begin
        p1:=ii*2;
        GpiMove(ahps, c[p1]);
        p2:=succ(p1);
        GpiLine(ahps, c[p2])
      end
    end
end;

destructor GateShape.done;
begin
  hide
end;

procedure mShape.setup(initx0, inity0,
                        initl1, initl2, initl3, initl4:real;
                        colour:ULONG);
begin
  GateShape.setup(initx0, inity0,
                  initl1, initl2, initl3, initl4, colour);
  c[ 1].x := WPx(x0);
  c[ 1].y := WPy(y0);
  c[ 2].x := WPx(x0+l3+l4);
  c[ 2].y := c[ 1].y;
  c[ 3].x := c[ 2].x;
  c[ 3].y := WPy(y0+l1*3+l2*2);
  c[ 4].x := c[ 1].x;
  c[ 4].y := c[ 3].y;
  c[ 5].x := c[ 4].x;
  c[ 5].y := WPy(y0+l1*2+l2*2);
  c[ 6].x := WPx(x0+l3);
  c[ 6].y := c[ 5].y;
  c[ 7].x := c[ 6].x;
  c[ 7].y := WPy(y0+l1*2+l2);
  c[ 8].x := c[ 4].x;
  c[ 8].y := c[ 7].y;
  c[ 9].x := c[ 8].x;
  c[ 9].y := WPy(y0+l1+l2);
  c[10].x := c[ 7].x;
  c[10].y := c[ 9].y;
  c[11].x := c[10].x;
  c[11].y := WPy(y0+l1);
  c[12].x := c[ 9].x;
  c[12].y := c[11].y;
  c[13]   := c[ 1];
  num:=13
end;

procedure nShape.setup(initx0, inity0, initl1,
                        initl2, initl3, initl4:real;
                        colour:ULONG);
begin
  GateShape.setup(initx0, inity0,
                  initl1, initl2,  initl3, initl4, colour);
  c[ 1].x := WPx(x0);
  c[ 1].y := WPy(y0);
  c[ 2].x := WPx(x0+l3+l4);
  c[ 2].y := c[ 1].y;
  c[ 3].x := c[ 2].x;
  c[ 3].y := WPy(y0+l1*4+l2*3);
  c[ 4].x := c[ 1].x;
  c[ 4].y := c[ 3].y;
  c[ 5].x := c[ 4].x;
  c[ 5].y := WPy(y0+l1*3+l2*3);
  c[ 6].x := WPx(x0+l3);
  c[ 6].y := c[ 5].y;
  c[ 7].x := c[ 6].x;
  c[ 7].y := WPy(y0+l1*3+l2*2);
  c[ 8].x := c[ 4].x;
  c[ 8].y := c[ 7].y;
  c[ 9].x := c[ 8].x;
  c[ 9].y := WPy(y0+l1*2+l2*2);
  c[10].x := c[ 7].x;
  c[10].y := c[ 9].y;
  c[11].x := c[10].x;
  c[11].y := WPy(y0+l1*2+l2);
  c[12].x := c[ 9].x;
  c[12].y := c[11].y;
  c[13].x := c[12].x;
  c[13].y := WPy(y0+l1  +l2);
  c[14].x := c[11].x;
  c[14].y := c[13].y;
  c[15].x := c[14].x;
  c[15].y := WPy(y0+l1);
  c[16].x := c[13].x;
  c[16].y := c[15].y;
  c[17]   := c[ 1];
  num:=17
end;

procedure DrawTunnel(x0, y0 : real; WallLen : integer;
                     width, height : real;
                     col : ULONG);
const
  WallWidth = 6;
type
  carray = array[1..3] of POINTL;
var
  c:carray;
  w:integer;

  procedure Dw;
  begin
    GpiMove(ahps, c[1]);
    GpiPolyLine(ahps, 3, c[1]);
    dec(c[1].y, WallWidth);
    inc(c[2].x, w);
    c[2].y := c[1].y;
    c[3].x := c[2].x;
    GpiMove(ahps, c[1]);
    GpiPolyLine(ahps, 3, c[1])
  end;

begin
  GpiSetColor(ahps, col);
  c[1].x := WPx(x0) - WallLen;
  c[1].y := succ(WPy(y0));
  c[2].x := c[1].x + pred(WallLen);
  c[2].y := c[1].y;
  c[3].x := c[2].x;
  c[3].y := c[2].y + round(height*yMagn);
  w      := -WallWidth;
  Dw;
  c[1].x := WPx(x0+width)+walllen;
  inc(c[1].y, WallWidth);
  c[2].x := c[1].x - succ(walllen);
  c[2].y := c[1].y;
  c[3].x := c[2].x;
  w      := WallWidth;
  Dw
end;

constructor PortShape.init;
begin
end;

procedure PortShape.setup(initpx, initpy:integer;
                           initWallLen,
                           initGateSize,
                           initGateHeight:integer);
begin
  posx := PWx(initpx);
  posy := PWy(initpy);
  WallLen  := initWallLen;
  GateSize := abs(initGateSize / xMagn);
  GateHeight := -InitGateHeight/ yMagn;
  DrawTunnel(posx, posy, WallLen, GateSize, GateHeight, CLR_YELLOW)
end;

procedure PortShape.draw;
begin
end;

procedure PortShape.hide;
begin
  DrawTunnel(posx, posy, WallLen, GateSize, abs(GateHeight),
             CLR_BLACK)
end;

destructor PortShape.done;
begin
end;

constructor NaPortShape.init;
begin
  ms.init
end;

procedure NaPortShape.setup(initpx, initpy:integer;
                             initWallLen,
                             initGateSize,
                             initGateHeight:integer;
                             initM, initH:real;
                             initMColour, initHColour:ULONG);
var
   ay1, ay2, ay3:real;
begin
  PortShape.setup(initpx, initpy,
                 initWallLen, initGateSize, initGateHeight);
  m := initM;
  h := initH * 90;
  HColour := InitHColour;
  ay1 := 0.3 * GateHeight;
  ay2 := 0.1 * GateHeight;
  ay3 := 0.15 * GateHeight;
{  ms.setup(posx, posy+ay1, ay2, ay3, GateSize, GateSize/5,
          initMColour);
  ms.draw;
  with ms do dragX(posx + m * GateSize);
}
  with ms do begin
    setup(posx, posy+ay1, ay2, ay3, GateSize, GateSize/5,
          initMColour);
    draw;
    dragX(posx + m * GateSize)
  end;
  hHeight:=ay2;
  DrawBarTheta(posx, posy, GateSize, hHeight, h, HColour)
end;

procedure NaPortShape.draw(newM, newH:real);
var
  oldh:real;
begin
  oldh:=h;
  m := newM;
  h := newH * 90;
  ms.dragX(posx + m * GateSize);
  (* Why ms.dragX(...) cause "no more CPU index regisers" ?*)
  DrawBarTheta(posx, posy, GateSize, Hheight, oldh, CLR_BLACK);
  DrawBarTheta(posx, posy, GateSize, Hheight, h, HColour)
end;

procedure NaPortShape.hide;
begin
  PortShape.hide;
  DrawBarTheta(posx, posy, GateSize, Hheight, h, CLR_BLACK);
  ms.hide
end;

destructor NaPortShape.done;
begin
  hide;
  ms.done
end;

constructor KPortShape.init;
begin
  ns.init
end;

procedure KPortShape.setup(initpx, initpy:integer;
                            initWallLen,
                            initGateSize,
                            initGateHeight:integer;
                            initN:real;
                            initColour:ULONG);
var
   ay1, ay2, ay3:real;
begin
  PortShape.setup(initpx, initpy,
                 initWallLen, initGateSize, initGateHeight);
  n := initN;
  ay1:=0.3 * GateHeight;
  ay2:=0.1 * GateHeight;
  ay3:=0.1 * GateHeight;
{  ns.setup(posx, posy+ay1, ay2, ay3, GateSize, GateSize/5,
          initColour);
  ns.draw;
  with ns do dragX(posx + n * Gatesize)
}
  with ns do begin
    setup(posx, posy+ay1, ay2, ay3, GateSize, GateSize/5,
          initColour);
    draw;
    dragX(posx + n * Gatesize)
  end
end;

procedure KPortShape.draw(newN:real);
begin
  n:=newN;
  ns.dragX(posx + n * GateSize)
  (* Why ns.dragX(...) cause "no more CPU index regisers" ?*)
end;

procedure KPortShape.hide;
begin
  PortShape.hide;
  ns.hide
end;

destructor KPortShape.done;
begin
  hide;
  ns.done
end;

procedure SetHPS(hp : HPS);
begin
  ahps := hp
end;

procedure SetGraphParam(magx, magy, ofsx, ofsy : real);
begin
  xMagn := magx;
  yMagn := magy;
  xOfs  := ofsx;
  yOfs  := ofsy
end;

begin
  xMagn := 1;
  yMagn := 1;
  xOfs  := 0;
  yOfs  := 0;
  ahps  := NULLHANDLE
end.
