{$G+}
var
  costable,sintable: array [0..1599] of longint;
  functable        : array [1..999] of longint;
  palette,FadePalette : Array [0..768] of Byte;
  l,k     : Byte;
  P,FP    : Pointer;
  fade    : Word;
  J       : Word;
  KP      : Boolean;

Function KeyPressed: Boolean; Assembler;
asm
   mov ah,1
   int 16h
   jnz @1
   mov al,0
   jmp @3
@1:
   mov al,1
@3:
end;

procedure setpalettecol(color,red,green,blue: byte); assembler;
asm
   mov  dx,3C8h
   mov  al,[color]
   out  dx,al
   inc  dx
   mov  al,[red]
   out  dx,al
   mov  al,[green]
   out  dx,al
   mov  al,[blue]
   out  dx,al
end;

procedure setpalette;
var k,l:integer;
begin
                Asm
                mov     dx,3DAh
@WaitVRT1:      in      al,dx
                test    al,8
                jz      @WaitVRT1
@WaitVRT2:      in      al,dx
                test    al,8
                jnz     @WaitVRT2
                End;

  for l:=0 to 14 do
    for k:=0 to 15 do
      begin
{      setpalettecol(16+k+16*l, 4*(k and 15),4*(l mod 15),63);}
      setpalettecol(16+k+16*l, FadePalette[(16+k+16*l)*3],FadePalette[(16+k+16*l)*3+1],FadePalette[(16+k+16*l)*3+2]);
      end;
end;
Procedure GenPalette; Assembler;
Asm
                les     di,P
                mov     cx,256
                xor     bx,bx
@GenPalette:    mov     ax,bx
                shr     ax,4
                and     ax,0Fh
                shl     ax,2
                mov     [di+0],al
                mov     ax,bx
                and     ax,0Fh
                shl     ax,1
                mov     [di+1],al
                mov     al,3Fh
                mov     [di+2],al
                add     di,3
                inc     bx
                dec     cx
                or      cx,cx
                jnz     @GenPalette
End;

Procedure RotPalette(Fade:Word);
BEGIN
Asm
                les     di,fp
                mov     cx,16*3
                xor     ax,ax
                cld
                rep     stosb
                les     si,p
                add     si,96
                mov     cx,224*3
                cld
                rep     movsb
                les     si,p
                add     si,48
                mov     cx,16*3
                rep     movsb

                les     bx,FP
                mov     cx,16
@RotLoop:       push    cx
                mov     si,bx
                mov     di,bx
                lodsb
                mov     ah,al
                lodsb
                mov     dl,al
                lodsb
                mov     dh,al
                mov     cx,15*3
                rep     movsb
                mov     al,ah
                stosb
                mov     al,dl
                stosb
                mov     al,dh
                stosb
                add     bx,16*3
                pop     cx
                dec     cx
                or      cx,cx
                jnz     @RotLoop

                les     si,FP
                les     di,P
                mov     cx,768
                rep     movsb

                les     si,FP
                mov     cx,768
                mov     dx,[Fade]
@FadeLoop:      mov     al,[si]
                mul     dl
                shr     ax,7
                mov     [si],al
                inc     si
                dec     cx
                or      cx,cx
                jnz     @FadeLoop
END;
    SetPalette;
End;
procedure putpixel(x,y:integer; color:byte);
begin Mem[$A000:x+320*y]:=color;
end;

procedure render;
var
  x,y,i,j,color:integer;
begin
  for i := 0 to 1599 do begin
    costable[i] := round(65536 * 320/1000*cos(2*Pi*i/1600));
    sintable[i] := round(65536 * 240/1000*sin(2*Pi*i/1600));
  end;

  for j := 1 to 999 do begin
    functable[j] := {round(65536 * 30*(-1.0+ln(2.0*j/1000)));}
      round(65536 * 200*(-0.6+0.6*sin(Pi*j/1000)));
  end;

  for j:=1 to 999 do begin
{    color := 16+16*(14-((abs(functable[j]) div (65536 div 2)) mod 15));}
      color := 16+16*((j div 5) mod 15);
    for i:=0 to 1599 do begin
      x := 160 + (j*costable[i]) div 65536;
      y := 50 + ((j*sintable[i]) - functable[j]) div 65536;
      if (x>=0) and (x<320) and (y>=0) and (y<200) then begin
        putpixel(x,y,color + ((i div 5) mod 16));
      end;
    end;
  end;
end;


begin
  For j := 1 to 768 do Palette[j] := 0;
  P := Ptr(Seg(Palette),Ofs(Palette));
  FP:= Ptr(Seg(FadePalette),Ofs(FadePalette));
  asm
   mov  ax,13h
   int  10h
  end;
  setpalette;
  GenPalette;
  render;
  fade := 0;
  KP := False;
  repeat
  RotPalette(fade);
  If Not KP then If Fade < 129 then inc(fade);
  If KeyPressed then KP := True;
  If KP then If Fade > 0 then dec(fade);
  until Fade = 0;
  asm
   xor  ah,ah
   int  16h
   mov  ax,03h
   int  10h
  end;

end.
