Var
   I     : Byte;
   Total : Byte;

Function WhatDrive(Drive: Byte): String;
{ 㭪 頥  ⨯ ᪠   ஬ Drive,
  祬 0 -   ⥪騩  , 1 - A:,  2 - B:,
  3 - C:   ..    26 - Z:.  ᫨  饭
  ᫮ None,  ⮣        .
  楤   ᠭ     ࣥ  
  筮 졥 ⮢     ᫥饣
  ਬ  ணࠬ Horizont Turbo Commander
}
Const
     Drvs : Array [0..6] of String[8] = (
     'Floppy','H.D.D.','None','CD-ROM','RAM Disk','Share','Subst');
Var
   D : Byte;
Begin
     Asm
        mov     ah,19h          { Get default drive}
        int     21h
        push    ax
        mov     bl,Drive        { Drive is removable?}
        mov     ax,4408h
        int     21h
        jc      @none_drive     { Error - check for CD-ROM}
        cmp     ax,0
        je      @floppy         { This is a floppy}
        mov     d,1
        mov     ax,4409h        { Get IOCTL info}
        int     21h
        push    dx
        xchg    dl,dh
        mov     cl,7
        shr     dl,cl
        or      dl,dl           { SUBST drive?}
        jz      @notsub
        pop     dx
        mov     d,6
        jmp     @done
@notsub:
        pop     dx
        test    dh,00000010b    { Share drive?}
        jz      @notshar
        mov     d,5
        jmp     @done
@notshar:
        mov     ax,1600h
        int     2fh
        cmp     al,0
        je      @not_win
        cmp     al,80h
        je      @not_win
        mov     ax,4411h
        mov     ch,8
        mov     cl,42h
        int     21h
        cmp     ax,5            { Support formating?}
        jne     @done
        mov     d,4             { RAM drive.}
        jmp     @done
@not_win:
        test    dl,00000010b    { RAM drive?}
        jnz     @done
        mov     d,4
        jmp     @done
@none_drive:
        mov     d,2
        mov     cl,bl
        push    cx
        mov     ax,1500h
        xor     bx,bx
        int     2fh
        pop     cx
        or      bx,bx           { MSCDEX driver found?}
        jz      @done
        mov     ax,150bh
        dec     cl
        int     2fh
        or      ax,ax
        jz      @done           { drive supported by MSCDEX?}
        mov     d,3
        jmp     @done
@floppy:
        mov     d,0
@done:
        pop     dx              {Set default drive}
        mov     ah,0eh
        int     21h
     End;
     WhatDrive := Drvs[d];
End;

{==== ਬ ᯮ짮 楤 WhatDrive ====}
BEGIN
     Asm
     mov ax,3
     int 10h
     End;
     WriteLn('------> disks:');
     Total := 0;
     For I := 1 to 26 do If WhatDrive(I) <> 'None' then
     begin
          WriteLn(Chr(I+65-1)+': ',WhatDrive(I));
          Inc(Total);
     end;
     WriteLn(#13#10'Total avaible drives: ',Total);
END.