UNIT CPUDet;
Interface
Uses ASK,Labels, DOS;
Function  ItoS(a:longint):string;
Procedure SystemInfo;
Procedure DiskInfo;
IMPLEMENTATION
Var
   CPUType      : Word;
   PCModel      : Byte;
   PCSubModel   : Byte;
   EQList       : Word;
   S            : String[20];

Function  ItoS(a:longint):string;
 var s : string[40];
begin
 Str(a,s);
 ItoS:=s;
end;

function _Processors: Word; far; external;
{$L CPUType}

Function GetMMXInfo: Boolean; Assembler;
     Asm
        Db $66; mov ax,1; Db 0;                 {mov eax,1}
        Db $0F, $A2                             {cpuid}
        Nop
        Nop
        Nop
        Db $66, $F7, $C2, 0,0,0,0,$8,0,0,0
        Jne @MMX_Present
        Xor al,al
        jmp @Done_MMX
@MMX_Present:
        mov al,1
@Done_MMX:
     End;
Function GetCPUType: String;
Const
  ProcType : Array [0..13] of String[13] = (
   '8086','8088','NEC V20','NEC V30','80186','80188','80286','80386',
   '80386SX','80386DX','80486','80486SX','Pentium(tm)','Sixtium???');

Var
   I    : Word;
   S    : String;
Begin
 I := _Processors and $FF7F;
 S := '';
 CPUtype := I and $7F ;
 If I and $7F >= 6 then
 begin
 asm
    db 0Fh,1,0E0h { SMSW AX }
    test al,1
    jz  @@1
    or I.byte ,80h
 @@1:
 end;
  end;

 If I and $7F in [0..13] then S := ProcType[I and $7F] else
    S := 'Unknown';

 If I and $7F in [12..13] then If GetMMXInfo then S := S+' MMX';
 if I and $80 <> 0 then S := S + ', V86 mode';

 GetCPUType   := S;
End;

Function GetFPUType: String;
Const
     FPUType : Array [0..6] of String[13] = (
     'None','8087','80287','80287XL',
     '80387','80387SX','80387DX');

Var
   I : Word;
   S : String;
Begin
 I := _Processors and $FF7F;
 S := '';
 If i shr 8 in [0..6] then S := FpuType[i shr 8] else
    S := 'Unknown';
 If (I and $F >= 10) and (I and $F <>11) then S := 'Built-In';
 GetFPUType := S;
End;

Function _MHz   : Word; far; external;
{$L _MHZ.OBJ}

Function GetSpeed: String;
 var
     A: Real;
     S: String;
begin
 A := _MHz;
 A := A/96.72; {96.72;}
 Str((A):6:2, S);
 GetSpeed := S;
end;

Function GetMType: String;

type PModel = ^TModel;
     TModel = record
      Len: Word;
      Model: Byte;
      SubModel: Byte;
      BIOSRevision: Byte;
     end;

var Model, SubModel: Byte;
     P: PModel;
     S: String;
begin
 asm
  mov ah, $C0
  int 15h
  mov word ptr P, bx
  mov word ptr P+2, es
 end;
 Model := P^.Model;
 if P^.Model = 0 then Model := mem[$F000:$FFFE];
 SubModel := P^.SubModel;
 PCModel    := P^.Model ;
 PCSubModel := P^.SubModel ;

 case Model of
  $FF: S := 'Original IBM PC';
  $FE: S := 'IBM XT or Portable PC';
  $FD: S := 'PC junior';
  $FC: case SubModel of
       { 1: S := 'IBM AT 3x9';}
        2: S := 'IBM XT 286';
        4: S := 'IBM Personal System/2 Model 50';
        5: S := 'IBM Personal System/2 Model 60';
        6: S := 'IBM 7552-XXX "Gearbox"';
        8: S := 'IBM Personal System/2 Model 25';
      $0b: S := 'IBM Personal System/1';
      $20: S := 'Compaq ProLinea';
      $42: S := 'Olivetti M280';
      $45: S := 'Olivetti M380';
      $48: S := 'Olivetti M290';
      $4F: S := 'Olivetti M250';
      $50: S := 'Olivetti M380';
      $51: S := 'Olivetti PCS286';
      $52: S := 'Olivetti M300';
      $94: S := 'Zenith 386';
        else S := 'IBM AT or compatible';
       end;
  $FB,$86: S := 'IBM XT';
  $80: S := 'IBM PC';
  $FA: if SubModel = 1 then S := 'IBM Personal System/2 Model 25'
                       else S := 'IBM Personal System/2 Model 30';
  $F9: S := 'PC Convertible';
  $F8: if SubModel in [4,9,$B]
                            then S := 'IBM Personal System/2 Model 70'
                            else S := 'IBM Personal System/2 Model 80+';
  $B6: S := 'Hewlett Packard 110';
  $9A: S := 'Compaq Plus';
  $2D: S := 'Compaq PC';
  $E1: S := 'PS/2 Model 55-5530 Laptop';
  $30: S := 'Sperry PC';
  else S := 'Unknown machine type.';
 end;
GetMType := S;
end;

Function GetBusType:String;
 var  S : String  ;
      Ft1,Ft2,Ft3 : byte ;
      OK : boolean ;
      PCMCIA : boolean ;
      EISA   : boolean ;
      SCSI   : boolean ;
      APM    : boolean ;
   begin
        S := 'ISA/XT' ;
        GetBusType := S ;
        if CPUtype < 6 then Exit  ;
        if CPUtype = 6 then
             begin
               if PCModel > $FC then Exit ;
               if PCModel = $FC then if
                  PCSubModel < 3 then Exit ; { Exclude XT 286 machine }
             end;
        S := 'ISA/AT' ;
     asm
        mov OK,0
        mov AH,0C0h
        int 15h
        jc  @@1
        cmp ah,0
        jne @@1
        cmp ES:[BX].word,5
        jb  @@1
        mov AL, ES:[BX+5].byte
        mov FT1.byte ,AL
        mov AL, ES:[BX+7].byte
        Mov FT3,AL
        mov OK,1
  @@1:
        mov PCMCIA,0
        mov ah,80h
        mov cx,5353h
        int 1Ah
        jc  @@11
        cmp cx,5353h
        jne @@2
        mov PCMCIA,1
        jmp @@2
  @@11: cmp ah,15h
        jae  @@2
        mov PCMCIA,1

  @@2:
        mov EISA,0
        mov ax,0D804h
        mov cl,0
        int 15h
        jc  @@4
        cmp ah,0
        je  @@3
        cmp ah,80h
        jb  @@4
        cmp ah,8Fh
        ja  @@4
        cmp ah,86h
        je  @@4
  @@3:  mov EISA,1

  @@4:
        mov  APM,0
        mov  ax,5300h
        sub  bx,bx
        int  15h
        jnc  @@6
        cmp  ah,86h
        je   @@7
  @@6:  mov  APM,1
  @@7:
      end;
         SCSI  := False ;
        if Ok then begin
         if Ft1 and 2 > 0 then S := 'Micro Channel';
         if Ft1 and 1 > 0 then S := 'MCA and ISA';
            SCSI := (Ft3 and $8> 0) ;
        end;
         if EISA then S := 'EISA';
         if PCMCIA then S:= S + ', PCMCIA';
         if SCSI then S := S + ', onboard SCSI';
         if APM  then S := S + ', APM';
         GetBusType := S ;
  end;

Function GetHDDInfo(N: Byte): String;
 var NumFD: Byte;
     NumHD, NumCyl, NumSect, NumHeads: Byte;
     NumCylinders: Word;
     S           : String;
     Error       : Boolean;
begin
 asm
  mov Error,0
  mov ah, 08h
  mov dl, N
  int 13h
  jc @error
  mov NumHD, dl
  mov NumHeads, dh
  mov NumCyl, ch
  mov NumSect, cl
  jmp @done
@error:
  mov Error,1
@done:
 end;
 If Not Error then begin
 NumCylinders := 1+(NumCyl + (NumSect shr 6)*256);
 S := FStr((LongInt(NumCylinders)*(LongInt((NumSect) and $3F))
     *LongInt(1+NumHeads)) div 2048);
 S := S + 'M, ' + ItoS(NumHeads+1)+' heads, '+
      ItoS(NumCylinders)+' cylinders, '+ItoS(NumSect and $3F)+' sectors.';
 End else S := 'None';
 GetHDDInfo := S;
end;

Function GetDisks: String;
 var NumFD: Byte;
     NumHD, NumCyl, NumSect, NumHeads: Byte;
     FDD : String;
     S: String;
     NumCylinders: Word;
     I: Byte;
begin
 NumFD := (mem[$40:$10] and 1)*(1+mem[$40:$10] shr 6);
 FDD := '';
 if NumFD = 0 then FDD := 'Not Present' else
 for I := 1 to NumFD do
  begin
   asm
    mov ah, 08h
    mov dl, I
    dec dl
    int 13h
    mov NumHD, bl
   end;
   case NumHD of
    1: S := '5.25" 360K';
    2: S := '5.25" 1.2M';
    3: S := '3.5" 720K';
    4: S := '3.5" 1.44M';
    6: S := '3.5" 2.88M';
    else S := 'Unknown disk driver type';
   end;
   if FDD <> '' then FDD := FDD + ', ';
   FDD := FDD + S;
  end;
  GetDiskS := FDD;
end;

Function GetComInfo: String;
Var
   S : String;
Begin
     S := '';
     if EQList and $0E00 <> 0 then S := S + ItoS((EQList and $0E00) shr 9) else S := S + 'Not Present';
     GetCOMInfo := S;
End;

Function GetLtpInfo: String;
Var
   S : String;
Begin
     S := '';
     if EQList and $C000 <> 0 then S := S + ItoS((EQList and $C000) shr 14) else S := S + 'Not Present';
     GetLtpInfo := S;
End;


Function GetConvMemory: String;
Var
   S : String;
   Size: Word;
Begin
 asm
  int 12h
  mov Size, ax
 end;
 S :=  ItoS(Size) + 'K';
 GetConvMemory := S;
End;

Function GetXMSMemory: String;
Var
   S    : String;
   XMSSize: Word;
Begin
 XMSSize := 0;
 if Test8086 > 0 then
  begin
   asm
    mov al, $18
    mov dx, $70
    out dx, al
    inc dx
    in  al, dx
    mov ah, al
    dec dx
    mov al, $17
    out dx, al
    inc dx
    in  al, dx
    mov XMSSize, ax
   end;
  end;
 S := ItoS(XMSSize) + 'K';
 GetXMSMemory := S;
End;

Function GetDOSVersion: String;
Var
   S    : String;
  _BH,
  _AL,
  _AH   : Byte;
Begin
     Asm
     mov ah,30h
     int 21h
     mov _al,al
     mov _ah,ah
     mov _bh,bh
     End;
     S := ItoS(_AL)+'.'+ItoS(_AH);
     if (_al = 7) and (_bh = 255) then S:=S+' (MS Windows 95)'
     else
     if _al >= 20 then S:=S+' (OS/2 Warp)'
     else
     if _bh = 0 then S:=S+' (IBM''s PC-DOS)'
     else
     S:=S+' (MS-DOS)';
     GetDOSVersion := S;
End;

Function GetEMSMemory: String;
Var
   S : String;
   EmsSize: Word;
Begin
     EMSSize := 0;
     S := '';
asm
 xor ax, ax
 mov byte ptr @Res, al
 jmp @@1
@EMSName:
 db  'EMMXXXX0',0
@Res: db 0
@@1:
 push ds
 push cs
 pop  ds
 lea  dx, @EMSName
 xor  al, al
 mov  ah, 3dH
 int  21H
 pop  ds
 jc   @Exit
 mov  bx, ax
 push bx
 mov  ax, 4407H
 int  21H
 pop  bx
 push ax
 mov  ah, 3eh
 int  21h
 pop  ax
 or   al, al
 jz   @Exit
 mov  ax, 3567h
 int  21h
 mov  ax, es
 or   ax, bx
 jz   @Exit
 mov  ax, 4000h
 int  67h
 or   ah, ah
 jnz  @Exit
 mov  al, 1
 mov  byte ptr @Res, al
@Exit:
 xor ah, ah
 mov al, byte ptr @Res
     cmp al,0
     jz @drug
     mov ah, 42h
     int 67h
     {$IFOPT G+}
     shl dx,4
     {$ELSE}
     mov cl, 4
     shl dx, cl
     {$ENDIF}
     mov EMSSize, dx
@drug:
    end;
 if EMSSize <> 0 then S := ItoS(EMSSize) + 'K' else S := 'None';
 GetEMSMemory := S;

End;

Function GetVESAInfo: String;
Var
Buff     : Array [0..256] of Byte;
P        : Pointer;
Present  : Boolean;
S        : String;
SS       : String;
Begin
     P := @Buff;
     Asm
     les di,p
     mov ax,4f00h
     int 10h
     cmp ax,004fh
     je @pres
     mov Present,0
     jmp @done
@pres:
     mov Present,1
@done:
     End;
     If Present then begin
     Str(Buff[5],S);
     Str(Buff[4],SS);
     S := S+'.'+SS;
     end else S:= 'None';
     GetVESAInfo := S;
End;

Function GetVidType: String;
Var
   S : String;
   B : Byte;
Begin
     S := 'Unknown';
     Asm
     mov ax,1A00h
     int 10h
     mov b,bl
     End;
  case b of
    $00 : s:='(none)';
    $01 : s:='MDA + 5151';
    $02 : s:='CGA + 5153/5154';
    $03 : s:='(reserved)';
    $04 : s:='EGA + 5153/5154';
    $05 : s:='EGA 5151';
    $06 : s:='PGA + 5175';
    $07 : s:='VGA + analog monochrome';
    $08 : s:='VGA + analog color';
    $09 : s:='(reserved)';
    $0A : s:='MCGA + digital color';
    $0B : s:='MCGA + digital monochrome';
    $0C : s:='MCGA + analog color';
    $0D..$FE : s:='(reserved)';
  end;
  If GetVesaInfo <> 'None' then S := 'SVGA (VESA v'+GetVesaInfo+')';
  GetVidType := S;
End;

Procedure SystemInfo;
Begin
     SavePage(2);
     SetWin(msgpal[1],msgpal[2],' System Info ',2,6,22,74);
     SetBox(3,8,8,72,msgpal[1]);
     WriteString(3,10,' Main board ',msgpal[5]);
     WriteString(4,10,'Machine type   : '+GetMType,msgpal[3]);
     WriteString(5,10,'Main processor : '+GetCPUType+' '+GetSpeed+' MHz',msgpal[3]);
     WriteString(6,10,'CoProcessor    : '+GetFPUType,msgpal[3]);
     WriteString(7,10,'Video Adapter  : '+GetVidType,msgpal[3]);
     SetBox(9,8,13,72,msgpal[1]);
     WriteString(9,10,' Disks ',msgpal[5]);
     WriteString(10,10,'Primary        : '+GetHDDInfo($80),msgpal[3]);
     WriteString(11,10,'Secondary      : '+GetHDDInfo($81),msgpal[3]);
     WriteString(12,10,'Floppy disk(s) : '+GetDisks,msgpal[3]);
     SetBox(14,8,19,31,msgpal[1]);
     WriteString(14,10,' Memory ',msgpal[5]);
     WriteString(15,10,'DOS memory : '+GetConvMemory,msgpal[3]);
     WriteString(16,10,'XMS memory : '+GetXMSMemory,msgpal[3]);
     WriteString(17,10,'EMS memory : '+GetEMSMemory,msgpal[3]);
     Str(MemAvail div 1024,S);
     WriteString(18,10,'Free       : '+S+'K',msgpal[3]);
     SetBox(14,32,19,72,msgpal[1]);
     WriteString(14,34,' Other info ',msgpal[5]);
     WriteString(15,34,'Bus type    : '+GetBusType,msgpal[3]);
     WriteString(16,34,'COM port(s) : '+GetComInfo,msgpal[3]);
     WriteString(17,34,'LPT port(s) : '+GetLtpInfo,msgpal[3]);
     WriteString(18,34,'DOS version : '+GetDosVersion,msgpal[3]);
     CntButton(21,' Done ');
     RestorePage(2);
End;

Function WhatDrive: String;
{ 㭪 頥  ⨯ ᪠   ஬ Drive,
  祬 0 -   ⥪騩  , 1 - A:,  2 - B:,
  3 - C:   ..    26 - Z:.  ᫨  饭
  ᫮ None,  ⮣        .
  楤   ᠭ     ࣥ  
  筮 졥 ⮢     ᫥饣
  ਬ  ணࠬ Horizont Turbo Commander
}
Const
     Drvs : Array [0..6] of String[25] = (
     'Floppy disk','Hard Disk Drive','Unknown','CD-ROM','RAM Disk','Share drive','Subst drive');
Var
   D  : Byte;
   Drv: Byte;
Begin
     Asm
        mov     d,255
        mov     ah,19h          { Get default drive}
        int     21h
        push    ax
        inc     al
        mov     bl,al           { Drive is removable?}
        mov     ax,4408h
        int     21h
        jc      @none_drive     { Error - check for CD-ROM}
        cmp     ax,0
        je      @floppy         { This is a floppy}
        mov     d,1
        mov     ax,4409h        { Get IOCTL info}
        int     21h
        push    dx
        xchg    dl,dh
        {$IFOPT G+}
        shr     dl,7
        {$ELSE}
        mov     cl,7
        shr     dl,cl
        {$ENDIF}
        or      dl,dl           { SUBST drive?}
        jz      @notsub
        pop     dx
        mov     d,6
        jmp     @done
@notsub:
        pop     dx
        test    dh,00000010b    { Share drive?}
        jz      @notshar
        mov     d,5
        jmp     @done
@notshar:
        mov     ax,1600h
        int     2fh
        cmp     al,0
        je      @not_win_or_os2
        cmp     al,80h
        je      @not_win_or_os2
        mov     ax,3306h
        int     21h
        cmp     bl,20
        jne     @not_win_or_os2 { 20.x means 32bit OS/2 }
        mov     ax,4411h
        mov     ch,8
        mov     cl,42h
        int     21h
        cmp     ax,5            { Support formatting?}
        jne     @done
        mov     d,4             { RAM drive.}
        jmp     @none_drive{done}
@not_win_or_os2:
        test    dl,00000010b    { RAM drive?}
        jnz     @done
        mov     d,4
{        jmp     @done}
@none_drive:
{        mov     d,2}
        mov     cl,bl
        xor     ch,ch
        push    cx
        mov     ax,1500h
        xor     bx,bx
        int     2fh
        pop     cx
        or      bx,bx           { MSCDEX driver found?}
        jz      @done
        mov     ax,150Bh
        dec     cl
        int     2fh
        or      ax,ax
        jz      @kane           { drive supported by MSCDEX?}
        mov     d,3
        jmp     @done
@kane:  mov     al,255
        cmp     d,al
        jne     @done
        mov     d,2             { Unknown ???}
@floppy:
        mov     d,0
@done:
        pop     dx              {Set default drive}
        mov     ah,0eh
        int     21h
     End;
     WhatDrive := Drvs[d];
End;

Function GetDefaultDrive: String;
Var
   S : String;
   _AL: Char;
Begin
     asm
     mov ah,19h
     int 21h
     add al,65
     mov _AL,al
     end;
     S := _AL;
     GetDefaultDrive:=S;
End;

Procedure DiskInfo;
Begin
     SavePage(2);
     SetWin(msgpal[1],msgpal[2],' Disk Info ',4,6,14,74);
     SetBox(5,8,11,72,msgpal[1]);
     WriteString(5,10,' Main info ',msgpal[5]);
     WriteString(6,10,'Current disk is  : '+GetDefaultDrive+':',msgpal[3]);
     S := GetDefaultDrive;
     WriteString(7,10,'Volume Label     : '+GetLabel(s[1]),msgpal[3]);
     WriteString(8,10,'Disk Type        : '+WhatDrive,msgpal[3]);
     if WhatDrive<>'CD-ROM' then begin
     WriteString(9,10,'Total Size       : '+FStr(DiskSize(0))+' bytes',msgpal[3]);
     WriteString(10,10,'Free             : '+FStr(DiskFree(0))+' bytes',msgpal[3]);
     end;
     CntButton(13,' Done ');
     RestorePage(2);
End;

BEGIN
     asm
       int 11h
       mov EQList, ax
     end;
END.