{
HALDOS provides REXX with access to OS/2's Dos... functions.
}

Library haldos;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

Uses
  Dos, Os2Def, Rexx, Strings, Os2Base;

{$LINKER
  DESCRIPTION      "HALDOS - Access to OS/2's Dos... functions for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    HALDOSBEEP          = HALDosBeep
    HALDOSENTERCRITSEC  = HALDosEnterCritSec
    HALDOSEXITCRITSEC   = HALDosExitCritSec
    HALDOSSUSPENDTHREAD = HALDosSuspendThread
    HALDOSRESUMETHREAD  = HALDosResumeThread
    HALDOSEXECPGM       = HALDosExecPgm
    HALDOSSELECTSESSION = HALDosSelectSession
    HALDOSCASEMAP       = HALDosCaseMap
    HALDOSLOADFUNCS     = HALDosLoadFuncs
}

Const FunctionTable : Array[ 0..7 ] of pChar =
(
  'HALDosBeep',
  'HALDosEnterCritSec',
  'HALDosExitCritSec',
  'HALDosSuspendThread',
  'HALDosResumeThread',
  'HALDosExecPgm',
  'HALDosSelectSession',
  'HALDosCaseMap'
);

Function HALDosLoadFuncs( FuncName  : PChar;
                         ArgC      : ULong;
                         Args      : pRxString;
                         QueueName : pChar;
                         Var Ret   : RxString ) : ULong; export;
Var
  j       : Integer;

begin
  Ret.strLength := 0;
  If ArgC > 0 then                        { Do not allow parameters }
    HALDosLoadFuncs := 40
  else
    begin
      For j := Low( FunctionTable ) to High( FunctionTable ) do
        RexxRegisterFunctionDLL( FunctionTable[j],
                                 'HALDOS',
                                 FunctionTable[j] );
      HALDosLoadFuncs := 0;
    end;

end;

Function Str2Int( s : String) : Integer;
var
  int,i : Integer;
begin
  int:=0;
  for i := 1 to length(s) do
    int:=int*10+ord(s[i])-ord('0');
  Str2Int:=int;
end;

Function HALDosBeep( FuncName  : PChar;
                    ArgC      : ULong;
                    Args      : pRxString;
                    QueueName : pChar;
                            Var Ret   : RxString ) : ULong; export;
var
  Freq : Integer;
  Dur : Integer;
begin
  If ArgC < 2 then
    begin
      HALDosBeep := 40;
      Exit;
    end;
  Freq := Str2Int(StrPas( Args^.strptr ));
  Inc(Args);
  Dur:=Str2Int(StrPas( Args^.strptr ));
  DosBeep(Freq,Dur);
  Ret.strLength := 0;
  HALDosBeep := 0;
end;

Function HALDosEnterCritSec( FuncName  : PChar;
                            ArgC      : ULong;
                            Args      : pRxString;
                            QueueName : pChar;
                            Var Ret   : RxString ) : ULong; export;
begin
  If ArgC > 0 then
    begin
      HALDosEnterCritSec := 40;
      Exit;
    end;
  DosEnterCritSec;
  Ret.strLength := 0;
  HALDosEnterCritSec := 0;
end;

Function HALDosExitCritSec( FuncName  : PChar;
                           ArgC      : ULong;
                           Args      : pRxString;
                           QueueName : pChar;
                           Var Ret   : RxString ) : ULong; export;
begin
  If ArgC > 0 then
    begin
      HALDosExitCritSec := 40;
      Exit;
    end;
  DosExitCritSec;
  Ret.strLength := 0;
  HALDosExitCritSec := 0;
end;

Function HALDosSuspendThread( FuncName  : PChar;
                             ArgC      : ULong;
                             Args      : pRxString;
                             QueueName : pChar;
                             Var Ret   : RxString ) : ULong; export;
var
  TID : Integer;
begin
  If ArgC < 1 then
    begin
      HALDosSuspendThread := 40;
      Exit;
    end;
  TID := Str2Int(StrPas( Args^.strptr ));
  DosSuspendThread(TID);
  Ret.strLength := 0;
  HALDosSuspendThread := 0;
end;

Function HALDosResumeThread( FuncName  : PChar;
                            ArgC      : ULong;
                            Args      : pRxString;
                            QueueName : pChar;
                            Var Ret   : RxString ) : ULong; export;
var
  TID : Integer;
begin
  If ArgC < 1 then
    begin
      HALDosResumeThread := 40;
      Exit;
    end;
  TID := Str2Int(StrPas( Args^.strptr ));
  DosResumeThread(TID);
  Ret.strLength := 0;
  HALDosResumeThread := 0;
end;

FUNCTION HALDOSEXECPGM(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    OBJNAME:ARRAY[1..32] OF CHAR;
    EXECTYPE:ULONG;
    RSLT:RESULTCODES;
    PGM:PCHAR;
    RETN:ULONG;
    TMP:STRING;
    ARGPTRS:ARRAY[1..255] OF CHAR;
    ARGPTR:INTEGER;
    I,J:INTEGER;
BEGIN
    EXECTYPE:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    PGM:=ARGS^.STRPTR;
    ARGPTR:=1;
    FOR I:=1 TO ARGC-1 DO BEGIN
        FOR J:=0 TO ARGS^.STRLENGTH-1 DO BEGIN ARGPTRS[ARGPTR]:=ARGS^.STRPTR[J]; INC(ARGPTR) END;
        ARGPTRS[ARGPTR]:=#0; INC(ARGPTR);
        INC(ARGS);
    END;
    ARGPTRS[ARGPTR]:=#0; INC(ARGPTR);
    RETN:=DOSEXECPGM(@OBJNAME,32,EXECTYPE,@ARGPTRS[1],NIL,RSLT,PGM);
    RESULT:=0;
    STR(RETN,TMP);
    STRPCOPY(RET.STRPTR,TMP);
    RET.STRLENGTH:=STRLEN(RET.STRPTR);
END;

FUNCTION HALDOSSELECTSESSION(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    SESS:USHORT;
    RETN:ULONG;
    TMP:STRING;
BEGIN
    SESS:=STR2INT(STRPAS(ARGS^.STRPTR));
    RETN:=DOSSELECTSESSION(SESS);
    RESULT:=0;
    STR(RETN,TMP);
    STRPCOPY(RET.STRPTR,TMP);
    RET.STRLENGTH:=STRLEN(RET.STRPTR);
END;

FUNCTION HALDOSCASEMAP(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    COUNTRY:COUNTRYCODE;
    RETN:ULONG;
    TMP:STRING;
BEGIN
    COUNTRY.COUNTRY:=0; COUNTRY.CODEPAGE:=0; {Use default country & codepage}
    DOSMAPCASE(ARGS^.STRLENGTH,COUNTRY,ARGS^.STRPTR);
    RESULT:=0;
    STRPCOPY(RET.STRPTR,STRPAS(ARGS^.STRPTR));
    RET.STRLENGTH:=ARGS^.STRLENGTH;
END;

initialization
end.

