{HALBIT fills a hole in REXX's built-in functions: bitwise operators.}

LIBRARY HALBIT;

{$CDecl+,OrgName+,I-,S-,Delphi+,Use32+}

USES DOS,OS2DEF,REXX,STRINGS,OS2BASE;

{$LINKER
  DESCRIPTION      "HALBIT - Bitwise operators for REXX"
  DATA MULTIPLE NONSHARED

  EXPORTS
    HALBITAND=HALBITAND
    HALBITOR=HALBITOR
    HALBITXOR=HALBITXOR
    HALBITLOADFUNCS=HALBITLOADFUNCS
}

CONST FUNCTIONTABLE : ARRAY[ 0..2 ] OF PCHAR =
(
    'HALBITAND',
    'HALBITOR',
    'HALBITXOR'
);

FUNCTION HALBITLOADFUNCS(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    I:INTEGER;
BEGIN
    RET.STRLENGTH:=0;
    IF ARGC>0 THEN RESULT:=40
    ELSE BEGIN
        FOR I:=LOW(FUNCTIONTABLE) TO HIGH(FUNCTIONTABLE) DO
            REXXREGISTERFUNCTIONDLL(FUNCTIONTABLE[I],'HALBIT',FUNCTIONTABLE[I]);
        RESULT:=0;
    END;
END;

FUNCTION STR2INT(S:STRING):INTEGER;
VAR
    INT,I:INTEGER;
BEGIN
    INT:=0;
    FOR I:=1 TO LENGTH(S) DO INT:=INT*10+ORD(S[I])-ORD('0');
    RESULT:=INT;
END;

PROCEDURE INT2RXSTR(VAR RX:RXSTRING;NUM:INTEGER);
VAR
    S:STRING;
BEGIN
    STR(NUM,S);
    RX.STRLENGTH:=LENGTH(S);
    STRPCOPY(RX.STRPTR,S);
END;

FUNCTION HALBITAND(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    NUM1,NUM2,OUTPUT:INTEGER;
BEGIN
    NUM1:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    NUM2:=STR2INT(STRPAS(ARGS^.STRPTR));
    OUTPUT:=NUM1 AND NUM2;
    INT2RXSTR(RET,OUTPUT);
    RESULT:=0;
END;

FUNCTION HALBITOR(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    NUM1,NUM2,OUTPUT:INTEGER;
BEGIN
    NUM1:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    NUM2:=STR2INT(STRPAS(ARGS^.STRPTR));
    OUTPUT:=NUM1 OR NUM2;
    INT2RXSTR(RET,OUTPUT);
    RESULT:=0;
END;

FUNCTION HALBITXOR(FUNCNAME:PCHAR;ARGC:ULONG;ARGS:PRXSTRING;QUEUENAME:PCHAR;VAR RET:RXSTRING):ULONG;EXPORT;
VAR
    NUM1,NUM2,OUTPUT:INTEGER;
BEGIN
    NUM1:=STR2INT(STRPAS(ARGS^.STRPTR));
    INC(ARGS);
    NUM2:=STR2INT(STRPAS(ARGS^.STRPTR));
    OUTPUT:=NUM1 XOR NUM2;
    INT2RXSTR(RET,OUTPUT);
    RESULT:=0;
END;

INITIALIZATION
END.

