/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.misc;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GlassPanel
extends JComponent {
    protected Container targetContainer = null;
    protected Component mouseEventTarget = null;

    public GlassPanel(Container c) {
        this.targetContainer = c;
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setMinimumSize(new Dimension(50, 50));
        this.setOpaque(false);
        this.setVisible(true);
    }

    public void processMouseEvent(MouseEvent e) {
        this.forwardMouseEvent(e);
    }

    public void processMouseMotionEvent(MouseEvent e) {
        this.forwardMouseEvent(e);
    }

    public void setTargetContainer(Container c) {
        this.targetContainer = c;
    }

    public Container getTargetContainer() {
        return this.targetContainer;
    }

    public Component getMouseEventTarget() {
        return this.mouseEventTarget;
    }

    private void forwardMouseEvent(MouseEvent e) {
        MouseEvent containerEvent = SwingUtilities.convertMouseEvent(this, e, this.targetContainer);
        this.mouseEventTarget = SwingUtilities.getDeepestComponentAt(this.targetContainer, containerEvent.getX(), containerEvent.getY());
        if (this.mouseEventTarget == null) {
            e.consume();
            return;
        }
        MouseEvent targetEvent = SwingUtilities.convertMouseEvent(this.targetContainer, containerEvent, this.mouseEventTarget);
        this.retargetMouseEvent(targetEvent);
    }

    protected void retargetMouseEvent(MouseEvent e) {
        MouseEvent retargeted = new MouseEvent(this.mouseEventTarget, e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
        this.mouseEventTarget.dispatchEvent(retargeted);
    }
}

