/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf.basic;

import com.hbworks.dirpane.CellEditorTextField;
import com.hbworks.dirpane.DefaultFileView;
import com.hbworks.dirpane.FileNode;
import com.hbworks.dirpane.FocusDispatcher;
import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.TreeDirectoryPaneCellEditor;
import com.hbworks.dirpane.TreeFileSystemModel;
import com.hbworks.dirpane.event.LoadingEvent;
import com.hbworks.dirpane.event.LoadingListener;
import com.hbworks.dirpane.event.TreeEventDelayer;
import com.hbworks.dirpane.event.TreeLoadingEvent;
import com.hbworks.dirpane.plaf.DirectoryPaneUI;
import com.hbworks.dirpane.plaf.TreeDirectoryPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicTreeDirectoryPaneUI
extends TreeDirectoryPaneUI
implements PropertyChangeListener {
    private static final String CustomTree_uiClassID = "PaneTreeUI";
    private JScrollPane scroller = null;
    private TreeCellRenderer renderer = null;
    private TreeCellEditor editor = null;
    private OverlayLayout overlayLayout = null;
    private JComponent glass = null;
    private TreeFileSystemModel filesystemModel = null;
    private MouseListener treeMouseListener = null;
    private FocusListener treeFocusListener = null;
    private LoadingListener treeLoadingListener = null;
    private PropertyChangeListener isActivePaneListener = null;
    private FocusDispatcher focusDispatcher = null;
    private TreeEventDelayer eventDelayer = null;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTreeDirectoryPaneUI();
    }

    public void installUI(JComponent c) {
        this.directoryPane = (TreeDirectoryPane)c;
        this.paneFont = this.directoryPane.getFont() == null ? DirectoryPaneUI.makeFontSmaller(UIManager.getFont("Tree.font")) : this.directoryPane.getFont();
        this.isGrayoutEnabled = this.directoryPane.isGrayoutEnabled();
        DefaultFileView defaultFileView = this.directoryPane.getDefaultFileView();
        super.installUI(c);
        this.installModels();
        this.installDefaultIcons(defaultFileView);
        this.configureTree();
        this.installKeyboardActions(c);
        this.installComponents();
        this.installListeners();
    }

    public void uninstallUI(JComponent c) {
        if (c != this.directoryPane) {
            throw new IllegalComponentStateException(this + " was asked to uninstall() " + c + " when it only knows about " + this.directoryPane + ".");
        }
        this.uninstallListeners();
        this.uninstallModels();
        this.uninstallKeyboardActions(c);
        this.uninstallComponents();
        super.uninstallUI(c);
    }

    protected void installModels() {
        this.filesystemModel = (TreeFileSystemModel)this.directoryPane.getModel();
    }

    protected void installDefaultIcons(DefaultFileView fileView) {
        Icon customFileIcon = this.directoryPane.getCustomFileIcon();
        if (customFileIcon != null) {
            fileView.setDefaultFileIcon(customFileIcon);
        } else {
            fileView.setDefaultFileIcon(this.getFileIcon());
        }
        Icon customDirectoryIcon = this.directoryPane.getCustomDirectoryIcon();
        if (customDirectoryIcon != null) {
            fileView.setDefaultDirectoryIcon(customDirectoryIcon);
        } else {
            fileView.setDefaultDirectoryIcon(this.getDirectoryIcon());
        }
        Icon customOpenDirectoryIcon = this.directoryPane.getCustomOpenDirectoryIcon();
        if (customOpenDirectoryIcon != null) {
            fileView.setDefaultOpenDirectoryIcon(customOpenDirectoryIcon);
        } else {
            fileView.setDefaultOpenDirectoryIcon(this.getOpenDirectoryIcon());
        }
        Icon customFloppyDriveIcon = this.directoryPane.getCustomFloppyDriveIcon();
        if (customFloppyDriveIcon != null) {
            fileView.setDefaultFloppyDriveIcon(customFloppyDriveIcon);
        } else {
            fileView.setDefaultFloppyDriveIcon(this.getFloppyDriveIcon());
        }
        Icon customHardDriveIcon = this.directoryPane.getCustomHardDriveIcon();
        if (customHardDriveIcon != null) {
            fileView.setDefaultHardDriveIcon(customHardDriveIcon);
        } else {
            fileView.setDefaultHardDriveIcon(this.getHardDriveIcon());
        }
        Icon customComputerIcon = this.directoryPane.getCustomComputerIcon();
        if (customComputerIcon != null) {
            fileView.setDefaultComputerIcon(customComputerIcon);
        } else {
            fileView.setDefaultComputerIcon(this.getComputerIcon());
        }
    }

    protected void configureTree() {
        this.tree = this.createUITree();
        this.tree.setBackground(this.getPaneBackground());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setScrollsOnExpand(true);
        this.tree.setLargeModel(this.directoryPane.isLargeModel());
        this.tree.setEditable(this.directoryPane.isEditable());
        this.tree.setRootVisible(this.directoryPane.isRootVisible());
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(this.directoryPane.getRowHeight());
        this.tree.getSelectionModel().setSelectionMode(this.directoryPane.getSelectionMode());
        this.tree.registerKeyboardAction(this.directoryPane.getGoUpAction(), KeyStroke.getKeyStroke(8, 0), 0);
        this.renderer = this.directoryPane.getCustomRenderer();
        if (this.renderer != null) {
            this.tree.setCellRenderer(this.renderer);
        } else {
            this.renderer = this.createTreeCellRenderer();
            this.tree.setCellRenderer(this.renderer);
        }
        this.editor = this.createTreeCellEditor();
        this.tree.setCellEditor(this.editor);
    }

    protected void installKeyboardActions(JComponent c) {
        c.registerKeyboardAction(this.directoryPane.getNewFolderAction(), KeyStroke.getKeyStroke(155, 0), 1);
        c.registerKeyboardAction(this.directoryPane.getGoHomeAction(), KeyStroke.getKeyStroke(36, 0), 1);
        c.registerKeyboardAction(this.directoryPane.getDoubleClickAction(), KeyStroke.getKeyStroke(10, 0), 1);
    }

    protected void installComponents() {
        this.scroller = new JScrollPane(this.tree);
        this.scroller.setBackground(this.directoryPane.getBackground());
        if (!this.directoryPane.isGrayoutEnabled()) {
            this.directoryPane.setLayout(new BorderLayout());
            this.directoryPane.add((Component)this.scroller, "Center");
        } else {
            this.overlayLayout = new OverlayLayout(this.directoryPane);
            this.directoryPane.setLayout(this.overlayLayout);
            this.glass = this.createGlassPaneFor(this.scroller);
            if (this.directoryPane.isActivePane()) {
                this.glass.setVisible(false);
            } else {
                this.glass.setVisible(true);
            }
            this.directoryPane.add(this.glass);
            this.directoryPane.add(this.scroller);
        }
    }

    protected void installListeners() {
        Vector selectionListeners;
        Vector willExpandListeners;
        this.directoryPane.addPropertyChangeListener(this);
        if (this.directoryPane.isGrayoutEnabled()) {
            this.isActivePaneListener = this.createIsActivePaneListener();
            this.directoryPane.addPropertyChangeListener(this.isActivePaneListener);
        }
        this.focusDispatcher = new FocusDispatcher(this.directoryPane, this.tree);
        this.directoryPane.addPropertyChangeListener(this.focusDispatcher);
        this.treeMouseListener = this.createUITreeMouseListener();
        this.tree.addMouseListener(this.treeMouseListener);
        this.treeFocusListener = this.createUITreeFocusListener();
        this.tree.addFocusListener(this.treeFocusListener);
        this.treeLoadingListener = this.createLoadingListener();
        this.filesystemModel.addLoadingListener(this.treeLoadingListener);
        Vector expansionListeners = this.directoryPane.getTreeExpansionListeners();
        if (expansionListeners != null) {
            int i = 0;
            while (i < expansionListeners.size()) {
                this.tree.addTreeExpansionListener((TreeExpansionListener)expansionListeners.elementAt(i));
                ++i;
            }
        }
        if ((willExpandListeners = this.directoryPane.getTreeWillExpandListeners()) != null) {
            int i = 0;
            while (i < willExpandListeners.size()) {
                this.tree.addTreeWillExpandListener((TreeWillExpandListener)willExpandListeners.elementAt(i));
                ++i;
            }
        }
        if ((selectionListeners = this.directoryPane.getTreeSelectionListeners()) != null) {
            int i = 0;
            while (i < selectionListeners.size()) {
                this.tree.addTreeSelectionListener((TreeSelectionListener)selectionListeners.elementAt(i));
                ++i;
            }
        }
    }

    protected void uninstallModels() {
        this.filesystemModel = null;
    }

    protected void uninstallKeyboardActions(JComponent c) {
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(155, 0));
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(36, 0));
        c.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
    }

    protected void uninstallListeners() {
        if (this.isActivePaneListener != null) {
            this.directoryPane.removePropertyChangeListener(this.isActivePaneListener);
            this.isActivePaneListener = null;
        }
        this.directoryPane.removePropertyChangeListener(this);
        this.directoryPane.removePropertyChangeListener(this.focusDispatcher);
        this.focusDispatcher = null;
        this.tree.removeMouseListener(this.treeMouseListener);
        this.treeMouseListener = null;
        this.tree.removeFocusListener(this.treeFocusListener);
        this.treeFocusListener = null;
        this.filesystemModel.removeLoadingListener(this.treeLoadingListener);
        this.treeLoadingListener = null;
    }

    protected void uninstallComponents() {
        if (this.glass != null) {
            this.directoryPane.remove(this.glass);
        }
        this.directoryPane.removeAll();
        this.directoryPane.setLayout(null);
        this.directoryPane = null;
        this.overlayLayout = null;
        this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        this.tree = null;
        this.scroller = null;
        this.glass = null;
        this.renderer = null;
        this.editor = null;
        this.paneFont = null;
        if (this.eventDelayer != null) {
            this.eventDelayer.kill();
            this.eventDelayer = null;
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object newvalue = e.getNewValue();
        String name = e.getPropertyName();
        if (name == "selectionForegroundChangedProperty") {
            Color sfg = (Color)newvalue;
            if (sfg == null) {
                this.setPaneSelectionForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setPaneSelectionForeground(sfg);
            }
            this.tree.repaint();
        } else if (name == "selectionBackgroundChanged") {
            Color sbg = (Color)newvalue;
            if (sbg == null) {
                this.setPaneSelectionBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                this.setPaneSelectionBackground(sbg);
            }
            this.tree.repaint();
        } else if (name == "foregroundChanged") {
            Color fg = (Color)newvalue;
            if (fg == null) {
                this.setPaneForeground(UIManager.getColor("Tree.foreground"));
            } else {
                this.setPaneForeground(fg);
            }
            this.tree.repaint();
        } else if (name == "backgroundChanged") {
            Color bg = (Color)newvalue;
            if (bg == null) {
                this.setPaneBackground(UIManager.getColor("Tree.background"));
                this.setPaneActiveBackground(UIManager.getColor("Tree.background"));
            } else {
                this.setPaneBackground(bg);
                this.setPaneActiveBackground(bg);
            }
            this.scroller.setBackground(this.getPaneBackground());
            this.tree.setBackground(this.getPaneBackground());
        } else if (name == "fontChanged") {
            Font f = (Font)newvalue;
            if (f == null) {
                this.setPaneFont(DirectoryPaneUI.makeFontSmaller(UIManager.getFont("Tree.font")));
            } else {
                this.setPaneFont(f);
            }
        } else if (name == "rowHeightChanged") {
            int h = (Integer)newvalue;
            this.tree.setRowHeight(h);
        } else if (name == "largeModelChanged") {
            boolean b = (Boolean)newvalue;
            this.tree.setLargeModel(b);
        } else if (name == "rootVisibleChanged") {
            boolean b = (Boolean)newvalue;
            this.tree.setRootVisible(b);
        } else if (name == "queueAWTEventsChanged") {
            boolean b = (Boolean)newvalue;
            if (!b && this.eventDelayer != null) {
                this.eventDelayer.kill();
                this.eventDelayer = null;
            }
        } else if (name == "selectionModeChanged") {
            int mode = (Integer)newvalue;
            this.tree.getSelectionModel().setSelectionMode(mode);
        } else if (name == "selectionModelChanged") {
            TreeSelectionModel model = (TreeSelectionModel)newvalue;
            this.tree.setSelectionModel(model);
        } else if (name == "isEditable") {
            boolean b = (Boolean)newvalue;
            this.tree.setEditable(b);
        } else if (name == "canGrayoutPane") {
            boolean canGrayout = (Boolean)newvalue;
            this.setGrayoutEnabled(canGrayout);
        } else if (name == "isBusy") {
            boolean busy = (Boolean)newvalue;
            if (busy) {
                this.setWaitCursor();
            } else {
                this.setDefaultCursor();
            }
        }
    }

    protected TreeFileSystemModel getFileSystemModel() {
        return this.filesystemModel;
    }

    protected JScrollPane getUIScroller() {
        return this.scroller;
    }

    protected JComponent getUIGlass() {
        return this.glass;
    }

    protected void setGrayoutEnabled(boolean b) {
        if (b && this.isGrayoutEnabled()) {
            return;
        }
        if (!b && !this.isGrayoutEnabled()) {
            return;
        }
        if (!b && this.isGrayoutEnabled()) {
            this.directoryPane.setLayout(null);
            this.overlayLayout = null;
            this.directoryPane.removeAll();
            this.glass = null;
            this.scroller = null;
            if (this.isActivePaneListener != null) {
                this.directoryPane.removePropertyChangeListener(this.isActivePaneListener);
                this.isActivePaneListener = null;
            }
            this.scroller = new JScrollPane(this.tree);
            this.scroller.setBackground(this.paneBackground);
            this.directoryPane.setLayout(new BorderLayout());
            this.directoryPane.add((Component)this.scroller, "Center");
            this.directoryPane.validate();
        } else if (b && !this.isGrayoutEnabled()) {
            this.directoryPane.setLayout(null);
            this.directoryPane.removeAll();
            this.glass = null;
            this.scroller = null;
            this.overlayLayout = new OverlayLayout(this.directoryPane);
            this.directoryPane.setLayout(this.overlayLayout);
            this.scroller = new JScrollPane(this.tree);
            this.scroller.setBackground(this.paneBackground);
            this.glass = this.createGlassPaneFor(this.scroller);
            if (this.directoryPane.isActivePane()) {
                this.glass.setVisible(false);
            } else {
                this.glass.setVisible(true);
            }
            this.isActivePaneListener = this.createIsActivePaneListener();
            this.directoryPane.addPropertyChangeListener(this.isActivePaneListener);
            this.directoryPane.add(this.glass);
            this.directoryPane.add(this.scroller);
            this.directoryPane.validate();
        }
        this.isGrayoutEnabled = b;
    }

    protected void setPaneBackground(Color c) {
        this.paneBackground = c;
    }

    protected void setPaneActiveBackground(Color c) {
        this.paneActiveBackground = c;
    }

    protected void setPaneNotActiveBackground(Color c) {
        this.paneNotActiveBackground = c;
    }

    protected void setPaneForeground(Color c) {
        this.paneForeground = c;
    }

    protected void setPaneSelectionForeground(Color c) {
        this.paneSelectionForeground = c;
    }

    protected void setPaneSelectionBackground(Color c) {
        this.paneSelectionBackground = c;
    }

    protected void setPaneFont(Font f) {
        this.paneFont = f;
    }

    protected JTree createUITree() {
        return new CustomTree(this.directoryPane, this.filesystemModel);
    }

    protected MouseListener createUITreeMouseListener() {
        return new UITreeMouseListener();
    }

    protected FocusListener createUITreeFocusListener() {
        return new UITreeFocusListener();
    }

    protected LoadingListener createLoadingListener() {
        return new TreeLoadingListener();
    }

    protected PropertyChangeListener createIsActivePaneListener() {
        return new IsActivePaneListener();
    }

    protected TreeCellRenderer createTreeCellRenderer() {
        return new PaneTreeCellRenderer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        CellEditorTextField editorfield = new CellEditorTextField(this.directoryPane);
        return new TreeDirectoryPaneCellEditor(this.tree, editorfield, (Component)((Object)this.renderer));
    }

    public void restoreUIView() {
        if (this.tree != null) {
            UIViewRestorer selector = new UIViewRestorer(this.directoryPane, this.tree);
            SwingUtilities.invokeLater(selector);
        }
    }

    public void setWaitCursor() {
        Window w = SwingUtilities.windowForComponent(this.directoryPane);
        if (w != null) {
            w.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void setDefaultCursor() {
        Window w = SwingUtilities.windowForComponent(this.directoryPane);
        if (w != null) {
            w.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected class CustomTree
    extends JTree {
        private TreeDirectoryPane pane;

        public CustomTree(TreeDirectoryPane pane, TreeFileSystemModel model) {
            super(model);
            this.firePropertyChange("model", null, model);
            this.pane = pane;
            this.enableEvents(16L);
            this.enableEvents(8L);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (BasicTreeDirectoryPaneUI.this.eventDelayer == null && this.pane.isQueueAWTEvents()) {
                BasicTreeDirectoryPaneUI.this.eventDelayer = new TreeEventDelayer(this, this.pane);
            }
            if (BasicTreeDirectoryPaneUI.this.eventDelayer != null && this.pane.isLoading()) {
                BasicTreeDirectoryPaneUI.this.eventDelayer.delay(e);
            } else {
                super.processMouseEvent(e);
            }
        }

        protected void processKeyEvent(KeyEvent e) {
            if (BasicTreeDirectoryPaneUI.this.eventDelayer == null && this.pane.isQueueAWTEvents()) {
                BasicTreeDirectoryPaneUI.this.eventDelayer = new TreeEventDelayer(this, this.pane);
            }
            if (BasicTreeDirectoryPaneUI.this.eventDelayer != null && this.pane.isLoading()) {
                BasicTreeDirectoryPaneUI.this.eventDelayer.delay(e);
            } else {
                super.processKeyEvent(e);
            }
        }

        public void setModel(TreeFileSystemModel model) {
            super.setModel(model);
        }

        public boolean isPathEditable(TreePath path) {
            Object node = path.getLastPathComponent();
            return node != this.getModel().getRoot();
        }

        public String getUIClassID() {
            return BasicTreeDirectoryPaneUI.CustomTree_uiClassID;
        }

        public void updateUI() {
            super.updateUI();
            if (this.pane != null) {
                this.setRowHeight(this.pane.getRowHeight());
            } else {
                this.setRowHeight(18);
            }
        }
    }

    protected class PaneTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        private final TreeDirectoryPane pane;
        private boolean selected;
        private boolean hasFocus;
        private Color bColor;

        public PaneTreeCellRenderer() {
            this.pane = BasicTreeDirectoryPaneUI.this.getDirectoryPane();
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.selected = selected;
            this.hasFocus = hasFocus;
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            FileNode node = (FileNode)value;
            File f = node.getFile();
            this.setHorizontalAlignment(2);
            this.setFont(BasicTreeDirectoryPaneUI.this.getPaneFont());
            this.setText(stringValue);
            Icon icon = this.pane.getTypeIcon(f);
            if (icon != null) {
                this.setIcon(icon);
            }
            this.setLabelColors();
            return this;
        }

        private void setLabelColors() {
            this.setBackground(BasicTreeDirectoryPaneUI.this.getPaneBackground());
            if (this.pane.isPaintSelectionOnlyWhenActive()) {
                if (this.pane.isActivePane() && this.selected) {
                    this.setForeground(BasicTreeDirectoryPaneUI.this.getPaneSelectionForeground());
                    this.bColor = BasicTreeDirectoryPaneUI.this.getPaneSelectionBackground();
                } else {
                    this.setForeground(BasicTreeDirectoryPaneUI.this.getPaneForeground());
                    this.bColor = BasicTreeDirectoryPaneUI.this.getPaneBackground();
                }
            } else if (this.selected) {
                this.setForeground(BasicTreeDirectoryPaneUI.this.getPaneSelectionForeground());
                this.bColor = BasicTreeDirectoryPaneUI.this.getPaneSelectionBackground();
            } else {
                this.setForeground(BasicTreeDirectoryPaneUI.this.getPaneForeground());
                this.bColor = BasicTreeDirectoryPaneUI.this.getPaneBackground();
            }
        }

        public void paint(Graphics g) {
            if (this.bColor != null) {
                g.setColor(this.bColor);
                Icon currentI = this.getIcon();
                if (currentI != null && this.getText() != null) {
                    int offset = currentI.getIconWidth() + this.getIconTextGap() - 2;
                    g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
                } else {
                    g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
            if (this.hasFocus) {
                g.setColor(BasicTreeDirectoryPaneUI.this.getPaneSelectionBorder());
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }

        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 10, retDimension.height);
            }
            return retDimension;
        }
    }

    protected class IsActivePaneListener
    implements PropertyChangeListener {
        protected IsActivePaneListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JTree t = BasicTreeDirectoryPaneUI.this.getUITree();
            Object newvalue = e.getNewValue();
            String name = e.getPropertyName();
            if (name == "isActivePane") {
                boolean active = (Boolean)newvalue;
                if (active) {
                    JComponent g = BasicTreeDirectoryPaneUI.this.getUIGlass();
                    if (g != null) {
                        g.setVisible(false);
                    }
                    Color activeBG = BasicTreeDirectoryPaneUI.this.getDirectoryPane().getBackground();
                    BasicTreeDirectoryPaneUI.this.setPaneActiveBackground(activeBG);
                    BasicTreeDirectoryPaneUI.this.setPaneBackground(activeBG);
                    BasicTreeDirectoryPaneUI.this.getUIScroller().setBackground(activeBG);
                    t.setBackground(activeBG);
                    t.repaint();
                    t.requestFocus();
                } else {
                    JComponent g;
                    if (t.isEditing()) {
                        t.cancelEditing();
                    }
                    if ((g = BasicTreeDirectoryPaneUI.this.getUIGlass()) != null) {
                        g.setVisible(true);
                    }
                    Color notActiveBG = BasicTreeDirectoryPaneUI.this.getDirectoryPane().getNotActiveBackground();
                    BasicTreeDirectoryPaneUI.this.setPaneNotActiveBackground(notActiveBG);
                    BasicTreeDirectoryPaneUI.this.setPaneBackground(notActiveBG);
                    BasicTreeDirectoryPaneUI.this.getUIScroller().setBackground(notActiveBG);
                    t.setBackground(notActiveBG);
                    t.repaint();
                }
            }
        }
    }

    protected class TreeLoadingListener
    implements LoadingListener {
        protected TreeLoadingListener() {
        }

        public void loadingChanged(LoadingEvent evt) {
            if (!(evt instanceof TreeLoadingEvent)) {
                return;
            }
            TreeLoadingEvent e = (TreeLoadingEvent)evt;
            int eventType = e.getType();
            TreeDirectoryPane pane = BasicTreeDirectoryPaneUI.this.getDirectoryPane();
            JTree t = BasicTreeDirectoryPaneUI.this.getUITree();
            if (eventType == 0) {
                BasicTreeDirectoryPaneUI.this.setWaitCursor();
                pane.setLoading(true);
                pane.setUpdating(true);
            } else if (eventType == 1) {
                int loadType = e.getLoadType();
                TreePath p = e.getPath();
                switch (loadType) {
                    case 0: {
                        t.scrollPathToVisible(p);
                        t.setSelectionPath(p);
                        break;
                    }
                    case 1: {
                        t.scrollPathToVisible(p);
                        t.setSelectionPath(p);
                        t.expandPath(p);
                        break;
                    }
                    case 2: {
                        BasicTreeDirectoryPaneUI.this.restoreUIView();
                    }
                }
                pane.setUpdating(false);
                pane.setLoading(false);
                BasicTreeDirectoryPaneUI.this.setDefaultCursor();
            }
        }
    }

    protected class UITreeFocusListener
    extends FocusAdapter {
        protected UITreeFocusListener() {
        }

        public void focusGained(FocusEvent ignored) {
            if (!BasicTreeDirectoryPaneUI.this.getDirectoryPane().isActivePane()) {
                BasicTreeDirectoryPaneUI.this.getDirectoryPane().setActivePane(true);
            }
        }
    }

    protected class UITreeMouseListener
    extends MouseAdapter {
        protected UITreeMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TreePath selPath = BasicTreeDirectoryPaneUI.this.getUITree().getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                if (!SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 2) {
                    BasicTreeDirectoryPaneUI.this.getDirectoryPane().performDoubleClick();
                }
            } else if (BasicTreeDirectoryPaneUI.this.editor != null) {
                BasicTreeDirectoryPaneUI.this.editor.cancelCellEditing();
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && BasicTreeDirectoryPaneUI.this.getDirectoryPane().hasPopupMenu()) {
                JPopupMenu popup = BasicTreeDirectoryPaneUI.this.getDirectoryPane().getPopupMenu();
                MouseEvent popevent = SwingUtilities.convertMouseEvent(BasicTreeDirectoryPaneUI.this.getUITree(), e, popup.getInvoker());
                popup.show(popup.getInvoker(), popevent.getX(), popevent.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && BasicTreeDirectoryPaneUI.this.getDirectoryPane().hasPopupMenu()) {
                JPopupMenu popup = BasicTreeDirectoryPaneUI.this.getDirectoryPane().getPopupMenu();
                MouseEvent popevent = SwingUtilities.convertMouseEvent(BasicTreeDirectoryPaneUI.this.getUITree(), e, popup.getInvoker());
                popup.show(popup.getInvoker(), popevent.getX(), popevent.getY());
            }
        }
    }

    class UIViewRestorer
    implements Runnable {
        private final TreeDirectoryPane pane;
        private final JTree uitree;

        public UIViewRestorer(TreeDirectoryPane pane, JTree uitree) {
            this.pane = pane;
            this.uitree = uitree;
        }

        public void run() {
            TreePath[] expCache = this.pane.getExpansionCache();
            int i = 0;
            while (i < expCache.length) {
                TreePath p = expCache[i];
                this.uitree.expandPath(p);
                ++i;
            }
            TreePath[] selCache = this.pane.getSelectionCache();
            Object[] p = new FileNode[]{this.pane.getRoot()};
            TreePath rootPath = new TreePath(p);
            if (selCache != null) {
                this.uitree.setSelectionPaths(selCache);
                this.uitree.scrollPathToVisible(selCache[selCache.length - 1]);
            } else {
                this.uitree.setSelectionPath(rootPath);
                this.uitree.scrollPathToVisible(rootPath);
            }
            this.pane.setRebuilding(false);
        }
    }
}

