/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf.basic;

import com.hbworks.dirpane.TableSelectionModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class BasicPaneTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicPaneTableUI();
    }

    public void installUI(JComponent c) {
        this.table = (JTable)c;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Container parent;
        Color gridColor;
        Color sfg;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        Color sbg = this.table.getSelectionBackground();
        if (sbg == null || sbg instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((sfg = this.table.getSelectionForeground()) == null || sfg instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((gridColor = this.table.getGridColor()) == null || gridColor instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((parent = this.table.getParent()) != null && (parent = parent.getParent()) != null && parent instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)parent, "Table.scrollPaneBorder");
        }
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
    }

    private void registerKey(int keyEvent, int mask, int dx, int dy) {
        boolean toggle = (mask & 2) != 0;
        boolean extend = (mask & 1) != 0;
        boolean moveAnchor = !extend && !toggle;
        this.registerKey(keyEvent, mask, dx, dy, toggle, extend, moveAnchor, false);
    }

    private void registerKey(int keyEvent, int mask, int dx, int dy, boolean toggle, boolean extend, boolean moveAnchor, boolean inSelection) {
        this.table.registerKeyboardAction(new NavigationalAction(dx, dy, toggle, extend, moveAnchor, inSelection), KeyStroke.getKeyStroke(keyEvent, mask), 0);
    }

    protected void installKeyboardActions() {
        int shift = 1;
        int ctrl = 2;
        this.registerKey(39, 0, 1, 0);
        this.registerKey(37, 0, -1, 0);
        this.registerKey(40, 0, 0, 1);
        this.registerKey(38, 0, 0, -1);
        this.registerKey(39, shift, 1, 0);
        this.registerKey(37, shift, -1, 0);
        this.registerKey(40, shift, 0, 1);
        this.registerKey(38, shift, 0, -1);
        this.registerKey(39, ctrl, 1, 0);
        this.registerKey(37, ctrl, -1, 0);
        this.registerKey(40, ctrl, 0, 1);
        this.registerKey(38, ctrl, 0, -1);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicPaneTableUI.this.table.selectAll();
            }
        }, KeyStroke.getKeyStroke(65, ctrl), 0);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                BasicPaneTableUI.this.table.clearSelection();
            }
        }, KeyStroke.getKeyStroke(65, ctrl | shift), 0);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableSelectionModel rsm = (TableSelectionModel)BasicPaneTableUI.this.table.getSelectionModel();
                int leadRow = rsm.getLeadSelectionIndex();
                BasicPaneTableUI.this.updateSelection(leadRow, true, false);
            }
        }, KeyStroke.getKeyStroke(32, ctrl), 0);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableSelectionModel rsm = (TableSelectionModel)BasicPaneTableUI.this.table.getSelectionModel();
                int leadRow = rsm.getLeadSelectionIndex();
                BasicPaneTableUI.this.updateSelection(leadRow, false, true);
            }
        }, KeyStroke.getKeyStroke(32, shift), 0);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TableSelectionModel rsm = (TableSelectionModel)BasicPaneTableUI.this.table.getSelectionModel();
                int leadRow = rsm.getLeadSelectionIndex();
                BasicPaneTableUI.this.table.editCellAt(leadRow, BasicPaneTableUI.this.table.convertColumnIndexToView(0));
            }
        }, KeyStroke.getKeyStroke(113, 0), 0);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    protected void uninstallKeyboardActions() {
        int shift = 1;
        int ctrl = 2;
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, shift));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, shift));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, shift));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, shift));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, ctrl));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, ctrl));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, ctrl));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, ctrl));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, ctrl));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(32, shift));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(65, ctrl));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(65, ctrl | shift));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    private Dimension createTableSize(long width) {
        int height = this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin());
        int totalMarginWidth = this.table.getColumnModel().getColumnMargin() * this.table.getColumnCount();
        long widthWithMargin = Math.abs(width) + (long)totalMarginWidth;
        if (widthWithMargin > Integer.MAX_VALUE) {
            widthWithMargin = Integer.MAX_VALUE;
        }
        return new Dimension((int)widthWithMargin, height);
    }

    public Dimension getMinimumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMinWidth();
        }
        return this.createTableSize(width);
    }

    public Dimension getPreferredSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getPreferredWidth();
        }
        return this.createTableSize(width);
    }

    public Dimension getMaximumSize(JComponent c) {
        long width = 0L;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            width += (long)aColumn.getMaxWidth();
        }
        return this.createTableSize(width);
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle oldClipBounds = g.getClipBounds();
        Rectangle clipBounds = new Rectangle(oldClipBounds);
        int tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        clipBounds.width = Math.min(clipBounds.width, tableWidth);
        g.setClip(clipBounds);
        this.paintGrid(g);
        int firstIndex = this.table.rowAtPoint(new Point(0, clipBounds.y));
        int lastIndex = this.lastVisibleRow(clipBounds);
        Rectangle rowRect = new Rectangle(0, 0, tableWidth, this.table.getRowHeight() + this.table.getRowMargin());
        rowRect.y = firstIndex * rowRect.height;
        int index = firstIndex;
        while (index <= lastIndex) {
            if (rowRect.intersects(clipBounds)) {
                this.paintRow(g, index);
            }
            rowRect.y += rowRect.height;
            ++index;
        }
        g.setClip(oldClipBounds);
    }

    private void paintGrid(Graphics g) {
        g.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines()) {
            this.paintHorizontalLines(g);
        }
        if (this.table.getShowVerticalLines()) {
            this.paintVerticalLines(g);
        }
    }

    private void paintHorizontalLines(Graphics g) {
        Rectangle r;
        Rectangle rect = r = g.getClipBounds();
        int delta = this.table.getRowHeight() + this.table.getRowMargin();
        int firstIndex = this.table.rowAtPoint(new Point(0, r.y));
        int lastIndex = this.lastVisibleRow(r);
        int y = delta * firstIndex + (delta - 1);
        int index = firstIndex;
        while (index <= lastIndex) {
            if (y >= rect.y && y <= rect.y + rect.height) {
                g.drawLine(rect.x, y, rect.x + rect.width - 1, y);
            }
            y += delta;
            ++index;
        }
    }

    private void paintVerticalLines(Graphics g) {
        Rectangle rect = g.getClipBounds();
        int x = 0;
        int count = this.table.getColumnCount();
        int horizontalSpacing = this.table.getIntercellSpacing().width;
        int index = 0;
        while (index <= count) {
            if (x > 0 && x - 1 >= rect.x && x - 1 <= rect.x + rect.width) {
                g.drawLine(x - 1, rect.y, x - 1, rect.y + rect.height - 1);
            }
            if (index < count) {
                x += this.table.getColumnModel().getColumn(index).getWidth() + horizontalSpacing;
            }
            ++index;
        }
    }

    private void paintRow(Graphics g, int row) {
        Rectangle rect = g.getClipBounds();
        int column = 0;
        boolean drawn = false;
        int draggedColumnIndex = -1;
        Rectangle draggedCellRect = null;
        Dimension spacing = this.table.getIntercellSpacing();
        JTableHeader header = this.table.getTableHeader();
        Rectangle cellRect = new Rectangle();
        cellRect.height = this.table.getRowHeight() + spacing.height;
        cellRect.y = row * cellRect.height;
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            cellRect.width = aColumn.getWidth() + spacing.width;
            if (cellRect.intersects(rect)) {
                drawn = true;
                if (header == null || aColumn != header.getDraggedColumn()) {
                    this.paintCell(g, cellRect, row, column);
                } else {
                    g.setColor(this.table.getParent().getBackground());
                    g.fillRect(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
                    draggedCellRect = new Rectangle(cellRect);
                    draggedColumnIndex = column;
                }
            } else if (drawn) break;
            cellRect.x += cellRect.width;
            ++column;
        }
        if (draggedColumnIndex != -1 && draggedCellRect != null) {
            draggedCellRect.x += header.getDraggedDistance();
            g.setColor(this.table.getBackground());
            g.fillRect(draggedCellRect.x, draggedCellRect.y, draggedCellRect.width, draggedCellRect.height);
            g.setColor(this.table.getGridColor());
            int x1 = draggedCellRect.x;
            int y1 = draggedCellRect.y;
            int x2 = x1 + draggedCellRect.width - 1;
            int y2 = y1 + draggedCellRect.height - 1;
            if (this.table.getShowVerticalLines()) {
                g.drawLine(x2, y1, x2, y2);
            }
            if (this.table.getShowHorizontalLines()) {
                g.drawLine(x1, y2, x2, y2);
            }
            this.paintCell(g, draggedCellRect, row, draggedColumnIndex);
        }
    }

    private void paintCell(Graphics g, Rectangle cellRect, int row, int column) {
        int spacingHeight = this.table.getRowMargin();
        int spacingWidth = this.table.getColumnModel().getColumnMargin();
        cellRect.setBounds(cellRect.x + spacingWidth / 2, cellRect.y + spacingHeight / 2, cellRect.width - spacingWidth, cellRect.height - spacingHeight);
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            TableCellRenderer renderer = this.table.getCellRenderer(row, column);
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
        cellRect.setBounds(cellRect.x - spacingWidth / 2, cellRect.y - spacingHeight / 2, cellRect.width + spacingWidth, cellRect.height + spacingHeight);
    }

    private int lastVisibleRow(Rectangle clip) {
        int lastIndex = this.table.rowAtPoint(new Point(0, clip.y + clip.height - 1));
        if (lastIndex == -1) {
            lastIndex = this.table.getRowCount() - 1;
        }
        return lastIndex;
    }

    private void updateSelectionModel(ListSelectionModel sm, int index, boolean toggle, boolean extend) {
        if (!extend) {
            if (!toggle) {
                sm.setSelectionInterval(index, index);
            } else if (sm.isSelectedIndex(index)) {
                sm.removeSelectionInterval(index, index);
            } else {
                sm.addSelectionInterval(index, index);
            }
        } else {
            sm.setLeadSelectionIndex(index);
        }
    }

    private void updateSelection(int rowIndex, boolean toggle, boolean extend) {
        ListSelectionModel rsm;
        Rectangle cellRect = this.table.getCellRect(rowIndex, 0, false);
        if (cellRect != null) {
            this.table.scrollRectToVisible(cellRect);
        }
        if ((rsm = this.table.getSelectionModel()).isSelectionEmpty() && extend) {
            this.updateSelectionModel(rsm, 0, false, false);
        }
        this.updateSelectionModel(rsm, rowIndex, toggle, extend);
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private boolean phantomMousePressed = false;
        private Component dispatchComponent;

        public void mouseClicked(MouseEvent e) {
        }

        private boolean repostEvent(MouseEvent e) {
            if (this.dispatchComponent == null) {
                return false;
            }
            MouseEvent e2 = SwingUtilities.convertMouseEvent(BasicPaneTableUI.this.table, e, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(e2);
            return true;
        }

        private void setValueIsAdjusting(boolean flag) {
            BasicPaneTableUI.this.table.getSelectionModel().setValueIsAdjusting(flag);
        }

        public void mousePressed(MouseEvent e) {
            boolean repostEvent;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.phantomMousePressed) {
                return;
            }
            this.phantomMousePressed = true;
            Point p = e.getPoint();
            int row = BasicPaneTableUI.this.table.rowAtPoint(p);
            if (row == -1) {
                if (BasicPaneTableUI.this.table.isEditing()) {
                    BasicPaneTableUI.this.table.getCellEditor().cancelCellEditing();
                }
                return;
            }
            if (BasicPaneTableUI.this.table.isEditing() && row != BasicPaneTableUI.this.table.getEditingRow()) {
                BasicPaneTableUI.this.table.getCellEditor().cancelCellEditing();
            }
            boolean startedNewEditor = BasicPaneTableUI.this.table.editCellAt(row, 0, e);
            boolean bl = repostEvent = BasicPaneTableUI.this.table.isEditing() && startedNewEditor;
            if (repostEvent) {
                Component editorComponent = BasicPaneTableUI.this.table.getEditorComponent();
                Point p2 = SwingUtilities.convertPoint(BasicPaneTableUI.this.table, p, editorComponent);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(editorComponent, p2.x, p2.y);
                this.repostEvent(e);
            }
            if (!repostEvent || BasicPaneTableUI.this.table.getCellEditor().shouldSelectCell(e)) {
                BasicPaneTableUI.this.table.requestFocus();
                this.setValueIsAdjusting(true);
                BasicPaneTableUI.this.updateSelection(row, e.isControlDown(), e.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.phantomMousePressed = false;
            this.repostEvent(e);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        public void mouseEntered(MouseEvent e) {
            this.dispatchComponent = null;
        }

        public void mouseExited(MouseEvent e) {
            this.dispatchComponent = null;
        }

        public void mouseMoved(MouseEvent e) {
            this.dispatchComponent = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.repostEvent(e)) {
                return;
            }
            Point p = e.getPoint();
            int row = BasicPaneTableUI.this.table.rowAtPoint(p);
            if (row == -1) {
                return;
            }
            if (BasicPaneTableUI.this.table.isEditing() && row != BasicPaneTableUI.this.table.getEditingRow()) {
                BasicPaneTableUI.this.table.getCellEditor().cancelCellEditing();
            }
            BasicPaneTableUI.this.updateSelection(row, false, true);
        }
    }

    public class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int anchorRow = BasicPaneTableUI.this.table.getSelectedRow();
            int anchorColumn = BasicPaneTableUI.this.table.getSelectedColumn();
            Rectangle dirtyRect = BasicPaneTableUI.this.table.getCellRect(anchorRow, anchorColumn, false);
            BasicPaneTableUI.this.table.repaint(dirtyRect);
        }

        public void focusGained(FocusEvent e) {
            if (BasicPaneTableUI.this.table.getRowCount() <= 0) {
                return;
            }
            if (BasicPaneTableUI.this.table.getSelectedColumn() == -1) {
                return;
            }
            if (BasicPaneTableUI.this.table.getSelectedRow() == -1) {
                return;
            }
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent e) {
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    protected class NavigationalAction
    extends AbstractAction {
        private int dx;
        private int dy;
        private boolean toggle;
        private boolean extend;
        private boolean moveAnchor;
        private boolean inSelection;
        private int anchorRow;
        private int leadRow;

        public NavigationalAction(int dx, int dy, boolean toggle, boolean extend, boolean moveAnchor, boolean inSelection) {
            this.dx = dx;
            this.dy = dy;
            this.toggle = toggle;
            this.extend = extend;
            this.moveAnchor = moveAnchor;
            this.inSelection = inSelection;
        }

        private boolean inRange(int index, int min, int max) {
            return index >= min && index < max;
        }

        private int selectionSpan(ListSelectionModel sm) {
            return sm.getMaxSelectionIndex() - sm.getMinSelectionIndex() + 1;
        }

        private int indexSign(int index, ListSelectionModel sm) {
            if (index < sm.getMinSelectionIndex()) {
                return -1;
            }
            if (index > sm.getMaxSelectionIndex()) {
                return 1;
            }
            return 0;
        }

        private boolean inTableRange(int row) {
            return this.inRange(row, 0, BasicPaneTableUI.this.table.getRowCount());
        }

        private void limitToSelectedRange() {
            ListSelectionModel rsm = BasicPaneTableUI.this.table.getSelectionModel();
            int rowSgn = this.indexSign(this.anchorRow, rsm);
            this.anchorRow -= this.selectionSpan(rsm) * rowSgn;
        }

        public void actionPerformed(ActionEvent e) {
            boolean noWhereToGo;
            TableSelectionModel rsm = (TableSelectionModel)BasicPaneTableUI.this.table.getSelectionModel();
            this.anchorRow = rsm.getAnchorSelectionIndex();
            this.leadRow = rsm.getLeadSelectionIndex();
            int oldAnchorRow = this.anchorRow;
            boolean bl = noWhereToGo = this.selectionSpan(rsm) == 1;
            if (!this.inSelection || noWhereToGo) {
                if (this.moveAnchor) {
                    this.anchorRow += this.dy;
                    if (this.inTableRange(this.anchorRow)) {
                        BasicPaneTableUI.this.updateSelection(this.anchorRow, false, this.extend);
                    }
                } else if (this.toggle) {
                    this.leadRow += this.dy;
                    if (this.inTableRange(this.leadRow)) {
                        rsm.updateLeadSelectionIndex(this.leadRow);
                    }
                } else {
                    this.leadRow += this.dy;
                    if (this.inTableRange(this.leadRow)) {
                        BasicPaneTableUI.this.updateSelection(this.leadRow, false, this.extend);
                    }
                }
            } else {
                this.anchorRow += this.dy;
                this.limitToSelectedRange();
                rsm.setAnchorSelectionIndex(this.anchorRow);
            }
            if (BasicPaneTableUI.this.table.isEditing() && oldAnchorRow != rsm.getAnchorSelectionIndex()) {
                BasicPaneTableUI.this.table.getCellEditor().cancelCellEditing();
            }
        }
    }
}

