/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.filechooser;

import com.hbworks.dirpane.DefaultFileSorter;
import com.hbworks.dirpane.FileFilter;
import com.hbworks.dirpane.FileSorter;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileView;
import com.hbworks.dirpane.PatternSearcher;
import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.comp.FilterComboBox;
import com.hbworks.dirpane.comp.TableFilenameField;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.TableColumn;

public class FileChooserDialog {
    protected EventListenerList listenerList = new EventListenerList();
    public static int PREF_WIDTH = 400;
    public static int PREF_HEIGHT = 125;
    public static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    public static int MIN_WIDTH = 300;
    public static int MIN_HEIGHT = 100;
    public static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    public static int MAX_WIDTH = 500;
    public static int MAX_HEIGHT = 300;
    public static Dimension MAX_SIZE = new Dimension(MAX_WIDTH, MAX_HEIGHT);
    protected static final Dimension hstrut05 = new Dimension(5, 1);
    protected static final Dimension hstrut10 = new Dimension(10, 1);
    protected static final Dimension vstrut05 = new Dimension(1, 5);
    protected static final Dimension vstrut10 = new Dimension(1, 10);
    public static final Point DEFAULT_RELATIVE_LOCATION_OFFSET = new Point(20, 20);
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String PROCEED_SELECTION = "ProceedSelection";
    public static final String ERROR_SELECTION = "ErrorSelection";
    public static final String NO_SELECTION = "NoSelection";
    public static final int CANCEL_OPTION = 1;
    public static final int PROCEED_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private String openDialogTitle;
    private String saveDialogTitle;
    private String proceedOpenButtonText;
    private String proceedSaveButtonText;
    private String cancelButtonText;
    private String lookinLabelText;
    private String filenameLabelText;
    private String filterLabelText;
    private boolean showGoHomeButton = true;
    private boolean showNewFolderButton = true;
    private boolean showViewModeButtons = true;
    protected Frame dialogParent = null;
    protected String dialogTitle = null;
    protected String proceedButtonText = null;
    protected Character proceedButtonMnemonic = null;
    protected Character cancelButtonMnemonic = null;
    protected Character lookinMnemonic = null;
    protected Character filenameMnemonic = null;
    protected Character filterMnemonic = null;
    protected Point relativeLocationOffset = DEFAULT_RELATIVE_LOCATION_OFFSET;
    protected int returnValue = -1;
    protected JDialog dialog = null;
    protected JComponent accessory = null;
    protected JPanel additionalActionPanel = null;
    protected TableDirectoryPane directoryPane = null;
    protected JButton proceedButton = null;
    protected TableFilenameField filenameField = null;
    protected File[] filesToSelect = null;
    protected File[] selectedFiles = null;
    protected String multipleFileDelimiter = "\"";
    private SwingPropertyChangeSupport changeSupport;
    protected String locationToSet = null;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public FileChooserDialog() {
        this(null);
    }

    public FileChooserDialog(String initDir) {
        this.directoryPane = this.createDirectoryPane(initDir);
        this.locationToSet = initDir;
        this.localizeStrings();
    }

    protected TableDirectoryPane createDirectoryPane(String initDir) {
        TableDirectoryPane pane = new TableDirectoryPane(initDir);
        pane.addColumnWidthListener(new ColumnWatcher());
        pane.addActionListener(new DoubleClickListener());
        pane.setPreferredSize(PREF_SIZE);
        pane.setMinimumSize(MIN_SIZE);
        pane.setMaximumSize(MAX_SIZE);
        return pane;
    }

    private void localizeStrings() {
        this.openDialogTitle = LocalizedStringTable.getString("FileChooserDialog.openDialogTitle");
        this.saveDialogTitle = LocalizedStringTable.getString("FileChooserDialog.saveDialogTitle");
        this.proceedOpenButtonText = LocalizedStringTable.getString("FileChooserDialog.proceedOpenButtonText");
        this.proceedSaveButtonText = LocalizedStringTable.getString("FileChooserDialog.proceedSaveButtonText");
        this.cancelButtonText = LocalizedStringTable.getString("FileChooserDialog.cancelButtonText");
        this.lookinLabelText = LocalizedStringTable.getString("FileChooserDialog.lookinLabelText");
        this.filenameLabelText = LocalizedStringTable.getString("FileChooserDialog.filenameLabelText");
        this.filterLabelText = LocalizedStringTable.getString("FileChooserDialog.filterLabelText");
    }

    private void registerEscapeKeyToCancel(JComponent c) {
        c.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FileChooserDialog.this.cancelSelection();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
    }

    public int showOpenDialog(Component parent) {
        this.dialogTitle = this.openDialogTitle;
        this.proceedButtonText = this.proceedOpenButtonText;
        return this.showDialog(parent);
    }

    public int showSaveDialog(Component parent) {
        this.dialogTitle = this.saveDialogTitle;
        this.proceedButtonText = this.proceedSaveButtonText;
        return this.showDialog(parent);
    }

    public int showCustomDialog(Component parent) {
        if (this.dialogTitle == null) {
            this.dialogTitle = this.openDialogTitle;
        }
        if (this.proceedButtonText == null) {
            this.proceedButtonText = this.proceedOpenButtonText;
        }
        return this.showDialog(parent);
    }

    public int showCustomDialog(Component parent, String title, String buttonText) {
        this.dialogTitle = title;
        this.proceedButtonText = buttonText;
        return this.showDialog(parent);
    }

    protected int showDialog(Component parent) {
        this.createMnemonics();
        this.dialogParent = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = FileChooserDialog.class$("java.awt.Frame")) : class$java$awt$Frame, parent);
        this.dialog = new JDialog(this.dialogParent, this.dialogTitle, true);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new DialogListener());
        Container contentPane = this.dialog.getContentPane();
        contentPane.add((Component)this.createDialogContent(), "Center");
        this.registerEscapeKeyToCancel(this.dialog.getRootPane());
        this.selectedFiles = null;
        this.dialog.pack();
        ((Component)this.dialog).setLocation(this.getRelativeLocation(parent));
        this.dialog.show();
        return this.returnValue;
    }

    public String getMultipleFileDelimiter() {
        return this.multipleFileDelimiter;
    }

    public void setMultipleFileDelimiter(String delimiter) {
        this.multipleFileDelimiter = delimiter;
    }

    protected Point getRelativeLocation(Component parent) {
        Point p = parent.getLocation();
        return new Point(p.x + this.relativeLocationOffset.x, p.y + this.relativeLocationOffset.y);
    }

    public void setRelativeLocationOffset(Point offset) {
        if (offset == null) {
            offset = DEFAULT_RELATIVE_LOCATION_OFFSET;
        }
        this.relativeLocationOffset = offset;
    }

    public void setMinimumSize(Dimension minSize) {
        if (minSize == null) {
            minSize = MIN_SIZE;
        }
        this.directoryPane.setMinimumSize(minSize);
    }

    public void setMaximumSize(Dimension maxSize) {
        if (maxSize == null) {
            maxSize = MAX_SIZE;
        }
        this.directoryPane.setMaximumSize(maxSize);
    }

    public void setPreferredSize(Dimension prefSize) {
        if (prefSize == null) {
            prefSize = PREF_SIZE;
        }
        this.directoryPane.setPreferredSize(prefSize);
    }

    public void setShowGoHomeButton(boolean show) {
        this.showGoHomeButton = show;
    }

    public void setShowNewFolderButton(boolean show) {
        this.showNewFolderButton = show;
    }

    public void setShowViewModeButtons(boolean show) {
        this.showViewModeButtons = show;
    }

    protected JPanel createDialogContent() {
        JPanel retVal = new JPanel(new BorderLayout(2, 5));
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        JPanel navigationPanel = this.createNavigationPanel();
        JPanel directoryPanePanel = this.createDirectoryPanePanel();
        JPanel actionPanel = this.createActionPanel();
        northPanel.add(Box.createRigidArea(vstrut05));
        northPanel.add(navigationPanel);
        southPanel.add(actionPanel);
        if (this.additionalActionPanel != null) {
            southPanel.add(Box.createRigidArea(vstrut10));
            southPanel.add(this.additionalActionPanel);
        }
        southPanel.add(Box.createRigidArea(vstrut10));
        retVal.add((Component)southPanel, "South");
        retVal.add((Component)directoryPanePanel, "Center");
        retVal.add((Component)northPanel, "North");
        return retVal;
    }

    protected JPanel createDirectoryPanePanel() {
        JPanel retVal = new JPanel();
        retVal.setLayout(new BoxLayout(retVal, 0));
        retVal.add(Box.createRigidArea(hstrut05));
        JPanel subPanel = new JPanel(new BorderLayout());
        subPanel.add((Component)this.directoryPane, "Center");
        if (this.accessory != null) {
            subPanel.add((Component)this.accessory, "East");
        }
        retVal.add(subPanel);
        retVal.add(Box.createRigidArea(hstrut05));
        return retVal;
    }

    protected JPanel createNavigationPanel() {
        JComboBox directoryComboBox = this.directoryPane.getDirectoryComboBox();
        JLabel lookinLabel = new JLabel(this.lookinLabelText);
        lookinLabel.setDisplayedMnemonic(this.lookinMnemonic.charValue());
        lookinLabel.setLabelFor(directoryComboBox);
        JToggleButton detailsViewButton = this.directoryPane.getDetailsViewButton();
        String detailsViewTip = LocalizedStringTable.getString("FileChooserDialog.detailsViewTip");
        detailsViewButton.setToolTipText(detailsViewTip);
        JToggleButton listViewButton = this.directoryPane.getListViewButton();
        String listViewTip = LocalizedStringTable.getString("FileChooserDialog.listViewTip");
        listViewButton.setToolTipText(listViewTip);
        JButton goUpButton = this.directoryPane.getGoUpButton();
        String goUpTip = LocalizedStringTable.getString("FileChooserDialog.goUpTip");
        goUpButton.setToolTipText(goUpTip);
        JButton goHomeButton = this.directoryPane.getGoHomeButton();
        String goHomeTip = LocalizedStringTable.getString("FileChooserDialog.goHomeTip");
        goHomeButton.setToolTipText(goHomeTip);
        JButton newFolderButton = this.directoryPane.getNewFolderButton();
        String newFolderTip = LocalizedStringTable.getString("FileChooserDialog.newFolderTip");
        newFolderButton.setToolTipText(newFolderTip);
        ButtonGroup bg = new ButtonGroup();
        bg.add(listViewButton);
        bg.add(detailsViewButton);
        JPanel retVal = new JPanel();
        retVal.setLayout(new BoxLayout(retVal, 0));
        retVal.add(Box.createRigidArea(hstrut05));
        retVal.add(lookinLabel);
        retVal.add(Box.createRigidArea(hstrut10));
        retVal.add(directoryComboBox);
        retVal.add(Box.createHorizontalGlue());
        retVal.add(goUpButton);
        if (this.showGoHomeButton) {
            retVal.add(Box.createRigidArea(hstrut10));
            retVal.add(goHomeButton);
        }
        if (this.showNewFolderButton) {
            retVal.add(Box.createRigidArea(hstrut10));
            retVal.add(newFolderButton);
        }
        if (this.showViewModeButtons) {
            retVal.add(Box.createRigidArea(hstrut10));
            retVal.add(listViewButton);
            retVal.add(detailsViewButton);
        }
        retVal.add(Box.createRigidArea(hstrut05));
        return retVal;
    }

    protected JPanel createActionPanel() {
        this.filenameField = (TableFilenameField)this.directoryPane.getFilenameField();
        this.filenameField.setMultipleFileDelimiter(this.multipleFileDelimiter);
        this.filenameField.getDocument().addDocumentListener(new IsSomethingSelectedListener());
        this.filenameField.setSelectedFiles(this.filesToSelect);
        this.filenameField.addActionListener(new FilenameFieldListener());
        FilterComboBox filterComboBox = (FilterComboBox)this.directoryPane.getFilterComboBox();
        JLabel filenameLabel = new JLabel(this.filenameLabelText);
        filenameLabel.setDisplayedMnemonic(this.filenameMnemonic.charValue());
        filenameLabel.setLabelFor(this.filenameField);
        JLabel filterLabel = new JLabel(this.filterLabelText);
        filterLabel.setDisplayedMnemonic(this.filterMnemonic.charValue());
        filterLabel.setLabelFor(filterComboBox);
        ButtonActionListener buttonListener = new ButtonActionListener();
        this.proceedButton = new JButton(this.proceedButtonText);
        this.proceedButton.setActionCommand(PROCEED_SELECTION);
        this.proceedButton.addActionListener(buttonListener);
        this.proceedButton.setMnemonic(this.proceedButtonMnemonic.charValue());
        this.proceedButton.setEnabled(this.isSomethingSelected());
        this.dialog.getRootPane().setDefaultButton(this.proceedButton);
        JButton cancelButton = new JButton(this.cancelButtonText);
        cancelButton.setActionCommand(CANCEL_SELECTION);
        cancelButton.addActionListener(buttonListener);
        cancelButton.setMnemonic(this.cancelButtonMnemonic.charValue());
        JPanel retVal = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 5, 5, 5);
        retVal.add((Component)filenameLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        retVal.add((Component)this.filenameField, c);
        c.weightx = 0.0;
        c.gridx = 2;
        retVal.add((Component)this.proceedButton, c);
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 5, 0, 5);
        retVal.add((Component)filterLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        retVal.add((Component)filterComboBox, c);
        c.weightx = 0.0;
        c.gridx = 2;
        retVal.add((Component)cancelButton, c);
        return retVal;
    }

    protected void createMnemonics() {
        this.proceedButtonMnemonic = new Character(this.proceedButtonText.charAt(0));
        char[] charArray = this.cancelButtonText.toLowerCase().toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] != this.proceedButtonMnemonic.charValue()) {
                this.cancelButtonMnemonic = new Character(charArray[i]);
                break;
            }
            ++i;
        }
        charArray = this.lookinLabelText.toLowerCase().toCharArray();
        int i2 = 0;
        while (i2 < charArray.length) {
            if (charArray[i2] != this.proceedButtonMnemonic.charValue() && charArray[i2] != this.cancelButtonMnemonic.charValue()) {
                this.lookinMnemonic = new Character(charArray[i2]);
                break;
            }
            ++i2;
        }
        charArray = this.filenameLabelText.toLowerCase().toCharArray();
        int i3 = 0;
        while (i3 < charArray.length) {
            if (charArray[i3] != this.proceedButtonMnemonic.charValue() && charArray[i3] != this.cancelButtonMnemonic.charValue() && charArray[i3] != this.lookinMnemonic.charValue()) {
                this.filenameMnemonic = new Character(charArray[i3]);
                break;
            }
            ++i3;
        }
        charArray = this.filterLabelText.toLowerCase().toCharArray();
        int i4 = 0;
        while (i4 < charArray.length) {
            if (charArray[i4] != this.proceedButtonMnemonic.charValue() && charArray[i4] != this.cancelButtonMnemonic.charValue() && charArray[i4] != this.lookinMnemonic.charValue() && charArray[i4] != this.filenameMnemonic.charValue()) {
                this.filterMnemonic = new Character(charArray[i4]);
                break;
            }
            ++i4;
        }
    }

    protected boolean isSomethingSelected() {
        return this.filenameField.getText().length() > 0;
    }

    public TableDirectoryPane getDirectoryPane() {
        return this.directoryPane;
    }

    public void setDirectoryPane(TableDirectoryPane directoryPane) {
        if (directoryPane == null) {
            throw new IllegalArgumentException("FileChooserDialog can not have a null directoryPane.");
        }
        if (!(directoryPane instanceof TableDirectoryPane)) {
            throw new IllegalArgumentException("Wrong DirectoryPane type: FileChooserDialog only accepts a TableDirectoryPane");
        }
        this.directoryPane = directoryPane;
    }

    public void setAdditionalActionPanel(JPanel panel) {
        this.additionalActionPanel = panel;
    }

    public JPanel getAdditionalActionPanel() {
        return this.additionalActionPanel;
    }

    public void setAccessoryComponent(JComponent accessory) {
        this.accessory = accessory;
    }

    public JComponent getAccessoryComponent() {
        return this.accessory;
    }

    public void clearSelection() {
        this.filesToSelect = null;
        this.selectedFiles = null;
    }

    public void setSelectedFiles(File[] files) {
        this.filesToSelect = files;
    }

    public void setSelectedFile(File f) {
        if (f != null) {
            File[] files = new File[]{f};
            this.filesToSelect = files;
        } else {
            this.filesToSelect = null;
        }
    }

    public File[] getSelectedFiles() {
        return this.selectedFiles;
    }

    public File getSelectedFile() {
        return this.selectedFiles[this.selectedFiles.length - 1];
    }

    public void proceedSelection() {
        String filenames = this.filenameField.getText();
        if (filenames.equals("")) {
            this.firePropertyChange(NO_SELECTION, null, new File[0]);
            return;
        }
        if (filenames.indexOf(42) > -1) {
            this.directoryPane.setFileFilter(new PatternSearcher(this.directoryPane.getModel(), filenames));
        } else {
            Vector<File> notvalid = new Vector<File>();
            Vector<File> valid = new Vector<File>();
            StringTokenizer st = new StringTokenizer(filenames, this.multipleFileDelimiter);
            while (st.hasMoreTokens()) {
                File f;
                String filename = st.nextToken().trim();
                if (filename.length() == 0) continue;
                if (filename.indexOf(this.directoryPane.getFileSeparator()) > -1) {
                    f = this.directoryPane.createFileObject(filename);
                    if (this.directoryPane.getFileSelectionMode() == 1) {
                        if (this.directoryPane.isTraversable(f)) {
                            valid.addElement(f);
                            continue;
                        }
                        notvalid.addElement(f);
                        continue;
                    }
                    if (this.directoryPane.isTraversable(f)) {
                        this.directoryPane.setCurrentDirectory(f.getPath());
                        return;
                    }
                    if (this.directoryPane.doesFileExist(f)) {
                        valid.addElement(f);
                        continue;
                    }
                    notvalid.addElement(f);
                    continue;
                }
                f = this.directoryPane.createFileObject(this.directoryPane.getCurrentDirectory(), filename);
                if (this.directoryPane.getFileSelectionMode() == 1) {
                    if (this.directoryPane.isTraversable(f)) {
                        valid.addElement(f);
                        continue;
                    }
                    notvalid.addElement(f);
                    continue;
                }
                if (this.directoryPane.isTraversable(f)) {
                    this.directoryPane.setCurrentDirectory(f.getPath());
                    return;
                }
                if (this.directoryPane.doesFileExist(f)) {
                    valid.addElement(f);
                    continue;
                }
                notvalid.addElement(f);
            }
            this.selectedFiles = new File[valid.size()];
            valid.copyInto(this.selectedFiles);
            Object[] errorFiles = new File[notvalid.size()];
            notvalid.copyInto(errorFiles);
            if (this.selectedFiles.length > 0 && errorFiles.length == 0) {
                this.closeDialogAfterProceed();
            } else {
                this.firePropertyChange(ERROR_SELECTION, null, errorFiles);
            }
        }
    }

    private void closeDialogAfterProceed() {
        this.returnValue = 0;
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialogParent.validate();
        }
        this.directoryPane.clearSelection();
        this.filesToSelect = null;
        this.fireActionPerformed(PROCEED_SELECTION);
        this.firePropertyChange(PROCEED_SELECTION, null, this.selectedFiles);
    }

    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialogParent.validate();
        }
        this.directoryPane.clearSelection();
        this.filesToSelect = null;
        this.fireActionPerformed(CANCEL_SELECTION);
        this.firePropertyChange(CANCEL_SELECTION, null, new File[0]);
    }

    public void setDialogTitle(String title) {
        this.dialogTitle = title;
    }

    public void setLookinLabelText(String text) {
        this.lookinLabelText = text;
    }

    public void setFilenameLabelText(String text) {
        this.filenameLabelText = text;
    }

    public void setFilterLabelText(String text) {
        this.filterLabelText = text;
    }

    public void setProceedButtonText(String text) {
        this.proceedButtonText = text;
    }

    public void setCancelButtonText(String text) {
        this.cancelButtonText = text;
    }

    public void setProceedButtonMnemonic(char c) {
        this.proceedButtonMnemonic = new Character(c);
    }

    public void setCancelButtonMnemonic(char c) {
        this.cancelButtonMnemonic = new Character(c);
    }

    public File getCurrentDirectory() {
        return this.directoryPane.getCurrentDirectory();
    }

    public String getCurrentLocation() {
        return this.directoryPane.getCurrentLocation();
    }

    public String getUserLocation() {
        return this.directoryPane.getUserLocation();
    }

    public void setCurrentLocation(String dir) {
        this.locationToSet = dir;
    }

    public void setUserLocation(String dir) {
        this.directoryPane.setUserLocation(dir);
    }

    public void setAutoRefreshing(boolean refresh) {
        this.directoryPane.setAutoRefreshing(refresh);
    }

    public void setFileSorter(FileSorter sorter) {
        this.directoryPane.setFileSorter(sorter);
    }

    public void setFileSystem(FileSystem system) {
        this.directoryPane.setFileSystem(system);
    }

    public void setFileSelectionMode(int mode) {
        this.directoryPane.setFileSelectionMode(mode);
    }

    public void setFileHidingEnabled(boolean b) {
        this.directoryPane.setFileHidingEnabled(b);
    }

    public void setEditable(boolean b) {
        this.directoryPane.setEditable(b);
    }

    public void setMultiSelectionEnabled(boolean enabled) {
        this.directoryPane.setMultiSelectionEnabled(enabled);
    }

    public void removeChoosableFileFilter(FileFilter filter) {
        this.directoryPane.removeChoosableFileFilter(filter);
    }

    public void resetChoosableFileFilters() {
        this.directoryPane.resetChoosableFileFilters();
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.directoryPane.addChoosableFileFilter(filter);
    }

    public void setFileFilter(FileFilter filter) {
        this.directoryPane.setFileFilter(filter);
    }

    public void setFileView(FileView view) {
        this.directoryPane.setFileView(view);
    }

    public void setBackground(Color c) {
        this.directoryPane.setBackground(c);
    }

    public void setSelectionBackground(Color c) {
        this.directoryPane.setSelectionBackground(c);
    }

    public void setForeground(Color c) {
        this.directoryPane.setForeground(c);
    }

    public void setSelectionForeground(Color c) {
        this.directoryPane.setSelectionForeground(c);
    }

    public void setFont(Font f) {
        this.directoryPane.setFont(f);
    }

    public void setRowHeight(int h) {
        this.directoryPane.setRowHeight(h);
    }

    public void setPopupMenu(JPopupMenu p) {
        this.directoryPane.setPopupMenu(p);
    }

    public void removePopupMenu() {
        this.directoryPane.removePopupMenu();
    }

    public void setViewMode(String mode) {
        if (mode == null) {
            mode = "detailsview";
        }
        this.directoryPane.setViewMode(mode);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.directoryPane.addPropertyChangeListener(l);
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.directoryPane.removePropertyChangeListener(l);
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.directoryPane.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.directoryPane.removeListSelectionListener(l);
    }

    public void reset() {
        this.clearSelection();
        this.showGoHomeButton = true;
        this.showNewFolderButton = true;
        this.showViewModeButtons = true;
        this.accessory = null;
        this.additionalActionPanel = null;
        this.setRelativeLocationOffset(null);
        this.setMinimumSize(MIN_SIZE);
        this.setMaximumSize(MAX_SIZE);
        this.setPreferredSize(PREF_SIZE);
        this.setFileSelectionMode(2);
        this.setFileHidingEnabled(true);
        this.setFileView(null);
        this.setFileFilter(null);
        this.setEditable(true);
        this.setMultiSelectionEnabled(true);
        this.setBackground(null);
        this.setSelectionBackground(null);
        this.setForeground(null);
        this.setSelectionForeground(null);
        this.setFont(null);
        this.setRowHeight(-1);
        this.setViewMode(null);
        this.setAutoRefreshing(false);
        this.setFileSorter(new DefaultFileSorter());
        this.setCurrentLocation(null);
        this.setUserLocation(null);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = FileChooserDialog.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = FileChooserDialog.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ActionListener == null ? FileChooserDialog.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, command);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class ColumnWatcher
    implements PropertyChangeListener {
        protected ColumnWatcher() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object id = e.getSource();
            Object newvalue = e.getNewValue();
            String name = e.getPropertyName();
            if (name == "columWidth") {
                TableColumn col = (TableColumn)id;
                Object key = col.getIdentifier();
                Integer newwidth = (Integer)newvalue;
                Hashtable cache = FileChooserDialog.this.directoryPane.getColumnWidthCache();
                cache.put(key, newwidth);
            }
        }
    }

    protected class IsSomethingSelectedListener
    implements DocumentListener {
        protected IsSomethingSelectedListener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (FileChooserDialog.this.proceedButton != null) {
                FileChooserDialog.this.proceedButton.setEnabled(FileChooserDialog.this.isSomethingSelected());
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (FileChooserDialog.this.proceedButton != null) {
                FileChooserDialog.this.proceedButton.setEnabled(FileChooserDialog.this.isSomethingSelected());
            }
        }
    }

    protected class DialogListener
    extends WindowAdapter {
        protected DialogListener() {
        }

        public void windowClosing(WindowEvent e) {
            FileChooserDialog.this.cancelSelection();
        }

        public void windowOpened(WindowEvent e) {
            if (FileChooserDialog.this.getCurrentLocation().equals(FileChooserDialog.this.locationToSet)) {
                FileChooserDialog.this.directoryPane.refresh(FileChooserDialog.this.locationToSet);
            } else {
                FileChooserDialog.this.directoryPane.setCurrentLocation(FileChooserDialog.this.locationToSet);
                FileChooserDialog.this.filenameField.setSelectedFiles(FileChooserDialog.this.filesToSelect);
            }
        }
    }

    protected class FilenameFieldListener
    implements ActionListener {
        protected FilenameFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FileChooserDialog.this.proceedSelection();
        }
    }

    protected class ButtonActionListener
    implements ActionListener {
        protected ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(FileChooserDialog.CANCEL_SELECTION)) {
                FileChooserDialog.this.cancelSelection();
            } else if (command.equals(FileChooserDialog.PROCEED_SELECTION)) {
                FileChooserDialog.this.proceedSelection();
            }
        }
    }

    protected class DoubleClickListener
    implements ActionListener {
        protected DoubleClickListener() {
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals(FileChooserDialog.this.directoryPane.getDoubleClickCommand())) {
                FileChooserDialog.this.proceedSelection();
            }
        }
    }
}

