/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.DirectoryPane;
import com.hbworks.dirpane.plaf.mac.MacIconFactory;
import com.hbworks.dirpane.plaf.metal.MetalIconFactory;
import com.hbworks.dirpane.plaf.motif.MotifIconFactory;
import com.hbworks.dirpane.plaf.windows.WindowsIconFactory;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class NewFolderButton
extends JButton {
    static final long serialVersionUID = 5978469399572552890L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    DirectoryPane pane;

    public NewFolderButton() {
        this((DirectoryPane)null);
    }

    public NewFolderButton(DirectoryPane pane) {
        this.pane = pane;
        this.addActionListener(pane.getNewFolderAction());
        pane.addPropertyChangeListener(new DirectoryChangedListener());
        if (!pane.isEditable() || pane.isReadOnly(pane.getCurrentDirectory())) {
            this.setEnabled(false);
        }
    }

    public void setDirectoryPane(DirectoryPane newpane) {
        DirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        DirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        this.addActionListener(this.pane.getNewFolderAction());
        this.pane.addPropertyChangeListener(new DirectoryChangedListener());
        if (!this.pane.isEditable() || this.pane.isReadOnly(this.pane.getCurrentDirectory())) {
            this.setEnabled(false);
        }
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public DirectoryPane getDirectoryPane() {
        return this.pane;
    }

    public Icon getIcon() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (lf.getID().equals("Metal")) {
            return MetalIconFactory.getNewFolderIcon();
        }
        if (lf.getID().equals("Windows")) {
            return WindowsIconFactory.getNewFolderIcon();
        }
        if (lf.getID().equals("Motif")) {
            return MotifIconFactory.getNewFolderIcon();
        }
        if (lf.getID().equals("Platinum")) {
            return MacIconFactory.getNewFolderIcon();
        }
        return UIManager.getIcon("FileChooser.newFolderIcon");
    }

    public Icon getDisabledIcon() {
        try {
            Image image = ((ImageIcon)this.getIcon()).getImage();
            Image disabledImage = GrayFilter.createDisabledImage(image);
            return new ImageIcon(disabledImage);
        }
        catch (ClassCastException e) {
            return this.getIcon();
        }
    }

    public Insets getMargin() {
        return new Insets(1, 1, 1, 1);
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    class DirectoryChangedListener
    implements PropertyChangeListener {
        DirectoryChangedListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            File f;
            String name = e.getPropertyName();
            if ((name == "directoryChanged" || name == "syncSlaveDirectory") && (f = (File)e.getNewValue()) != null && NewFolderButton.this.pane.isEditable()) {
                if (NewFolderButton.this.pane.isReadOnly(f)) {
                    NewFolderButton.this.setEnabled(false);
                } else {
                    NewFolderButton.this.setEnabled(true);
                }
            }
        }
    }
}

