/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.CellEditorContainer;
import com.hbworks.dirpane.FileNameCellEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class TreeDirectoryPaneCellEditor
extends CellEditorContainer
implements ActionListener,
TreeSelectionListener {
    protected boolean canEdit;
    protected JTree tree;
    protected TreePath lastPath;
    protected Timer timer;

    public TreeDirectoryPaneCellEditor(JTree tree, JTextField editor, Component renderer) {
        super(null, renderer);
        this.setTree(tree);
        this.realEditor = new FileNameCellEditor(editor);
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.setTree(tree);
        TreePath newPath = tree.getPathForRow(row);
        Component returnValue = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        boolean bl = this.canEdit = this.lastPath != null && newPath != null && this.lastPath.equals(newPath);
        if (this.timer != null) {
            this.timer.stop();
        }
        return returnValue;
    }

    public boolean isCellEditable(EventObject event) {
        if (event == null || event instanceof MouseEvent && (SwingUtilities.isRightMouseButton((MouseEvent)event) || ((MouseEvent)event).getClickCount() > 2)) {
            return super.isCellEditable(event);
        }
        if (this.canEdit && ((MouseEvent)event).getClickCount() == 1) {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(false);
            }
            this.timer.start();
        }
        return false;
    }

    protected void setTree(JTree newTree) {
        if (this.tree != null) {
            this.tree.removeTreeSelectionListener(this);
        }
        this.tree = newTree;
        if (this.tree != null) {
            this.tree.addTreeSelectionListener(this);
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }
}

