/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.DefaultFileSorter;
import com.hbworks.dirpane.FileSorter;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.event.LoadingListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public abstract class FileSystemModel
implements Serializable,
PropertyChangeListener {
    protected transient FileSystem fileSystem;
    protected FileSorter fileSorter = null;
    protected File currentDirectory = null;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$hbworks$dirpane$event$LoadingListener;

    protected FileSystemModel() {
        this.fileSorter = new DefaultFileSorter();
        this.fileSystem = this.createFileSystem();
    }

    protected abstract FileSystem createFileSystem();

    protected abstract boolean deleteDirectory(File var1);

    public abstract void refresh();

    public abstract void refresh(File var1);

    public abstract void fileAdded(File var1);

    public abstract void fileDeleted(File var1);

    public abstract void fileRenamed(File var1, File var2);

    protected void setFileSorter(FileSorter fileSorter) {
        this.fileSorter = fileSorter;
    }

    protected FileSorter getFileSorter() {
        return this.fileSorter;
    }

    protected void setFileSystem(FileSystem newFileSystem) {
        this.fileSystem = newFileSystem;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public boolean belongsToFileSystem(File childFile) {
        boolean result = false;
        if (childFile != null) {
            File rootFile = this.getFileSystemRoot();
            File parentFile = childFile;
            do {
                if (!parentFile.equals(rootFile)) continue;
                result = true;
            } while ((parentFile = this.getParentDirectory(parentFile)) != null);
        }
        return result;
    }

    public boolean directoryCanBeCurrent(File newDir) {
        File curDir = this.getCurrentDirectory();
        if (!this.belongsToFileSystem(newDir)) {
            return false;
        }
        if (curDir == null) {
            return true;
        }
        if (newDir.equals(curDir)) {
            return false;
        }
        return this.isTraversable(newDir);
    }

    public boolean isCurrentDirectory(File dir) {
        if (this.currentDirectory == null) {
            return false;
        }
        if (dir == null) {
            return false;
        }
        String thisPath = this.currentDirectory.getPath();
        String thatPath = dir.getPath();
        return thisPath.equalsIgnoreCase(thatPath);
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    protected void setCurrentDirectory(File dir) {
        this.currentDirectory = dir;
    }

    public boolean isFileSystemRoot(File f) {
        return this.fileSystem.isFileSystemRoot(f);
    }

    public String getFileSeparator() {
        return this.fileSystem.getFileSeparator();
    }

    public File getFileSystemRoot() {
        return this.fileSystem.getFileSystemRoot();
    }

    public boolean isHiddenFile(File f) {
        return this.fileSystem.isHiddenFile(f);
    }

    public File getHomeDirectory() {
        return this.fileSystem.getHomeDirectory();
    }

    public File getWorkingDirectory() {
        return this.fileSystem.getWorkingDirectory();
    }

    public File getParentDirectory(File dir) {
        return this.fileSystem.getParentDirectory(dir);
    }

    protected void setFileSubType(Class type) {
        this.fileSystem.setFileSubType(type);
    }

    public Class getFileSubType() {
        return this.fileSystem.getFileSubType();
    }

    public int getDirectoryType(File dir) {
        return this.fileSystem.getDirectoryType(dir);
    }

    public File createFileObject(String path) {
        return this.fileSystem.createFileObject(path);
    }

    public File createFileObject(String path, String name) {
        return this.fileSystem.createFileObject(path, name);
    }

    public File createFileObject(File dir, String filename) {
        return this.fileSystem.createFileObject(dir, filename);
    }

    public File loadIntoFileSystem(Object obj, File parentDir, boolean overwritePermissionGranted) throws IOException {
        File newFile = null;
        newFile = this.fileSystem.loadIntoFileSystem(obj, parentDir, overwritePermissionGranted);
        if (newFile != null) {
            this.fileAdded(newFile);
        }
        return newFile;
    }

    public Object retrieveFromFileSystem(File holder) throws IOException {
        return this.fileSystem.retrieveFromFileSystem(holder);
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        return this.fileSystem.getFiles(dir, useFileHiding);
    }

    public boolean doesFileExist(File file) {
        return this.fileSystem.doesFileExist(file);
    }

    public boolean isReadOnly(File file) {
        return this.fileSystem.isReadOnly(file);
    }

    public boolean isProtected(File file) {
        return this.fileSystem.isProtected(file);
    }

    public boolean isTraversable(File file) {
        return this.fileSystem.isTraversable(file);
    }

    public boolean isRegularFile(File file) {
        return this.fileSystem.isRegularFile(file);
    }

    public boolean isAbsolute(File file) {
        return this.fileSystem.isAbsolute(file);
    }

    public long getLength(File file) {
        return this.fileSystem.getLength(file);
    }

    public String getAbsolutePath(File file) {
        return this.fileSystem.getAbsolutePath(file);
    }

    public String getCanonicalPath(File file) throws IOException {
        return this.fileSystem.getCanonicalPath(file);
    }

    public long getLastModifiedTime(File file) {
        return this.fileSystem.getLastModifiedTime(file);
    }

    public boolean createDirectory(File file) {
        boolean created = this.fileSystem.createDirectory(file);
        if (created) {
            this.fileAdded(file);
        }
        return created;
    }

    public boolean createDirectories(File file) {
        boolean created = this.fileSystem.createDirectories(file);
        if (created) {
            this.fileAdded(file);
        }
        return created;
    }

    public boolean deleteFile(File file) {
        boolean deleted = this.fileSystem.deleteFile(file);
        if (deleted) {
            this.fileDeleted(file);
        }
        return deleted;
    }

    public boolean renameFile(File file, File dest) {
        boolean renamed = this.fileSystem.renameFile(file, dest);
        if (renamed) {
            this.fileRenamed(file, dest);
        }
        return renamed;
    }

    public synchronized void addLoadingListener(LoadingListener l) {
        this.listenerList.add(class$com$hbworks$dirpane$event$LoadingListener == null ? (class$com$hbworks$dirpane$event$LoadingListener = FileSystemModel.class$("com.hbworks.dirpane.event.LoadingListener")) : class$com$hbworks$dirpane$event$LoadingListener, l);
    }

    public synchronized void removeLoadingListener(LoadingListener l) {
        this.listenerList.remove(class$com$hbworks$dirpane$event$LoadingListener == null ? (class$com$hbworks$dirpane$event$LoadingListener = FileSystemModel.class$("com.hbworks.dirpane.event.LoadingListener")) : class$com$hbworks$dirpane$event$LoadingListener, l);
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

