/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.grammar.Action;
import groove.lts.GraphTransition;
import groove.verify.ProductState;

public class ProductTransition {
    private final GraphTransition graphTransition;
    private final ProductState source;
    private final ProductState target;
    private static int transitionCount;

    public ProductTransition(ProductState source, GraphTransition transition, ProductState target) {
        this.source = source;
        this.graphTransition = transition;
        this.target = target;
        ++transitionCount;
    }

    public GraphTransition graphTransition() {
        return this.graphTransition;
    }

    public ProductState source() {
        return this.source;
    }

    public ProductState target() {
        return this.target;
    }

    public Action rule() {
        return this.graphTransition().getAction();
    }

    public int hashCode() {
        int result = 0;
        result += this.source().hashCode() + this.target().hashCode();
        if (this.graphTransition() != null) {
            result += this.graphTransition().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (!(obj instanceof ProductTransition)) {
            return false;
        }
        ProductTransition other = (ProductTransition)obj;
        return this.equalsSource(other) && this.equalsTransition(other);
    }

    protected boolean equalsSource(ProductTransition other) {
        return this.source() == other.source();
    }

    protected boolean equalsTransition(ProductTransition other) {
        return this.graphTransition().equals(other.graphTransition().source());
    }

    public String toString() {
        return String.valueOf(this.source().toString()) + "-->" + this.target.toString();
    }

    public static int getTransitionCount() {
        return transitionCount;
    }
}

