/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import groove.explore.Generator;
import groove.lts.GTS;
import groove.util.CommandLineTool;
import groove.verify.DefaultMarker;
import groove.verify.Formula;
import groove.verify.FormulaParser;
import groove.verify.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CTLModelChecker
extends CommandLineTool {
    public static final String USAGE_MESSAGE = "Usage: ModelChecker <grammar-location> [property] [-g [generator-options]]";
    private static final String QUIT_OPTION = "Q";
    private Generator generator;
    private String[] genArgs = null;
    private GTS gts;
    private Formula property;
    private List<Formula> properties;
    private DefaultMarker marker;

    public static void main(String[] args) {
        LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
        int splitPoint = argList.indexOf("-g");
        if (splitPoint < 0) {
            System.err.printf(USAGE_MESSAGE, new Object[0]);
        } else {
            LinkedList<String> checkerArgs = new LinkedList<String>(argList.subList(0, splitPoint));
            LinkedList<String> genArgs = new LinkedList<String>(argList.subList(splitPoint + 1, argList.size()));
            CTLModelChecker verifier = new CTLModelChecker(checkerArgs, genArgs);
            verifier.start();
        }
    }

    public CTLModelChecker(List<String> checkerArgs, List<String> genArgs) {
        super(checkerArgs.toArray(new String[0]));
        this.genArgs = genArgs.toArray(new String[0]);
        this.properties = new LinkedList<Formula>();
    }

    public void start() {
        this.processArguments();
        this.generator = new Generator(this.genArgs);
        this.generator.start();
        this.gts = this.generator.getGTS();
        this.marker = new DefaultMarker(this.property, this.gts);
        long startTime = System.currentTimeMillis();
        while (this.properties.size() > 0) {
            this.setProperty(this.properties.remove(0));
            System.out.println("Checking CTL formula: " + this.property);
            this.marker.verify();
            if (this.marker.hasValue(false)) {
                System.out.println("The model violates the given property.");
                continue;
            }
            System.out.println("The model satisfies the given property.");
        }
        long endTime = System.currentTimeMillis();
        long mcTime = endTime - startTime;
        this.println("** Model Checking Time (ms):\t" + mcTime);
        this.println("** Total Running Time (ms):\t" + (this.generator.getRunningTime() + mcTime));
    }

    @Override
    public void processArguments() {
        List<String> argsList = this.getArgs();
        while (argsList.size() > 1) {
            this.addProperty(argsList.remove(1));
        }
        if (argsList.size() == 0) {
            this.printError("No grammar location specified", true);
        }
    }

    @Override
    protected boolean supportsLogOption() {
        return false;
    }

    @Override
    protected boolean supportsOutputOption() {
        return false;
    }

    @Override
    protected boolean supportsVerbosityOption() {
        return false;
    }

    public void addProperty(String property) {
        try {
            this.properties.add(FormulaParser.parse(property).toCtlFormula());
        }
        catch (ParseException efe) {
            this.print("Format error in property: " + efe.getMessage());
        }
    }

    public void setProperty(Formula property) {
        this.property = property;
    }

    public boolean nextProperty() {
        boolean result = false;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter CTL-expression (or 'Q' to quit):\n> ");
            String expression = in.readLine();
            if (!expression.equals(QUIT_OPTION)) {
                this.setProperty(FormulaParser.parse(expression).toCtlFormula());
                result = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException parseException) {
            System.err.println("Wrong format. Retry.");
            return this.nextProperty();
        }
        return result;
    }

    @Override
    protected String getUsageMessage() {
        return USAGE_MESSAGE;
    }
}

