/*
 * Decompiled with CFR 0.152.
 */
package groove.verify;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Guard;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTL2Buchi;
import groove.graph.AGraph;
import groove.graph.GraphRole;
import groove.gui.dialog.GraphPreviewDialog;
import groove.util.collect.NestedIterator;
import groove.util.collect.TransformIterator;
import groove.verify.BuchiLabel;
import groove.verify.BuchiLocation;
import groove.verify.BuchiTransition;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BuchiGraph
extends AGraph<BuchiLocation, BuchiTransition>
implements Cloneable {
    private final Set<BuchiLocation> locations = new HashSet<BuchiLocation>();
    private BuchiLocation initial;
    private static final boolean DEBUG = false;

    private BuchiGraph(String name) {
        super(name);
    }

    @Override
    public Set<BuchiLocation> nodeSet() {
        return this.locations;
    }

    @Override
    public Set<? extends BuchiTransition> edgeSet() {
        return new TransitionSet();
    }

    @Override
    public BuchiGraph newGraph(String name) {
        return new BuchiGraph(name);
    }

    @Override
    public boolean addNode(BuchiLocation node) {
        return this.locations.add(node);
    }

    @Override
    public boolean removeEdge(BuchiTransition edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addEdge(BuchiTransition edge) {
        return ((BuchiLocation)edge.source()).addTransition(edge);
    }

    @Override
    public boolean removeNode(BuchiLocation node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.BUCHI;
    }

    @Override
    public BuchiGraph clone() {
        BuchiGraph result = this.newGraph(this.getName());
        result.setInitial(this.getInitial());
        for (BuchiLocation buchiLocation : this.nodeSet()) {
            result.addNode(buchiLocation);
        }
        for (BuchiTransition buchiTransition : this.edgeSet()) {
            result.addEdgeContext(buchiTransition);
        }
        return result;
    }

    public BuchiGraph newBuchiGraph(Formula<String> formula) {
        BuchiGraph result = new BuchiGraph(formula.toString());
        Graph graph = LTL2Buchi.translate(formula);
        this.newBuchiGraph((Graph<String>)graph, result);
        return result;
    }

    private void newBuchiGraph(Graph<String> graph, BuchiGraph result) {
        HashMap<Node<String>, BuchiLocation> node2location = new HashMap<Node<String>, BuchiLocation>();
        Node init = graph.getInit();
        if (init == null) {
            init = new Node(graph);
        }
        result.setInitial(this.getLocation(node2location, (Node<String>)init));
        HashSet<Node> newNodes = new HashSet<Node>();
        newNodes.add(init);
        while (!newNodes.isEmpty()) {
            Iterator newNodeIter = newNodes.iterator();
            Node node = (Node)newNodeIter.next();
            newNodeIter.remove();
            BuchiLocation location = this.getLocation(node2location, (Node<String>)node);
            if (result.nodeSet().contains(location)) continue;
            if (node.getAttributes().getBoolean("accepting")) {
                location.setAccepting();
            }
            result.addNode(location);
            for (Edge edge : node.getOutgoingEdges()) {
                assert (edge.getSource().equals(node));
                BuchiLabel label = new BuchiLabel(edge.getAction(), (Guard<String>)edge.getGuard());
                Node target = edge.getNext();
                BuchiTransition transition = new BuchiTransition(location, label, this.getLocation(node2location, (Node<String>)target));
                result.addEdge(transition);
                newNodes.add(target);
            }
        }
    }

    public void display() {
        GraphPreviewDialog.showGraph(this);
    }

    private BuchiLocation getLocation(Map<Node<String>, BuchiLocation> node2location, Node<String> node) {
        BuchiLocation result = node2location.get(node);
        if (result == null) {
            result = new BuchiLocation(node2location.size());
            node2location.put(node, result);
        }
        return result;
    }

    public BuchiLocation getInitial() {
        return this.initial;
    }

    public void setInitial(BuchiLocation location) {
        this.initial = location;
    }

    public static BuchiGraph getPrototype() {
        return new BuchiGraph("");
    }

    private class TransitionSet
    extends AbstractSet<BuchiTransition> {
        private TransitionSet() {
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof BuchiTransition) {
                BuchiTransition trans = (BuchiTransition)o;
                return ((BuchiLocation)trans.source()).outTransitions().contains(o);
            }
            return false;
        }

        @Override
        public Iterator<BuchiTransition> iterator() {
            return new NestedIterator<BuchiTransition>(new TransformIterator<BuchiLocation, Iterator<BuchiTransition>>(BuchiGraph.this.nodeSet().iterator()){

                @Override
                protected Iterator<BuchiTransition> toOuter(BuchiLocation from) {
                    return from.outTransitions().iterator();
                }
            });
        }

        @Override
        public int size() {
            int result = 0;
            for (BuchiLocation state : BuchiGraph.this.nodeSet()) {
                result += state.outTransitions().size();
            }
            return result;
        }
    }
}

