/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin.graph;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Node;
import groove.prolog.builtin.graph.GraphPrologCode;
import groove.prolog.util.PrologUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class Predicate_node_self_edges
extends GraphPrologCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            SelfEdgesBacktrackInfo bi = (SelfEdgesBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        SelfEdgesBacktrackInfo bi = new SelfEdgesBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.graph = Predicate_node_self_edges.getGraph(args[0]);
        bi.nodes = bi.graph.nodeSet().iterator();
        bi.argNode = args[1];
        if (args[2] instanceof VariableTerm) {
            bi.argList = args[2];
        } else if (args[2] instanceof CompoundTerm) {
            bi.labels = new ArrayList<String>();
            LinkedHashSet<Term> termSet = new LinkedHashSet<Term>();
            PrologUtils.getTermSet(args[2], termSet);
            for (Term term : termSet) {
                if (term instanceof AtomTerm) {
                    bi.labels.add(((AtomTerm)term).value);
                    continue;
                }
                PrologException.typeError((AtomTerm)TermConstants.atomAtom, (Term)term);
            }
        } else {
            PrologException.typeError((AtomTerm)TermConstants.compoundAtom, (Term)args[2]);
        }
        return this.nextSolution(interpreter, bi);
    }

    /*
     * Could not resolve type clashes
     */
    protected int nextSolution(Interpreter interpreter, SelfEdgesBacktrackInfo bi) throws PrologException {
        while (bi.nodes.hasNext()) {
            int rc;
            Term lblList;
            int rc2;
            Node n = bi.nodes.next();
            ArrayList<String> edgeLabels = new ArrayList<String>();
            for (Edge edge : bi.graph.outEdgeSet(n)) {
                if (edge.target() != n || edge.source() != n) continue;
                edgeLabels.add(edge.label().text());
            }
            if (bi.labels != null) {
                if (!this.isValidList(bi.labels, edgeLabels)) {
                    continue;
                }
            } else if (bi.argList != null && (rc2 = interpreter.unify(bi.argList, lblList = CompoundTerm.getList(PrologUtils.createJOTlist(edgeLabels)))) == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            if ((rc = interpreter.unify(bi.argNode, (Term)new JavaObjectTerm((Object)n))) == -1) {
                interpreter.undo(bi.startUndoPosition);
                continue;
            }
            interpreter.pushBacktrackInfo((BacktrackInfo)bi);
            return 0;
        }
        return -1;
    }

    protected boolean isValidList(List<String> testSet, List<String> curSet) {
        return curSet.containsAll(testSet);
    }

    private static class SelfEdgesBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        Graph graph;
        Iterator<? extends Node> nodes;
        List<String> labels;
        Term argNode;
        Term argList;

        SelfEdgesBacktrackInfo() {
            super(-1, -1);
        }
    }
}

