/*
 * Decompiled with CFR 0.152.
 */
package groove.prolog.builtin;

import gnu.prolog.term.CompoundTermTag;
import groove.annotation.Help;
import groove.annotation.Signature;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipPars;
import groove.io.HTMLConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class GroovePredicates {
    private StringBuilder text;
    private Map<CompoundTermTag, String> definitions;
    private Map<CompoundTermTag, String> toolTipMap;

    protected void s(String line) {
        this.text.append(line);
        this.text.append('\n');
    }

    public Map<CompoundTermTag, String> getDefinitions() {
        if (this.definitions == null) {
            this.toolTipMap = new HashMap<CompoundTermTag, String>();
            this.definitions = new HashMap<CompoundTermTag, String>();
            Method[] methodArray = this.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.isAnnotationPresent(Signature.class)) {
                    try {
                        this.text = new StringBuilder();
                        method.invoke((Object)this, new Object[0]);
                        this.definitions.put(this.getTag(method.getName()), this.text.toString());
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    this.addToolTipText(method);
                }
                ++n2;
            }
        }
        return this.definitions;
    }

    public Map<CompoundTermTag, String> getToolTipMap() {
        if (this.toolTipMap == null) {
            this.getDefinitions();
        }
        return this.toolTipMap;
    }

    private void addToolTipText(Method method) {
        CompoundTermTag tag = this.getTag(method.getName());
        Signature sig = method.getAnnotation(Signature.class);
        ToolTipBody tip = method.getAnnotation(ToolTipBody.class);
        ToolTipPars param = method.getAnnotation(ToolTipPars.class);
        this.toolTipMap.put(tag, GroovePredicates.newCreateToolTipText(tag, sig, tip, param).getTip());
    }

    private CompoundTermTag getTag(String methodName) {
        int arity;
        int arityPos = methodName.lastIndexOf(95);
        if (arityPos < 0) {
            throw new IllegalArgumentException(String.format("Predicate method name %s should end on '_i' (where i is the arity)", methodName));
        }
        String functorName = methodName.substring(0, arityPos);
        try {
            arity = Integer.parseInt(methodName.substring(arityPos + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(String.format("Predicate method name %s should end on '_i' (where i is the arity)", methodName));
        }
        return CompoundTermTag.get((String)functorName, (int)arity);
    }

    public static Help newCreateToolTipText(CompoundTermTag tag, Signature sigAnn, ToolTipBody toolTip, ToolTipPars param) {
        Help result = new Help();
        if (sigAnn != null) {
            String name = tag.functor.toString();
            int arity = tag.arity;
            String[] sigValue = sigAnn.value();
            if (sigValue.length <= arity) {
                throw new IllegalStateException(String.format("Malformed annotation %s for %s/%s: insufficient arguments", sigAnn, name, arity));
            }
            StringBuilder header = new StringBuilder();
            int i = arity;
            while (i < sigValue.length) {
                String io = sigValue[i];
                if (io.length() != arity) {
                    throw new IllegalStateException(String.format("Malformed annodation %s for %s/%s: incorrect IO spec %s", sigAnn, name, arity, io));
                }
                StringBuilder sigText = new StringBuilder();
                sigText.append(name);
                sigText.append('(');
                int p = 0;
                while (p < arity) {
                    if (p > 0) {
                        sigText.append(", ");
                    }
                    sigText.append(Help.it(String.valueOf(io.charAt(p)) + sigValue[p]));
                    ++p;
                }
                sigText.append(')');
                if (header.length() > 0) {
                    header.append(HTMLConverter.HTML_LINEBREAK);
                }
                header.append((CharSequence)sigText);
                ++i;
            }
            result.setHeader(header.toString());
            if (toolTip != null) {
                result.setBody(toolTip.value());
            }
            ArrayList<String> parNames = new ArrayList<String>();
            int p = 0;
            while (p < arity) {
                parNames.add(sigValue[p]);
                ++p;
            }
            result.setParNames(parNames);
            if (param != null) {
                result.setPars(param.value());
            }
        }
        return result;
    }
}

