/*
 * Decompiled with CFR 0.152.
 */
package groove.match.rete;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleLabel;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.match.rete.AbstractReteMatch;
import groove.match.rete.AtomPathChecker;
import groove.match.rete.DefaultNodeChecker;
import groove.match.rete.EdgeCheckerNode;
import groove.match.rete.EmptyPathChecker;
import groove.match.rete.ReteNetwork;
import groove.match.rete.ReteNetworkNode;
import groove.match.rete.SingleEdgePathChecker;
import groove.match.rete.ValueNodeChecker;
import groove.util.collect.TreeHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RootNode
extends ReteNetworkNode {
    private Map<String, Set<EdgeCheckerNode>> positiveEdgeCheckers = new HashMap<String, Set<EdgeCheckerNode>>();
    private Set<EdgeCheckerNode> openEdgeCheckers = new TreeHashSet<EdgeCheckerNode>();
    private Set<EdgeCheckerNode> otherEdgeCheckers = new TreeHashSet<EdgeCheckerNode>();
    private Map<String, Set<SingleEdgePathChecker>> positivePathCheckers = new HashMap<String, Set<SingleEdgePathChecker>>();
    private Set<SingleEdgePathChecker> otherPathCheckers = new TreeHashSet<SingleEdgePathChecker>();
    private HashMap<TypeNode, Collection<DefaultNodeChecker>> defaultNodeCheckers = null;
    private DefaultNodeChecker theOnlyNodeChecker = null;

    public RootNode(ReteNetwork network) {
        super(network);
    }

    @Override
    public void addSuccessor(ReteNetworkNode nnode) {
        boolean isValid;
        boolean bl = isValid = nnode instanceof EdgeCheckerNode || nnode instanceof DefaultNodeChecker || nnode instanceof SingleEdgePathChecker || nnode instanceof EmptyPathChecker || nnode instanceof ValueNodeChecker;
        assert (isValid);
        if (isValid && !this.isAlreadySuccessor(nnode)) {
            this.getSuccessors().add(nnode);
            nnode.addAntecedent(this);
            if (nnode instanceof DefaultNodeChecker) {
                if (this.defaultNodeCheckers == null) {
                    this.addDefaultNodeChecker((DefaultNodeChecker)nnode);
                    this.theOnlyNodeChecker = (DefaultNodeChecker)nnode;
                } else {
                    this.theOnlyNodeChecker = null;
                    this.addDefaultNodeChecker((DefaultNodeChecker)nnode);
                }
            } else if (nnode instanceof EdgeCheckerNode) {
                EdgeCheckerNode ec = (EdgeCheckerNode)nnode;
                if (!ec.isWildcardEdge() || ec.isPositiveWildcard() && ec.isWildcardGuarded()) {
                    this.addPositiveEdgeChecker(ec);
                } else if (ec.isWildcardEdge() && !ec.isPositiveWildcard()) {
                    this.otherEdgeCheckers.add(ec);
                } else if (ec.isWildcardEdge() && !ec.isWildcardGuarded()) {
                    this.openEdgeCheckers.add(ec);
                }
            } else if (nnode instanceof SingleEdgePathChecker) {
                SingleEdgePathChecker pathChecker = (SingleEdgePathChecker)nnode;
                if (nnode instanceof AtomPathChecker) {
                    this.addPositivePathChecker((AtomPathChecker)pathChecker);
                } else {
                    this.otherPathCheckers.add(pathChecker);
                }
            }
        }
    }

    private void addDefaultNodeChecker(DefaultNodeChecker nnode) {
        Collection<DefaultNodeChecker> ncs;
        Collection<DefaultNodeChecker> nodeCheckers;
        if (this.defaultNodeCheckers == null) {
            this.defaultNodeCheckers = new HashMap();
        }
        if ((nodeCheckers = this.defaultNodeCheckers.get(nnode.getType())) == null) {
            nodeCheckers = new TreeHashSet<DefaultNodeChecker>();
            for (TypeNode superType : nnode.getType().getSubtypes()) {
                ncs = this.defaultNodeCheckers.get(superType);
                if (ncs == null) continue;
                nodeCheckers.addAll(ncs);
            }
        }
        if (!nodeCheckers.contains(nnode)) {
            nodeCheckers.add(nnode);
        }
        for (TypeNode subType : nnode.getType().getSubtypes()) {
            ncs = this.defaultNodeCheckers.get(subType);
            if (ncs == null || ncs.contains(nnode)) continue;
            ncs.add(nnode);
        }
    }

    public void receiveNode(HostNode elem, ReteNetworkNode.Action action) {
        Collection<DefaultNodeChecker> dncc;
        if (this.theOnlyNodeChecker != null) {
            this.theOnlyNodeChecker.receiveNode(elem, action);
        } else if (this.defaultNodeCheckers != null && (dncc = this.defaultNodeCheckers.get(elem.getType())) != null) {
            for (DefaultNodeChecker nc : dncc) {
                nc.receiveNode(elem, action);
            }
        }
    }

    public void receiveEdge(HostEdge elem, ReteNetworkNode.Action action) {
        Set<EdgeCheckerNode> edgeCheckers = this.positiveEdgeCheckers.get(elem.label().text());
        if (edgeCheckers != null) {
            for (EdgeCheckerNode ec : edgeCheckers) {
                assert (ec.isAcceptingLabel(elem.getType()));
                ec.receiveEdge(this, elem, action);
            }
        }
        for (EdgeCheckerNode ec : this.openEdgeCheckers) {
            ec.receiveEdge(this, elem, action);
        }
        for (EdgeCheckerNode ec : this.otherEdgeCheckers) {
            if (!ec.isAcceptingLabel(elem.getType())) continue;
            ec.receiveEdge(this, elem, action);
        }
        Set<SingleEdgePathChecker> pathCheckers = this.positivePathCheckers.get(elem.label().text());
        if (pathCheckers != null) {
            for (SingleEdgePathChecker pc : pathCheckers) {
                pc.receive((ReteNetworkNode)this, elem, action);
            }
        }
        for (SingleEdgePathChecker pc : this.otherPathCheckers) {
            pc.receive((ReteNetworkNode)this, elem, action);
        }
    }

    @Override
    public boolean equals(ReteNetworkNode node) {
        return this == node;
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public RuleElement[] getPattern() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean demandUpdate() {
        return true;
    }

    @Override
    public boolean isUpToDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int demandOneMatch() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void passDownMatchToSuccessors(AbstractReteMatch m) {
        throw new UnsupportedOperationException();
    }

    private void addPositiveEdgeChecker(EdgeCheckerNode edgeChecker) {
        if (!edgeChecker.isWildcardEdge()) {
            String atomLabel = ((RuleLabel)edgeChecker.getEdge().label()).text();
            Set<EdgeCheckerNode> s = this.positiveEdgeCheckers.get(atomLabel);
            if (s == null) {
                s = new TreeHashSet<EdgeCheckerNode>();
                this.positiveEdgeCheckers.put(atomLabel, s);
            }
            s.add(edgeChecker);
        } else {
            assert (edgeChecker.isPositiveWildcard() && edgeChecker.isWildcardGuarded());
            Set<TypeLabel> labels = ((RuleLabel)edgeChecker.getEdge().label()).getMatchExpr().getTypeLabels();
            for (TypeLabel l : labels) {
                String atomLabel = l.text();
                Set<EdgeCheckerNode> s = this.positiveEdgeCheckers.get(atomLabel);
                if (s == null) {
                    s = new TreeHashSet<EdgeCheckerNode>();
                    this.positiveEdgeCheckers.put(atomLabel, s);
                }
                s.add(edgeChecker);
            }
        }
    }

    private void addPositivePathChecker(AtomPathChecker pathChecker) {
        String atomLabel = pathChecker.getExpression().getAtomText();
        assert (atomLabel != null);
        Set<SingleEdgePathChecker> s = this.positivePathCheckers.get(atomLabel);
        if (s == null) {
            s = new TreeHashSet<SingleEdgePathChecker>();
            this.positivePathCheckers.put(atomLabel, s);
        }
        s.add(pathChecker);
    }

    @Override
    public void receive(ReteNetworkNode source, int repeatIndex, AbstractReteMatch subgraph) {
        throw new UnsupportedOperationException();
    }
}

